@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5>Credit sales whose due date has passed</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">
        @php
            $totaldebt = 0;
        @endphp
        <div class="card">

            <div class="card-body">

                <table id="example1" class="table table-bordered table-striped" style="text-align: center;">

                    <thead>

                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Amount due</th>
                            <th>Due date</th>
                            <th>User</th>
                        </tr>

                    </thead>

                    <tbody>

                        @foreach ($madeni as $deni)
                            @php
                                $totaldebt = App\Models\Sale::where('status', 'credit')
                                    ->where('duedate', '<', date('Y-m-d'))
                                    ->sum('due');
                            @endphp
                            <tr>
                                <td>{{ $deni->date }}</td>
                                <td>{{ $deni->customer }}</td>
                                <td><a href="{{ route('fetch.customer.debt', $deni->id) }}">{{ $deni->due }}</a>
                                </td>
                                </td>
                                <td>{{ $deni->duedate }}</td>
                                <td>{{ $deni->user }}</td>
                            </tr>

                            {{-- @endforeach --}}
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Total ({{ $totaldebt }})</th>
                            <th>Due date</th>
                            <th>User</th>
                        </tr>


                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
    </script>
@endsection

@endsection
