@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            <div class="card-title">
                <table>
                    <thead>
                        <form action="{{ route('profile.view') }}" method="get" class="was-validated">
                            <th><select name="location" id="location" class="form-control" required>
                                    <option disabled selected value="">-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->id }}">-- {{ $selling->location->name }} -- </option>
                                    @endforeach
                                </select></th>

                            <th><button class="btn btn-primary"><i class="fa-solid fa-magnifying-glass"></i>
                                    Search</button></th>
                        </form>

                        <th>
                            @foreach ($profileData as $profile)
                                <!-- Button trigger modal -->
                                <button type="button" class="btn btn-success" data-toggle="modal"
                                    data-target="#update-{{ $profile->id }}"><i
                                        class="fa-solid fa-pen-to-square fa-lg"></i>
                                    Update Business Profile
                                </button>

                                <!-- Modal -->
                                <div class="modal fade" id="update-{{ $profile->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h6 class="modal-title" id="exampleModalLabel">Update Business
                                                    Profile
                                                </h6>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="{{ route('update.profile', $profile->id) }}" method="POST"
                                                enctype="multipart/form-data" class="was-validated">
                                                @csrf

                                                <div class="modal-body">
                                                    <label for="name">Name</label>
                                                    <input type="text" name="name" id="name" class="form-control"
                                                        value="{{ $profile->selling->location->name }}" required>

                                                    <label for="address">Address</label>
                                                    <input type="text" name="address" id="address" class="form-control"
                                                        value="{{ $profile->address }}" required>

                                                    <label for="phone">Phone</label>
                                                    <input type="text" name="phone" id="phone" class="form-control"
                                                        value="{{ $profile->phone }}" required>

                                                    <label for="email">Email</label>
                                                    <input type="email" name="email" id="email" class="form-control"
                                                        value="{{ $profile->email }}">

                                                    <label for="website">website</label>
                                                    <input type="text" name="website" id="website" class="form-control"
                                                        value="{{ $profile->website }}">

                                                    <label for="tin">Tin #</label>
                                                    <input type="text" name="tin" id="tin" class="form-control"
                                                        value="{{ $profile->tin }}">

                                                    <label for="vrn">VRN #</label>
                                                    <input type="text" name="vrn" id="vrn" class="form-control"
                                                        value="{{ $profile->vrn }}">

                                                    <label for="slogan">Slogan</label>
                                                    <input type="text" name="slogan" id="slogan" class="form-control"
                                                        value="{{ $profile->slogan }}">

                                                    <label for="logo">Logo</label>
                                                    <div class="input-group mb-3">
                                                        <div class="custom-file">
                                                            <input type="file" name="logo" id="logo"
                                                                class="custom-file-input"
                                                                accept=".jpg,.jpeg,.png,.gif,.bmp,.svg,.webp,.tiff,.ico"
                                                                onchange="document.getElementById('logo-label-{{ $profile->id }}').innerText = this.files[0]?.name || 'Choose file';">
                                                            <label class="custom-file-label" for="logo"
                                                                id="logo-label-{{ $profile->id }}">Choose file</label>
                                                        </div>
                                                    </div>

                                                    <label for="vat">VAT status</label>
                                                    <select name="vat" id="vat" class="form-control" required>
                                                        <option value="Inclusive"
                                                            {{ $profile->vat == 'Inclusive' ? 'selected' : '' }}>--
                                                            Inclusive --</option>
                                                        <option value="Exclusive"
                                                            {{ $profile->vat == 'Exclusive' ? 'selected' : '' }}>--
                                                            Exclusive --</option>
                                                    </select>

                                                    <label for="receipt">Receipt Setting</label>
                                                    <select name="receipt" id="receipt" class="form-control" required>
                                                        <option value="Yes"
                                                            {{ $profile->receipt === 'Yes' ? 'selected' : '' }}>-- Print
                                                            Receipt --</option>
                                                        <option value="No"
                                                            {{ $profile->receipt === 'No' ? 'selected' : '' }}>-- Don't
                                                            print Receipt --</option>
                                                    </select>

                                                    {{-- 🆕 Royalty Rule Setting --}}
                                                    <label for="royalty">Royalty Setting</label>
                                                    <select name="royalty" id="royalty" class="form-control" required>
                                                        <option value="0"
                                                            {{ $profile->royalty == 0 ? 'selected' : '' }}>-- Disable --
                                                        </option>
                                                        <option value="1"
                                                            {{ $profile->royalty == 1 ? 'selected' : '' }}>-- Enable --
                                                        </option>
                                                    </select>

                                                    {{-- 🆕 Royalty Discount  --}}
                                                    <div id="royalty_discount_wrapper"
                                                        style="display: {{ $profile->royalty == 1 ? 'block' : 'none' }}; margin-top:10px;">
                                                        <label for="royalty_discount">Royalty Discount</label>
                                                        <input type="number" name="royalty_discount"
                                                            id="royalty_discount" class="form-control" min="1"
                                                            max="100" value="{{ $profile->royalty_discount ?? 0 }}"
                                                            placeholder="Enter discount (optional)">
                                                    </div>

                                                    {{-- 🆕 Batch #  Setting --}}
                                                    <label for="Batch.No">Batch.No Setting</label>
                                                    <select name="batch_no" id="batch_no" class="form-control">
                                                        <option value="0"
                                                            {{ $profile->batch_no == 0 ? 'selected' : '' }}>--
                                                            Disabled --</option>
                                                        <option value="1"
                                                            {{ $profile->batch_no == 1 ? 'selected' : '' }}>--
                                                            Enabled --</option>
                                                    </select>
                                                    {{-- 🆕 QR Code on receipt  Setting --}}
                                                    <label for="Qrcode">QR Code Setting</label>
                                                    <select name="qrcode" id="qrcode" class="form-control">
                                                        <option value="0"
                                                            {{ $profile->qrcode == 0 ? 'selected' : '' }}>--
                                                            Disabled --</option>
                                                        <option value="1"
                                                            {{ $profile->qrcode == 1 ? 'selected' : '' }}>--
                                                            Enabled --</option>
                                                    </select>

                                                </div>

                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary btn-block mb-4"><i
                                                            class="fas fa-paper-plane"></i> Update</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </th>
                    </thead>
                </table>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-striped table-hover table-bordered">
                <thead class="thead-dark">
                    <tr>
                        <th scope="col">
                            <h6 style="text-align: center;">HEADING</h6>
                        </th>
                        <th scope="col">
                            <h6 style="text-align: center;">DESCRIPTIONS</h6>
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($profileData as $profile)
                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Business name</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                {{ $profile->selling->location->name }}
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Expiry date</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->date)
                                    {{ $profile->date }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Activated devices</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->device)
                                    {{ $profile->device }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Address</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->address)
                                    {{ $profile->address }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Business Contacts</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->phone)
                                    {{ $profile->phone }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Email
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->email)
                                    {{ $profile->email }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Website</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->website)
                                    {{ $profile->website }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Tin</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->tin)
                                    {{ $profile->tin }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Vrn</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->vrn)
                                    {{ $profile->vrn }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Slogan</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->slogan)
                                    {{ $profile->slogan }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Logo</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->logo)
                                    <img src="{{ asset('storage/logos/' . $profile->logo) }}" alt="Business Logo"
                                        style="max-width: 5%; height: auto;">
                                @else
                                    <p>No logo uploaded yet.</p>
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>VAT Status</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->vat)
                                    <span
                                        style="
                                                    display: inline-block;
                                                    padding: 5px 12px;
                                                    border-radius: 20px;
                                                    font-weight: bold;
                                                    color: #fff;
                                                    background: linear-gradient(45deg, #28a745, #218838);
                                                    box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                    ">
                                        {{ $profile->vat }}
                                    </span>
                                @else
                                    <span
                                        style="
                                                    display: inline-block;
                                                    padding: 5px 12px;
                                                    border-radius: 20px;
                                                    font-weight: bold;
                                                    color: #fff;
                                                    background: linear-gradient(45deg, #dc3545, #c82333);
                                                    box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                    ">
                                        N/A
                                    </span>
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Receipt Status</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->receipt === 'Yes')
                                    <span
                                        style="
                                                    display: inline-block;
                                                    padding: 5px 12px;
                                                    border-radius: 20px;
                                                    font-weight: bold;
                                                    color: #fff;
                                                    background: linear-gradient(45deg, #17a2b8, #117a8b);
                                                    box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                    ">
                                        Print Receipt
                                    </span>
                                @else
                                    <span
                                        style="
                                        display: inline-block;
                                        padding: 5px 12px;
                                        border-radius: 20px;
                                        font-weight: bold;
                                        color: #fff;
                                        background: linear-gradient(45deg, #ffc107, #e0a800);
                                        box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                        ">
                                        Don't Print Receipt
                                    </span>
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Loyalty / Royalty Rule Setting</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->royalty_enabled)
                                    <span
                                        style="
                                        display: inline-block;
                                        padding: 5px 12px;
                                        border-radius: 20px;
                                        font-weight: bold;
                                        color: #fff;
                                        background: linear-gradient(45deg, #6f42c1, #5a32a3);
                                        box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                        ">
                                        Enabled (Discount: {{ $profile->royalty_discount ?? 0 }}%)
                                    </span>
                                @else
                                    <span
                                        style="
                                        display: inline-block;
                                        padding: 5px 12px;
                                        border-radius: 20px;
                                        font-weight: bold;
                                        color: #fff;
                                        background: linear-gradient(45deg, #6c757d, #5a6268);
                                        box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                        ">
                                        Disabled
                                    </span>
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Batch.No Setting</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->batch_no === 1)
                                    <span
                                        style="
                                                display: inline-block;
                                                padding: 5px 12px;
                                                border-radius: 20px;
                                                font-weight: bold;
                                                color: #fff;
                                                background: linear-gradient(45deg, #007bff, #0056b3);
                                                box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                ">
                                        Enabled
                                    </span>
                                @else
                                    <span
                                        style="
                                                    display: inline-block;
                                                    padding: 5px 12px;
                                                    border-radius: 20px;
                                                    font-weight: bold;
                                                    color: #fff;
                                                    background: linear-gradient(45deg, #868e96, #495057);
                                                    box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                    ">
                                        Disabled
                                    </span>
                                @endif
                            </td>
                        </tr>

                        <tr style="background-color: #fff;">
                            <th style="width: 25%; text-align: center; vertical-align: middle;">
                                <h6>Qr Code Setting</h6>
                            </th>
                            <td style="width: 75%; text-align: left; vertical-align: middle;">
                                @if ($profile->qrcode === 1)
                                    <span
                                        style="
                                                display: inline-block;
                                                padding: 5px 12px;
                                                border-radius: 20px;
                                                font-weight: bold;
                                                color: #fff;
                                                background: linear-gradient(45deg, #007bff, #0056b3);
                                                box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                ">
                                        Enabled
                                    </span>
                                @else
                                    <span
                                        style="
                                                    display: inline-block;
                                                    padding: 5px 12px;
                                                    border-radius: 20px;
                                                    font-weight: bold;
                                                    color: #fff;
                                                    background: linear-gradient(45deg, #868e96, #495057);
                                                    box-shadow: 0 4px 6px rgba(0,0,0,0.2);
                                                    ">
                                        Disabled
                                    </span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="card-footer">
        </div>
    </div>

@section('scripts')
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            const royaltySelect = document.getElementById("royalty");
            const discountWrapper = document.getElementById("royalty_discount_wrapper");

            royaltySelect.addEventListener("change", function() {
                if (this.value === "1") {
                    discountWrapper.style.display = "block";
                } else {
                    discountWrapper.style.display = "none";
                    document.getElementById("royalty_discount").value = ""; // clear value when hidden
                }
            });
        });
    </script>
@endsection

@endsection
