@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            <form action="{{ route('cash.movement.report') }}" method="get" class="was-validated">
                @csrf
                @method('GET')
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                    <option value="set duration">-- Set Duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped table-hover align-middle text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>In/Out Reason</th>
                            <th>Before</th>
                            <th>Amount</th>
                            <th>After</th>
                            <th>Account</th>
                            <th>User</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($results as $data)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    {{ $data->created_at ? $data->created_at->format('Y-m-d H:i') : 'N/A' }}
                                </td>
                                <td>
                                    @if ($data->status == 'In')
                                        <span class="badge bg-success">In</span>
                                    @elseif($data->status == 'Out')
                                        <span class="badge bg-danger">Out</span>
                                    @else
                                        <span class="badge bg-secondary">N/A</span>
                                    @endif
                                </td>
                                <td>{{ $data->reason ?? 'N/A' }}</td>
                                <td>
                                    {{ isset($data->before) ? number_format($data->before, 2) : 'N/A' }}
                                </td>
                                <td>
                                    @if (isset($data->status) && isset($data->amount))
                                        <span class="{{ $data->status == 'Out' ? 'text-danger' : 'text-success' }}">
                                            {{ $data->status == 'Out' ? '-' : '+' }}{{ number_format($data->amount, 2) }}
                                        </span>
                                    @else
                                        N/A
                                    @endif
                                </td>
                                <td>
                                    {{ isset($data->after) ? number_format($data->after, 2) : 'N/A' }}
                                </td>
                                <td>
                                    {{ $data->account->type ?? 'N/A' }}
                                    @if (!empty($data->account->type))
                                        <small class="text-muted">
                                           - {{ $data->account->selling->location->name }}
                                        </small>
                                    @endif
                                </td>
                                <td>{{ optional($data->user)->name ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>In/Out Reason</th>
                            <th>Before</th>
                            <th>Amount</th>
                            <th>After</th>
                            <th>Account</th>
                            <th>User</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $(function() {
                $("#example1").DataTable({
                    "pageLength": 500,
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

                }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            });

            //global variable
            let start = "";
            let end = "";

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#type").on("change", function() {
                let type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });
        </script>
    @endsection
@endsection
