@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            Cleared Customer debts report

            <div class="card-tools">
                <a href="{{ route('customer.debts.report') }}" class="btn btn-danger btn-sm" style="border-radius: 100px;">View
                    pending customer debts</a>

                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>

                <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-bordered table-hover table-striped align-middle shadow-sm" style="text-align: center;">
                    <thead class="thead-dark bg-primary text-white">
                        <tr>
                            <th style="width: 5%">#</th>
                            <th style="width: 30%">Customer</th>
                            <th style="width: 20%">Due Balance</th>
                            <th style="width: 20%">Status</th>
                            <th style="width: 15%">Location</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $sum = 0; @endphp
                        @foreach ($debts as $debt)
                            @php
                                if ($debt->due < 0) {
                                    $sum += $debt->due;
                                }
                            @endphp
                            @if ($debt->due <= 0)
                                <tr>
                                    <td class="fw-bold">{{ $loop->iteration }}</td>
                                    <td>
                                        <span class="d-flex align-items-center justify-content-center">
                                            <i class="fas fa-user-circle me-2 text-primary"></i>
                                            {{ $debt->customer ? ($debt->customer->trashed() ? $debt->customer->name . ' (deleted)' : $debt->customer->name) : 'N/A' }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('customer.statement', ['customerId' => $debt->customer_id, 'sellingId' => $debt->selling_id]) }}"
                                           class="text-decoration-none text-dark fw-semibold">
                                            {{ number_format($debt->due) }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-success" style="font-size: 1em; border-radius: 20px;">Cleared</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info text-dark" style="font-size: 1em; border-radius: 20px;">
                                            {{ $debt->selling->location->name }}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                    <tfoot class="bg-light">
                        <tr>
                            <th>#</th>
                            <th>Debtor</th>
                            <th class="fw-bold text-primary">Total ( {{ number_format($sum) }} )</th>
                            <th>Status</th>
                            <th>Location</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
    </script>
@endsection
@endsection
