@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">

            <button type="button" class="btn btn-outline-danger" id="deleteall">
                <i class="fa-solid fa-trash"></i> Delete selected</button>

            <!-- Large modal -->
            <button type="button" class="btn btn-outline-info" data-toggle="modal" data-target=".creditor">
                <i class="fa-solid fa-plus"></i>
                New Creditor</button>

            <div class="modal fade creditor" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <div class="card">

                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Register new creditor</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="{{ route('creditor.store') }}" onsubmit="showSpinner()" method="post"
                                class="was-validated">
                                @csrf

                                <div class="card-body">

                                    <label for="name">Creditor</label>
                                    <input type="text" name="name" class="form-control" id="name" required>

                                    <label for="Address">Address</label>
                                    <input type="text" name="address" class="form-control" id="Address" required>

                                    <label for="phone">Phone number</label>
                                    <input type="text" name="phone" class="form-control" id="phone" required>

                                    <label for="location">Selling location</label>
                                    @if ($sellingCount > 1)
                                        <select name="location" id="location" class="form-control" required>
                                            <option disabled selected>-- Choose Location --</option>
                                            @foreach ($sellings as $selling)
                                                <option value="{{ $selling->id }}">
                                                    -- {{ $selling->location->name }} --
                                                </option>
                                            @endforeach
                                        </select>
                                    @else
                                        <input type="hidden" name="location" id="location" class="form-control"
                                            value="{{ $sellings[0]->id }}">

                                        <input type="text" name="area-copy" id="area-copy" class="form-control"
                                            value="{{ $sellings[0]->location->name }}" readonly>
                                    @endif
                                </div>

                                <div class="card-footer">
                                    <center>
                                        <button class="btn btn-outline-info btn-block"><i
                                                class="fa-solid fa-paper-plane"></i> Register</button>
                                    </center>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <div class="card-body table-responsive">

            <table class="table table-stripped table-hover">

                <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Address</th>
                        <th>Phone</th>
                        <th>Location</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                <tbody>

                    @foreach ($creditors as $creditor)
                        <tr>
                            <td>{{ $loop->index + 1 }}</td>
                            <td>{{ $creditor->name }}</td>
                            <td>{{ $creditor->address }}</td>
                            <td>{{ $creditor->phone }}</td>
                            <td>{{ $creditor->location->name }}</td>
                            <td>
                                {{-- edit trigger model --}}
                                <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                    data-target="#edit-{{ $creditor->id }}">
                                    <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                </button>

                                <div class="modal fade" id="edit-{{ $creditor->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h5 class="modal-title">Update creditor details</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="{{ route('creditor.update', $creditor->id) }}"
                                                onsubmit="showSpinner()" method="get" class="was-validated">
                                                @csrf

                                                <div class="modal-body">
                                                    <label for="name-{{ $creditor->id }}">Creditor</label>
                                                    <input type="text" name="name" class="form-control"
                                                        value="{{ $creditor->name }}" id="name-{{ $creditor->id }}">

                                                    <label for="address-{{ $creditor->id }}">Address</label>
                                                    <input type="text" name="address" class="form-control"
                                                        value="{{ $creditor->address }}"
                                                        id="address-{{ $creditor->id }}">

                                                    <label for="phone-{{ $creditor->id }}">Phone</label>
                                                    <input type="text" name="phone" class="form-control"
                                                        value="{{ $creditor->phone }}" id="phone-{{ $creditor->id }}">

                                                    <label for="location-{{ $creditor->name }}">Selling
                                                        location</label>
                                                    <select name="location" id="location-{{ $creditor->name }}"
                                                        class="form-control" required>
                                                        <option selected value="{{ $creditor->selling_id }}">
                                                            -- {{ $creditor->location->name }} --</option>
                                                        @if ($sellingCount > 1)
                                                            @foreach ($sellings as $selling)
                                                                <option value="{{ $selling->id }}">
                                                                    -- {{ $selling->location->name }} --
                                                                </option>
                                                            @endforeach
                                                        @else
                                                            <option value="{{ $sellings[0]->selling->id }}">
                                                                -- {{ $sellings[0]->location->name }} --</option>
                                                        @endif
                                                    </select>
                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-outline-info btn-block"><i
                                                            class="fa-solid fa-paper-plane fa-lg"></i> Save update</button>
                                                </div>
                                            </form>
                                        </div>x
                                    </div>
                                </div>

                                {{-- delete model --}}
                                <button class="btn btn-outline-danger delete" id="{{ $creditor->id }}">
                                    <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i>

                                    <form action="{{ route('creditor.destroy', $creditor->id) }}"
                                        onsubmit="showSpinner()" method="GET" id="deleteform{{ $creditor->id }}">
                                    </form>
                                </button>

                            </td>

                        </tr>
                    @endforeach

                </tbody>

            </table>

        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
