@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>

    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">
                <h3 class="card-title">Customer(s) checking out today</h3>
            </div>

            <div class="card-body">

                <table class="table table-stripped" id="customer">

                    <thead>

                        <tr>
                            <th>Check-in date</th>
                            <th>Check-out date</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Room</th>
                            <th>Action</th>
                        </tr>

                    </thead>

                    <tbody id="tbody">

                        @foreach ($customers as $customer)
                            <tr>
                                <td>{{ $customer->in }}</td>
                                <td>{{ $customer->out }}</td>
                                <td>{{ $customer->name }}</td>
                                <td>{{ $customer->phone }}</td>
                                <td>{{ $customer->room }}</td>
                                <td>

                                    {{-- View more model --}}
                                    <button type="button" class="btn btn-secondary" data-toggle="modal"
                                        data-target="#view-{{ $customer->id }}">
                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="view-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Customer info
                                                    </h5>
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <div class="modal-body">

                                                    <table class="table table-stripped">

                                                        <thead>
                                                            <th>Heading</th>
                                                            <th>Description</th>
                                                        </thead>

                                                        <tbody>

                                                            <tr>
                                                                <td>check-in date</td>
                                                                <td>{{ $customer->in }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Check-out date </td>
                                                                <td>{{ $customer->out }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Customer</td>
                                                                <td>{{ $customer->name }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Nationality</td>
                                                                <td>{{ $customer->nationality }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Religion</td>
                                                                <td>{{ $customer->religion }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Tribe</td>
                                                                <td>{{ $customer->tribe }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Comment</td>
                                                                <td>{{ $customer->comment }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>from</td>
                                                                <td>{{ $customer->from }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>To</td>
                                                                <td>{{ $customer->to }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Room</td>
                                                                <td>{{ $customer->room }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Price</td>
                                                                <td>{{ $customer->price }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Discount</td>
                                                                <td>{{ $customer->discount }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Net price</td>
                                                                <td>{{ $customer->net }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td> Paid amount</td>
                                                                <td>{{ $customer->paid }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Due balance</td>
                                                                <td>{{ $customer->due }}</td>
                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        Close
                                                    </button>
                                                </div>

                                            </div>
                                        </div>
                                    </div>


                                    {{-- Checkout button --}}

                                    <button type="button" class="btn btn-success" data-toggle="modal"
                                        data-target="#checkout-{{ $customer->id }}">
                                        <i class="fa fa-sign-out" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="checkout-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="exampleModalLabel">
                                                        Check-out customer</h6>

                                                    <button type="button"
                                                        class="btn btn-danger"
                                                        data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span
                                                            aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('checkout', $customer->id) }}" method="GET">

                                                    <div class="modal-body">

                                                        <label for="customer">Full name</label>
                                                        <input type="text" name="customer" id="customer"
                                                            value="{{ $customer->name }}" class=" form-control" readonly>

                                                        <label for="price">Room price</label>
                                                        <input type="text" name="price" value="{{ $customer->price }}"
                                                            id="price" class=" form-control" readonly>

                                                        <label for="discount">Discount</label>
                                                        <input type="text" name="discount"
                                                            value="{{ $customer->discount }}" id="discount"
                                                            class=" form-control" readonly>


                                                        {{-- view room bill --}}

                                                        <label for="bar">Bar &
                                                            Resturant bill</label>

                                                        <div class="container">
                                                            <div class="row">
                                                                <div class="col-9">
                                                                    <input type="text" name="bar"
                                                                        value="{{ $customer->total_bill }}" id="bar"
                                                                        class=" form-control" readonly>
                                                                </div>
                                                                <div class="col">

                                                                    {{-- <a href="{{ route('checkout view', $customer->room) }}"
                                                                    class="btn btn-primary"> View & Clear bill</a> --}}

                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-toggle="modal"
                                                                        data-target="#bill-{{ $customer->id }}">
                                                                        View Bill
                                                                    </button>

                                                                    <div class="modal fade" id="bill-{{ $customer->id }}"
                                                                        tabindex="-1">
                                                                        <div class="modal-dialog">
                                                                            <div class="modal-content">

                                                                                <div class="modal-header">
                                                                                    <h6 class="modal-title"
                                                                                        id="exampleModalLabel">
                                                                                        {{ $customer->room }} Bar &
                                                                                        Resturant Bill</h6>

                                                                                    <button type="button"
                                                                                        class="btn btn-danger"
                                                                                        data-dismiss="modal"
                                                                                        aria-label="Close">
                                                                                        <span
                                                                                            aria-hidden="true">&times;</span>
                                                                                    </button>
                                                                                </div>

                                                                                @php

                                                                                    $items = DB::table('bills')
                                                                                        ->join('bill_items', 'bill_items.bill_id', '=', 'bills.id')
                                                                                        ->where('bills.room', $customer->room)
                                                                                        ->get();

                                                                                    $sum = 0;
                                                                                    $billid = 0;

                                                                                    foreach ($items as $item) {
                                                                                        $sum += $item->amount;
                                                                                        $billid = $item->bill_id;
                                                                                    }

                                                                                @endphp

                                                                                <div class="modal-body">

                                                                                    <table class="table table-stripped">

                                                                                        <thead>
                                                                                            <tr>
                                                                                                <th>S/N</th>
                                                                                                <th>Product</th>
                                                                                                <th>Unit</th>
                                                                                                <th>Price</th>
                                                                                                <th>Qty</th>
                                                                                                <th>Amount</th>
                                                                                            </tr>
                                                                                        </thead>

                                                                                        <tbody>
                                                                                            @foreach ($items as $item)
                                                                                                <tr>
                                                                                                    <td>{{ $loop->index + 1 }}
                                                                                                    </td>
                                                                                                    <td>{{ $item->product }}
                                                                                                    </td>
                                                                                                    <td>{{ $item->unit }}
                                                                                                    </td>
                                                                                                    <td>{{ $item->price }}
                                                                                                    </td>
                                                                                                    <td>{{ $item->qty }}
                                                                                                    </td>
                                                                                                    <td>{{ $item->amount }}
                                                                                                    </td>
                                                                                                </tr>
                                                                                            @endforeach

                                                                                            <tr>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td><strong>Total</strong>
                                                                                                </td>
                                                                                                <td>{{ $sum }}
                                                                                                </td>
                                                                                            </tr>

                                                                                            <tr>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td><strong>Discount</strong>
                                                                                                </td>
                                                                                                <td>- 0</td>
                                                                                            </tr>

                                                                                            <tr>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td>&nbsp</td>
                                                                                                <td><strong>Net</strong>
                                                                                                </td>
                                                                                                <td>{{ $sum }}
                                                                                                </td>
                                                                                            </tr>

                                                                                        </tbody>

                                                                                    </table>
                                                                                </div>

                                                                                <div class="modal-footer">
                                                                                    <a href="{{ route('print.bill', $billid) }}"
                                                                                        class="btn btn-info"
                                                                                        id="print">Print</a>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>

                                                        {{-- clearing bill when checking out --}}

                                                        <label for="net">Room bill</label>
                                                        <input type="text" name="net" id="net"
                                                            value="{{ $customer->net }}" class="form-control" readonly>

                                                        <label for="paid">Paid amount</label>
                                                        <input type="text" name="paid" id="paid"
                                                            value="{{ $customer->paid }}" class="form-control" readonly>

                                                        <label for="due">Due balance</label>
                                                        <input type="text" name="due" id="due"
                                                            value="{{ $customer->due }}" class="form-control" readonly>

                                                        <label for="amount">Amount</label>
                                                        <input type="text" name="amount" id="amount"
                                                            class="form-control">

                                                        <label for="account">Payment method</label>
                                                        <select name="account" id="account" class="form-control">
                                                            <option>--Select Account--</option>
                                                            @foreach (App\Models\Account::all() as $account)
                                                                <option value="{{ $account->name }}">{{ $account->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                    </div>

                                                    <div class="modal-footer">
                                                        <input type="submit" value="check-out" class="btn btn-primary"
                                                            id="submit" style="display: none">
                                                    </div>

                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                    {{-- Edit button --}}

                                    <button type="button" class="btn btn-info" data-toggle="modal"
                                        data-target="#edit-{{ $customer->id }}">
                                        <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                    </button>

                                    <div class="modal fade" id="edit-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Update customer info
                                                    </h5>
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('booking.update', $customer->id) }}"
                                                    method="get">

                                                    <div class="modal-body">

                                                        <label for="in">Check in date</label>
                                                        <input type="date" value="{{ $customer->in }}" name="in"
                                                            class="form-control" id="in" required>

                                                        <label for="out">Check out date</label>
                                                        <input type="date" name="out"
                                                            value="{{ $customer->out }}" class="form-control"
                                                            id="out" required>

                                                        <label for="name">Full name</label>
                                                        <input type="text" name="name"
                                                            value="{{ $customer->name }}" class="form-control"
                                                            id="name" required>

                                                        <label for="phone">Phone</label>
                                                        <input type="text" name="phone"
                                                            value="{{ $customer->phone }}" class="form-control"
                                                            id="phone" required>

                                                        <label for="nationality">Nationality</label>
                                                        <select name="nationality" class="form-control" required>
                                                            <option value="{{ $customer->nationality }}">
                                                                {{ $customer->nationality }}</option>
                                                            <option value="Afghanistan">Afghanistan</option>
                                                            <option value="Albania">Albania</option>
                                                            <option value="Algeria">Algeria</option>
                                                            <option value="American Samoa">American Samoa</option>
                                                            <option value="Andorra">Andorra</option>
                                                            <option value="Angola">Angola</option>
                                                            <option value="Anguilla">Anguilla</option>
                                                            <option value="Antartica">Antarctica</option>
                                                            <option value="Antigua and Barbuda">Antigua and Barbuda
                                                            </option>
                                                            <option value="Argentina">Argentina</option>
                                                            <option value="Armenia">Armenia</option>
                                                            <option value="Aruba">Aruba</option>
                                                            <option value="Australia">Australia</option>
                                                            <option value="Austria">Austria</option>
                                                            <option value="Azerbaijan">Azerbaijan</option>
                                                            <option value="Bahamas">Bahamas</option>
                                                            <option value="Bahrain">Bahrain</option>
                                                            <option value="Bangladesh">Bangladesh</option>
                                                            <option value="Barbados">Barbados</option>
                                                            <option value="Belarus">Belarus</option>
                                                            <option value="Belgium">Belgium</option>
                                                            <option value="Belize">Belize</option>
                                                            <option value="Benin">Benin</option>
                                                            <option value="Bermuda">Bermuda</option>
                                                            <option value="Bhutan">Bhutan</option>
                                                            <option value="Bolivia">Bolivia</option>
                                                            <option value="Bosnia and Herzegowina">Bosnia and Herzegowina
                                                            </option>
                                                            <option value="Botswana">Botswana</option>
                                                            <option value="Bouvet Island">Bouvet Island</option>
                                                            <option value="Brazil">Brazil</option>
                                                            <option value="British Indian Ocean Territory">British Indian
                                                                Ocean
                                                                Territory
                                                            </option>
                                                            <option value="Brunei Darussalam">Brunei Darussalam</option>
                                                            <option value="Bulgaria">Bulgaria</option>
                                                            <option value="Burkina Faso">Burkina Faso</option>
                                                            <option value="Burundi">Burundi</option>
                                                            <option value="Cambodia">Cambodia</option>
                                                            <option value="Cameroon">Cameroon</option>
                                                            <option value="Canada">Canada</option>
                                                            <option value="Cape Verde">Cape Verde</option>
                                                            <option value="Cayman Islands">Cayman Islands</option>
                                                            <option value="Central African Republic">Central African
                                                                Republic
                                                            </option>
                                                            <option value="Chad">Chad</option>
                                                            <option value="Chile">Chile</option>
                                                            <option value="China">China</option>
                                                            <option value="Christmas Island">Christmas Island</option>
                                                            <option value="Cocos Islands">Cocos (Keeling) Islands</option>
                                                            <option value="Colombia">Colombia</option>
                                                            <option value="Comoros">Comoros</option>
                                                            <option value="Congo">Congo</option>
                                                            <option value="Congo">Congo, the Democratic Republic of the
                                                            </option>
                                                            <option value="Cook Islands">Cook Islands</option>
                                                            <option value="Costa Rica">Costa Rica</option>
                                                            <option value="Cota D Ivoire">Cote d Ivoire</option>
                                                            <option value="Croatia">Croatia (Hrvatska)</option>
                                                            <option value="Cuba">Cuba</option>
                                                            <option value="Cyprus">Cyprus</option>
                                                            <option value="Czech Republic">Czech Republic</option>
                                                            <option value="Denmark">Denmark</option>
                                                            <option value="Djibouti">Djibouti</option>
                                                            <option value="Dominica">Dominica</option>
                                                            <option value="Dominican Republic">Dominican Republic</option>
                                                            <option value="East Timor">East Timor</option>
                                                            <option value="Ecuador">Ecuador</option>
                                                            <option value="Egypt">Egypt</option>
                                                            <option value="El Salvador">El Salvador</option>
                                                            <option value="Equatorial Guinea">Equatorial Guinea</option>
                                                            <option value="Eritrea">Eritrea</option>
                                                            <option value="Estonia">Estonia</option>
                                                            <option value="Ethiopia">Ethiopia</option>
                                                            <option value="Falkland Islands">Falkland Islands (Malvinas)
                                                            </option>
                                                            <option value="Faroe Islands">Faroe Islands</option>
                                                            <option value="Fiji">Fiji</option>
                                                            <option value="Finland">Finland</option>
                                                            <option value="France">France</option>
                                                            <option value="France Metropolitan">France, Metropolitan
                                                            </option>
                                                            <option value="French Guiana">French Guiana</option>
                                                            <option value="French Polynesia">French Polynesia</option>
                                                            <option value="French Southern Territories">French Southern
                                                                Territories
                                                            </option>
                                                            <option value="Gabon">Gabon</option>
                                                            <option value="Gambia">Gambia</option>
                                                            <option value="Georgia">Georgia</option>
                                                            <option value="Germany">Germany</option>
                                                            <option value="Ghana">Ghana</option>
                                                            <option value="Gibraltar">Gibraltar</option>
                                                            <option value="Greece">Greece</option>
                                                            <option value="Greenland">Greenland</option>
                                                            <option value="Grenada">Grenada</option>
                                                            <option value="Guadeloupe">Guadeloupe</option>
                                                            <option value="Guam">Guam</option>
                                                            <option value="Guatemala">Guatemala</option>
                                                            <option value="Guinea">Guinea</option>
                                                            <option value="Guinea-Bissau">Guinea-Bissau</option>
                                                            <option value="Guyana">Guyana</option>
                                                            <option value="Haiti">Haiti</option>
                                                            <option value="Heard and McDonald Islands">Heard and Mc Donald
                                                                Islands
                                                            </option>
                                                            <option value="Holy See">Holy See (Vatican City State)</option>
                                                            <option value="Honduras">Honduras</option>
                                                            <option value="Hong Kong">Hong Kong</option>
                                                            <option value="Hungary">Hungary</option>
                                                            <option value="Iceland">Iceland</option>
                                                            <option value="India">India</option>
                                                            <option value="Indonesia">Indonesia</option>
                                                            <option value="Iran">Iran (Islamic Republic of)</option>
                                                            <option value="Iraq">Iraq</option>
                                                            <option value="Ireland">Ireland</option>
                                                            <option value="Israel">Israel</option>
                                                            <option value="Italy">Italy</option>
                                                            <option value="Jamaica">Jamaica</option>
                                                            <option value="Japan">Japan</option>
                                                            <option value="Jordan">Jordan</option>
                                                            <option value="Kazakhstan">Kazakhstan</option>
                                                            <option value="Kenya">Kenya</option>
                                                            <option value="Kiribati">Kiribati</option>
                                                            <option value="Democratic Peoples Republic of Korea">Korea,
                                                                Democratic
                                                                Peoples
                                                                Republic of</option>
                                                            <option value="Korea">Korea, Republic of</option>
                                                            <option value="Kuwait">Kuwait</option>
                                                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                                                            <option value="Lao">Lao People s Democratic Republic
                                                            </option>
                                                            <option value="Latvia">Latvia</option>
                                                            <option value="Lebanon" selected>Lebanon</option>
                                                            <option value="Lesotho">Lesotho</option>
                                                            <option value="Liberia">Liberia</option>
                                                            <option value="Libyan Arab Jamahiriya">Libyan Arab Jamahiriya
                                                            </option>
                                                            <option value="Liechtenstein">Liechtenstein</option>
                                                            <option value="Lithuania">Lithuania</option>
                                                            <option value="Luxembourg">Luxembourg</option>
                                                            <option value="Macau">Macau</option>
                                                            <option value="Macedonia">Macedonia, The Former Yugoslav
                                                                Republic
                                                                of
                                                            </option>
                                                            <option value="Madagascar">Madagascar</option>
                                                            <option value="Malawi">Malawi</option>
                                                            <option value="Malaysia">Malaysia</option>
                                                            <option value="Maldives">Maldives</option>
                                                            <option value="Mali">Mali</option>
                                                            <option value="Malta">Malta</option>
                                                            <option value="Marshall Islands">Marshall Islands</option>
                                                            <option value="Martinique">Martinique</option>
                                                            <option value="Mauritania">Mauritania</option>
                                                            <option value="Mauritius">Mauritius</option>
                                                            <option value="Mayotte">Mayotte</option>
                                                            <option value="Mexico">Mexico</option>
                                                            <option value="Micronesia">Micronesia, Federated States of
                                                            </option>
                                                            <option value="Moldova">Moldova, Republic of</option>
                                                            <option value="Monaco">Monaco</option>
                                                            <option value="Mongolia">Mongolia</option>
                                                            <option value="Montserrat">Montserrat</option>
                                                            <option value="Morocco">Morocco</option>
                                                            <option value="Mozambique">Mozambique</option>
                                                            <option value="Myanmar">Myanmar</option>
                                                            <option value="Namibia">Namibia</option>
                                                            <option value="Nauru">Nauru</option>
                                                            <option value="Nepal">Nepal</option>
                                                            <option value="Netherlands">Netherlands</option>
                                                            <option value="Netherlands Antilles">Netherlands Antilles
                                                            </option>
                                                            <option value="New Caledonia">New Caledonia</option>
                                                            <option value="New Zealand">New Zealand</option>
                                                            <option value="Nicaragua">Nicaragua</option>
                                                            <option value="Niger">Niger</option>
                                                            <option value="Nigeria">Nigeria</option>
                                                            <option value="Niue">Niue</option>
                                                            <option value="Norfolk Island">Norfolk Island</option>
                                                            <option value="Northern Mariana Islands">Northern Mariana
                                                                Islands
                                                            </option>
                                                            <option value="Norway">Norway</option>
                                                            <option value="Oman">Oman</option>
                                                            <option value="Pakistan">Pakistan</option>
                                                            <option value="Palau">Palau</option>
                                                            <option value="Panama">Panama</option>
                                                            <option value="Papua New Guinea">Papua New Guinea</option>
                                                            <option value="Paraguay">Paraguay</option>
                                                            <option value="Peru">Peru</option>
                                                            <option value="Philippines">Philippines</option>
                                                            <option value="Pitcairn">Pitcairn</option>
                                                            <option value="Poland">Poland</option>
                                                            <option value="Portugal">Portugal</option>
                                                            <option value="Puerto Rico">Puerto Rico</option>
                                                            <option value="Qatar">Qatar</option>
                                                            <option value="Reunion">Reunion</option>
                                                            <option value="Romania">Romania</option>
                                                            <option value="Russia">Russian Federation</option>
                                                            <option value="Rwanda">Rwanda</option>
                                                            <option value="Saint Kitts and Nevis">Saint Kitts and Nevis
                                                            </option>
                                                            <option value="Saint LUCIA">Saint LUCIA</option>
                                                            <option value="Saint Vincent">Saint Vincent and the Grenadines
                                                            </option>
                                                            <option value="Samoa">Samoa</option>
                                                            <option value="San Marino">San Marino</option>
                                                            <option value="Sao Tome and Principe">Sao Tome and Principe
                                                            </option>
                                                            <option value="Saudi Arabia">Saudi Arabia</option>
                                                            <option value="Senegal">Senegal</option>
                                                            <option value="Seychelles">Seychelles</option>
                                                            <option value="Sierra">Sierra Leone</option>
                                                            <option value="Singapore">Singapore</option>
                                                            <option value="Slovakia">Slovakia (Slovak Republic)</option>
                                                            <option value="Slovenia">Slovenia</option>
                                                            <option value="Solomon Islands">Solomon Islands</option>
                                                            <option value="Somalia">Somalia</option>
                                                            <option value="South Africa">South Africa</option>
                                                            <option value="South Georgia">South Georgia and the South
                                                                Sandwich
                                                                Islands
                                                            </option>
                                                            <option value="Span">Spain</option>
                                                            <option value="SriLanka">Sri Lanka</option>
                                                            <option value="St. Helena">St. Helena</option>
                                                            <option value="St. Pierre and Miguelon">St. Pierre and Miquelon
                                                            </option>
                                                            <option value="Sudan">Sudan</option>
                                                            <option value="Suriname">Suriname</option>
                                                            <option value="Svalbard">Svalbard and Jan Mayen Islands
                                                            </option>
                                                            <option value="Swaziland">Swaziland</option>
                                                            <option value="Sweden">Sweden</option>
                                                            <option value="Switzerland">Switzerland</option>
                                                            <option value="Syria">Syrian Arab Republic</option>
                                                            <option value="Taiwan">Taiwan, Province of China</option>
                                                            <option value="Tajikistan">Tajikistan</option>
                                                            <option value="Tanzania">Tanzania, United Republic of</option>
                                                            <option value="Thailand">Thailand</option>
                                                            <option value="Togo">Togo</option>
                                                            <option value="Tokelau">Tokelau</option>
                                                            <option value="Tonga">Tonga</option>
                                                            <option value="Trinidad and Tobago">Trinidad and Tobago
                                                            </option>
                                                            <option value="Tunisia">Tunisia</option>
                                                            <option value="Turkey">Turkey</option>
                                                            <option value="Turkmenistan">Turkmenistan</option>
                                                            <option value="Turks and Caicos">Turks and Caicos Islands
                                                            </option>
                                                            <option value="Tuvalu">Tuvalu</option>
                                                            <option value="Uganda">Uganda</option>
                                                            <option value="Ukraine">Ukraine</option>
                                                            <option value="United Arab Emirates">United Arab Emirates
                                                            </option>
                                                            <option value="United Kingdom">United Kingdom</option>
                                                            <option value="United States">United States</option>
                                                            <option value="United States Minor Outlying Islands">United
                                                                States
                                                                Minor
                                                                Outlying
                                                                Islands</option>
                                                            <option value="Uruguay">Uruguay</option>
                                                            <option value="Uzbekistan">Uzbekistan</option>
                                                            <option value="Vanuatu">Vanuatu</option>
                                                            <option value="Venezuela">Venezuela</option>
                                                            <option value="Vietnam">Viet Nam</option>
                                                            <option value="Virgin Islands (British)">Virgin Islands
                                                                (British)
                                                            </option>
                                                            <option value="Virgin Islands (U.S)">Virgin Islands (U.S.)
                                                            </option>
                                                            <option value="Wallis and Futana Islands">Wallis and Futuna
                                                                Islands
                                                            </option>
                                                            <option value="Western Sahara">Western Sahara</option>
                                                            <option value="Yemen">Yemen</option>
                                                            <option value="Serbia">Serbia</option>
                                                            <option value="Zambia">Zambia</option>
                                                            <option value="Zimbabwe">Zimbabwe</option>
                                                        </select>

                                                        <label for="religion">Religion</label>
                                                        <select name="religion" class="form-control" id="religion"
                                                            required>
                                                            <option value="{{ $customer->religion }}">
                                                                {{ $customer->religion }} </option>
                                                            <option value="African Traditional & Diasporic">African
                                                                Traditional
                                                                &
                                                                Diasporic</option>
                                                            <option value="Agnostic">Agnostic</option>
                                                            <option value="Atheist">Atheist</option>
                                                            <option value="Baha i">Baha i</option>
                                                            <option value="Buddhism">Buddhism</option>
                                                            <option value="Cao Dai">Cao Dai</option>
                                                            <option value="Chinese traditional religion">Chinese
                                                                traditional
                                                                religion</option>
                                                            <option value="Christianity">Christianity</option>
                                                            <option value="Hinduism">Hinduism</option>
                                                            <option value="Islam">Islam</option>
                                                            <option value="Jainism">Jainism</option>
                                                            <option value="Juche">Juche</option>
                                                            <option value="Judaism">Judaism</option>
                                                            <option value="Neo-Paganism">Neo-Paganism</option>
                                                            <option value="Nonreligious">Nonreligious</option>
                                                            <option value="Rastafarianism">Rastafarianism</option>
                                                            <option value="Secular">Secular</option>
                                                            <option value="Shinto">Shinto</option>
                                                            <option value="Sikhism">Sikhism</option>
                                                            <option value="Spiritism">Spiritism</option>
                                                            <option value="Tenrikyo">Tenrikyo</option>
                                                            <option value="Unitarian-Universalism">Unitarian-Universalism
                                                            </option>
                                                            <option value="Zoroastrianism">Zoroastrianism</option>
                                                            <option value="primal-indigenous">primal-indigenous</option>
                                                            <option value="Other">Other</option>
                                                        </select>

                                                        <label for="tribe">Tribe</label>
                                                        <input type="text" name="tribe"
                                                            value="{{ $customer->tribe }}" class="form-control"
                                                            id="tribe" required>

                                                        <label for="occupation">Occupation</label>
                                                        <input type="text" name="occupation"
                                                            value="{{ $customer->occupation }}" class="form-control"
                                                            id="occupation" required>

                                                        <label for="from">From</label>
                                                        <input type="text" name="from"
                                                            value="{{ $customer->from }}" class="form-control"
                                                            id="from" required>

                                                        <label for="to">To</label>
                                                        <input type="text" name="to"
                                                            value="{{ $customer->to }}"class="form-control"
                                                            id="to" required>

                                                        <label for="comment">Comment</label>
                                                        <input type="text" name="comment"
                                                            value="{{ $customer->comment }}" class="form-control"
                                                            id="comment" required>


                                                        <label for="room">Room</label>
                                                        <input type="text" name="room"
                                                            value="{{ $customer->room }}" class="form-control"
                                                            id="room" readonly required>

                                                        <label for="price">Room price</label>
                                                        <input type="number" name="price"
                                                            value="{{ $customer->price }}" class="form-control"
                                                            id="price" readonly required>

                                                        <label for="discount">Discount</label>
                                                        <input type="number" name="discount"
                                                            value="{{ $customer->discount }}" class="form-control"
                                                            id="discount" required>

                                                        <label for="net">Net amount</label>
                                                        <input type="number" name="net"
                                                            value="{{ $customer->net }}" class="form-control"
                                                            id="net" required>

                                                        <label for="paid">Paid amount</label>
                                                        <input type="number" name="paid"
                                                            value="{{ $customer->paid }}" class="form-control"
                                                            id="paid">

                                                        <label for="account">Account</label>
                                                        <select name="account" id="account" class="form-control"
                                                            required>
                                                            <option value="{{ $customer->account }}">
                                                                {{ $customer->account }} </option>
                                                            @foreach (App\Models\Account::all() as $account)
                                                                <option value="{{ $account->name }}">{{ $account->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="status"> Status</label>
                                                        <select name="status" value="{{ $customer->status }}"
                                                            class="form-control" required>
                                                            <option value="{{ $customer->staus }}">
                                                                {{ $customer->status }}
                                                            </option>
                                                            <option value="check-in">Check in</option>
                                                            <option value="booked">booking</option>
                                                        </select>

                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary">Update</button>
                                                    </div>

                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Check-in date</th>
                            <th>Check-out date</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Room</th>
                            <th>Action</th>
                        </tr>

                    </tfoot>

                </table>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $(function() {

            $("#customer").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        }); //closing DataTables function

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        var net = $("#net").val();
        var paid = $("#paid").val();
        var results = net - paid;
        $("#due").val(results);
    </script>
@endsection

@endsection
