@extends('layouts.master')

@section('content')

    @include('patial.loading-spinner')

    <div class="container-fluid mt-2">
        <!-- Summary Section -->
        @php
            $totalAmount = $debts->sum('amount');
            $totalDiscount = $debts->sum('discount');
            $totalPaid = $debts->sum('paid');
            $totalDue = $debts->sum('due');
            $netBalance = $totalAmount - $totalDiscount - $totalPaid;
        @endphp

        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-center shadow-sm border-primary">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Debts</h6>
                        <h5 class="fw-bold" id="totalAmount">{{ number_format($debts->sum('amount'), 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card text-center shadow-sm border-info">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Discount</h6>
                        <h5 class="fw-bold" id="totalDiscount">{{ number_format($debts->sum('discount'), 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card text-center shadow-sm border-success">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Paid</h6>
                        <h5 class="fw-bold" id="totalPaid">{{ number_format($debts->sum('paid'), 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center shadow-sm border-danger">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Due</h6>
                        <h5 class="fw-bold text-danger" id="totalDue">
                            {{ number_format($debts->sum('amount') - $debts->sum('discount') - $debts->sum('paid'), 2) }}
                        </h5>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                @php
                    if ($debts->sum('amount') - $debts->sum('discount') - $debts->sum('paid') <= 0) {
                        $statusText = 'Cleared';
                        $statusBadgeClass = 'bg-success text-white';
                        $cardBorderClass = 'border-success';
                    } else {
                        $statusText = 'Pending';
                        $statusBadgeClass = 'bg-warning text-dark';
                        $cardBorderClass = 'border-danger';
                    }
                @endphp
                <div class="card text-center shadow-sm {{ $cardBorderClass }}">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Status</h6>
                        <span class="badge fs-6 p-2 {{ $statusBadgeClass }}">
                            <i
                                class="fas {{ $debts->sum('amount') - $debts->sum('discount') - $debts->sum('paid') <= 0 ? 'fa-check-circle' : 'fa-hourglass-half' }} me-1"></i>
                            {{ $statusText }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Table Section -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">{{ $customer->name }} Debts History</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>Sale Id</th>
                                <th>Amount</th>
                                <th>Discount</th>
                                <th>Paid</th>
                                <th>Due</th>
                                <th>Action </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($debts as $debt)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $debt->created_at }}</td>
                                    <td>{{ $debt->customer->name ?? 'N/A' }}</td>
                                    <td>
                                        @if ($debt->sale_id)
                                            <a href="{{ route('sold.items', $debt->sale_id) }}">
                                                {{ '#00' . $debt->sale_id }}
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>{{ number_format($debt->amount, 2) }}</td>
                                    <td>{{ number_format($debt->discount, 2) }}</td>
                                    <td>{{ number_format($debt->paid, 2) }}
                                        {{ $debt->account ? '- ' . $debt->account->name : '' }}</td>
                                    <td class="text-danger">{{ number_format($debt->due, 2) }}</td>
                                    <td>
                                        <!-- Form for deleting debt -->
                                        <form id="deleteform{{ $debt->id }}" method="GET"
                                            action="{{ route('cancel.customer.debt.transaction', $debt->id) }}">
                                            @csrf
                                            <button type="button" class="btn btn-danger btn-sm delete"
                                                id="{{ $debt->id }}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer">
                <div class="d-flex justify-content-end">
                    <div class="btn-group" role="group" aria-label="Actions">
                        <a href="{{ route('generate.pdf', [$customer->id, $customer->selling_id, isset($duration) ? $duration : '-', isset($start) ? $start : '-', isset($end) ? $end : '-', 1, 0, 'customer']) }}"
                            class="btn btn-primary float-right" style="margin-right: 5px;">
                            <i class="fas fa-download"></i> Generate PDF
                        </a>
                        <!-- Submit Payment Button -->
                        <button type="button" id="payment" class="btn btn-success" data-toggle="modal"
                            data-target="#paymentModal">
                            <i class="fas fa-money-bill-wave mr-1"></i> Submit Payment
                        </button>

                        <!-- Payment Modal -->
                        <div class="modal fade" id="paymentModal" tabindex="-1" role="dialog"
                            aria-labelledby="paymentModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <form action="{{ route('pay.customer.debt.history', $customer->id) }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="customer_id" value="{{ $customer->id }}">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="paymentModalLabel">Clear Debt</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <!-- Date -->
                                            <div class="form-group">
                                                <label for="date">Date</label>
                                                <input type="date" id="date" name="date" class="form-control"
                                                    value="{{ now()->format('Y-m-d') }}" required>
                                            </div>

                                            <!-- Customer Name -->
                                            <div class="form-group">
                                                <label for="customer_name">Customer</label>
                                                <input type="text" id="customer_name" class="form-control"
                                                    value="{{ $customer->name }}" readonly>
                                            </div>

                                            <!-- Due Balance -->
                                            <div class="form-group">
                                                <label for="due_balance">Due Balance</label>
                                                <input type="text" id="due_balance" class="form-control"
                                                    value="  {{ number_format($debts->sum('amount') - $debts->sum('discount') - $debts->sum('paid'), 2) }}"
                                                    readonly>
                                            </div>

                                            <!-- Paid Amount -->
                                            <div class="form-group">
                                                <label for="paid">Paid Amount</label>
                                                <input type="number" id="paid" name="paid" class="form-control"
                                                    required>
                                            </div>

                                            <!-- Account -->
                                            <div class="form-group">
                                                <label for="account">Account</label>
                                                <select id="account" name="account" class="form-control" required>
                                                    <option value="">-- Select Account --</option>
                                                    @foreach ($accounts as $account)
                                                        <option value="{{ $account->id }}">-- {{ $account->name }} --
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn btn-success">Confirm Payment</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            // Create a new Intl.NumberFormat object
            var formatter = new Intl.NumberFormat();

            $(".submit-btn").on("click", function() {
                let amount = $("#amount").val();
                $("#amount").val(formatter.format(amount)); // Remove commas and parse as base 10
            });

            $("#pdf").on("click", function() {
                window.print();
            });

            $("#duration").on("change", function() {
                type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "This action will cancel the debt transaction!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, cancel it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                });
            });
        });
    </script>
@endsection
@endsection
