@extends('layouts.master')

@section('content')

    <div class="card mb-3">
        <div class="card-header">
            <a href="{{ route('new.customer.order', ['flag' => 1, 'id' => 0]) }}" class="btn btn-outline-info"><i
                    class="fas fa-plus"></i> New
                Order</a>
        </div>

        <div class="card-body">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Date</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Paid</th>
                        <th>Due</th>
                        <th>Status</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($customerOrders as $order)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $order->date }}</td>
                            <td>{{ $order->customer->name }}</td>
                            <td>{{ number_format($order->total_selling) }}</td>
                            <td>{{ number_format($order->paid) }}</td>
                            <td>{{ number_format($order->due) }}</td>
                            <td>
                                @if ($order->status == 'Cleared')
                                    <h5><span class="badge badge-success">{{ $order->status }}..</span></h5>
                                @else
                                    <h5><span class="badge badge-warning">{{ $order->status }}..</span></h5>
                                @endif
                            </td>

                            <td>
                                <!-- Button trigger modal -->
                                <button type="button" class="btn btn-outline-secondary" data-toggle="modal"
                                    data-target="#exampleModal{{ $order->id }}">
                                    <i class="fas fa-eye fa-lg"></i> View
                                </button>

                                <!-- Modal -->
                                <div class="modal fade" id="exampleModal{{ $order->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-xl" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Order Details</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <center>
                                                    Order Date: {{ $order->date }}<br>
                                                    Customer: {{ $order->customer->name }}<br>
                                                    Total: {{ number_format($order->total_selling) }}
                                                </center>
                                                @php
                                                    $orderItems = \App\Models\CustomerOrderItem::where(
                                                        'customer_order_id',
                                                        $order->id,
                                                    )->get();
                                                    $total = 0;
                                                @endphp

                                                <table class="table table-bordered table-hover table-sm">
                                                    <thead class="thead-light">
                                                        <tr>
                                                            <th>#</th>
                                                            <th scope="col">Product</th>
                                                            <th scope="col">Buying Price</th>
                                                            <th scope="col">Selling Price</th>
                                                            <th scope="col">Quantity</th>
                                                            <th scope="col">Total</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        @foreach ($orderItems as $item)
                                                            @php
                                                                $total += $item->qty * $item->selling_price;
                                                            @endphp
                                                            <tr>
                                                                <td>{{ $loop->iteration }}</td>
                                                                <td>{{ $item->product }}</td>
                                                                <td>{{ number_format($item->buying_price) }}</td>
                                                                <td>{{ number_format($item->selling_price) }}</td>
                                                                <td>{{ $item->qty }}</td>
                                                                <td>{{ number_format($item->selling_price * $item->qty) }}
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>

                                                    <tfoot>
                                                        <tr>
                                                            <th colspan="5" class="text-right">Total</th>
                                                            <th id="total">{{ number_format($total) }}</th>
                                                        </tr>

                                                        <tr>
                                                            <th colspan="5" class="text-right">Paid</th>
                                                            <th id="Paid">{{ number_format($order->paid) }}</th>
                                                        </tr>

                                                        <tr>
                                                            <th colspan="5" class="text-right">Due</th>
                                                            <th id="Due">{{ number_format($order->due) }}</th>
                                                        </tr>

                                                    </tfoot>
                                                </table>
                                            </div>

                                            <div class="modal-footer">
                                                <!-- Button trigger modal -->
                                                <button type="button" class="btn btn-outline-success" data-toggle="modal"
                                                    data-target="#paymentModal{{ $order->id }}">
                                                    <i class="fas fa-coins fa-lg"></i> Submit Payment
                                                </button>

                                                <!-- Modal -->
                                                <div class="modal fade" id="paymentModal{{ $order->id }}" tabindex="-1"
                                                    role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="paymentModalLabel">
                                                                    {{ $order->customer->name }}
                                                                </h5>
                                                                <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>

                                                            <form action="{{ route('customer.order.payment', $order->id) }}"
                                                                method="get">
                                                                <div class="modal-body">
                                                                    <label for="date">Date</label>
                                                                    <input type="date" class="form-control"
                                                                        id="date" name="date" value="{{ date('Y-m-d') }}">

                                                                    <label for="amount-due">Due Balance</label>
                                                                    <input type="number" class="form-control amount-paid"
                                                                        id="amount-due" name="amount-due"
                                                                        placeholder="Due balance"
                                                                        value="{{ $order->due }}" readonly>

                                                                    <label for="amount-paid">Paid</label>
                                                                    <input type="number" class="form-control amount-paid"
                                                                        id="amount-paid" name="amount-paid"
                                                                        placeholder="Paid" value="" required>

                                                                    <label for="account">Account</label">Account</label>
                                                                    <select class="form-control" id="account"
                                                                        name="account" required required>
                                                                        <option disabled selected>--Choose Account--
                                                                        </option>
                                                                        @foreach ($accounts as $account)
                                                                            <option value="{{ $account->id }}">
                                                                                {{ $account->type }} -
                                                                                {{ $account->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>

                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-outline-secondary"
                                                                        data-dismiss="modal"><i
                                                                            class="fas fa-times fa-lg"></i> Close</button>
                                                                    <button class="btn btn-outline-success"><i
                                                                            class="fas fa-coins fa-lg"></i> Post
                                                                        payment</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                <a href="{{ route('new.customer.order', ['flag' => 2, 'id' => $order->id]) }}"
                                                    class="btn btn-outline-info"><i class="fas fa-edit fa-lg"></i> Edit
                                                </a>

                                                <button type="button" class="btn btn-outline-secondary"
                                                    data-dismiss="modal"><i class="fas fa-times fa-lg"></i> Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <button type="button" id="{{ $order->id }}" class="delete btn btn-outline-danger"><i
                                        class="fas fa-trash-alt fa-lg"></i> Delete</button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('customer.order.delete') }}",
                        method: "GET",
                        data: {
                            'id': id
                        },
                        success: function(data) {
                            window.location.reload(true);
                        }
                    });

                    $(document).ready(function() {
                        Swal.fire({
                            icon: 'success',
                            title: 'Deleted successfully!!',
                            showConfirmButton: false,
                            timer: 2000
                        });
                    });
                }
            })
        });
    </script>
@endsection

@endsection
