@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="bulkdelete">
                    <i class="fas fa-trash-alt"></i> Delete selected
                </button>

                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".customer">
                    <i class="fas fa-plus"></i> Register customer
                </button>

                <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Register new customer</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="{{ route('customer.store') }}" onsubmit="showSpinner()" method="post"
                                class="was-validated">
                                @csrf

                                <div class="card-body">

                                    <label for="name">Customer</label>
                                    <input type="text" name="name" class="form-control" id="name" required>

                                    <label for="Address">Address</label>
                                    <input type="text" name="address" class="form-control" id="Address" required>

                                    <label for="phone">Phone number</label>
                                    <input type="text" name="phone" class="form-control" id="phone" required>

                                    <label for="email">Email</label>
                                    <input type="email" name="email" class="form-control" id="email">

                                    <label for="limit">Credit limit</label>
                                    <input type="number" name="limit" class="form-control" id="limit" required>

                                    <label for="advance">Advance</label>
                                    <input type="number" name="advance" class="form-control" value="" id="advance">

                                    <label for="opening">Opening balance</label>
                                    <input type="number" name="opening" class="form-control" id="opening" required>

                                    <label for="location">Selling location</label>
                                    @if ($sellingCount > 1)
                                        <select name="location" id="location" class="form-control" required>
                                            <option disabled selected value="">-- Choose Location --</option>
                                            @foreach ($sellings as $selling)
                                                <option value="{{ $selling->id }}">
                                                    -- {{ $selling->location->name }} --
                                                </option>
                                            @endforeach
                                        </select>
                                    @else
                                        <input type="hidden" name="location" id="location" class="form-control"
                                            value="{{ $sellings[0]->id }}">

                                        <input type="text" name="area-copy" id="area-copy" class="form-control"
                                            value="{{ $sellings[0]->location->name }}" readonly>
                                    @endif
                                </div>

                                <div class="card-footer">
                                    <button class="btn btn-info btn-block"><i class="fas fa-paper-plane"></i>
                                        Register</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm border rounded" id="data-table">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width:5%"><input type="checkbox" id="master"></th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Credit Limit</th>
                            <th>Advance</th>
                            <th>Email</th>
                            <th style="width:20%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($customers as $customer)
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox" class="sub_chk" id="{{ $customer->id }}">
                                </td>
                                <td>
                                    <span class="fw-bold">{{ $customer->name }}</span>
                                </td>
                                <td>{{ $customer->address }}</td>
                                <td>
                                    <span class="badge badge-info">{{ $customer->phone }}</span>
                                </td>
                                <td>
                                    <span class="text-success fw-bold">{{ number_format($customer->limit) }}</span>
                                </td>
                                <td>
                                    @if ($customer->advance)
                                        <span class="text-primary">{{ number_format($customer->advance) }}</span>
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                                <td>
                                    <small class="text-muted"><i class="fas fa-envelope"></i>
                                        {{ $customer->email }}</small>
                                <td>
                                    <div class="btn-group" role="group">
                                        <!-- Edit Button -->
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target="#edit-{{ $customer->id }}" title="Edit">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit
                                        </button>
                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="edit-{{ $customer->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="editCustomerLabel{{ $customer->id }}"
                                            aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('customer.update', $customer->id) }}"
                                                        onsubmit="showSpinner()" method="get" class="was-validated">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title"
                                                                id="editCustomerLabel{{ $customer->id }}">
                                                                Update Customer Details
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <label for="name-{{ $customer->id }}">Name</label>
                                                            <input type="text" name="name" class="form-control"
                                                                value="{{ $customer->name }}"
                                                                id="name-{{ $customer->id }}" required>
                                                            <label for="address-{{ $customer->id }}">Address</label>
                                                            <input type="text" name="address" class="form-control"
                                                                value="{{ $customer->address }}"
                                                                id="address-{{ $customer->id }}" required>
                                                            <label for="phone-{{ $customer->id }}">Phone</label>
                                                            <input type="text" name="phone" class="form-control"
                                                                value="{{ $customer->phone }}"
                                                                id="phone-{{ $customer->id }}" required>
                                                            <label for="email-{{ $customer->id }}">Email</label>
                                                            <input type="email" name="email" class="form-control"
                                                                value="{{ $customer->email }}"
                                                                id="email-{{ $customer->id }}">
                                                            <label for="limit-{{ $customer->id }}">Credit Limit</label>
                                                            <input type="number" name="limit" class="form-control"
                                                                value="{{ $customer->limit }}"
                                                                id="limit-{{ $customer->id }}" required>
                                                            <label for="advance-{{ $customer->id }}">Advance</label>
                                                            <input type="number" name="advance" class="form-control"
                                                                value="{{ $customer->advance }}"
                                                                id="advance-{{ $customer->id }}">
                                                            <label for="opening-{{ $customer->id }}">Opening
                                                                Balance</label>
                                                            <input type="number" name="opening" class="form-control"
                                                                value="{{ $customer->opening_balance }}"
                                                                id="opening-{{ $customer->id }}">
                                                            <label for="location-{{ $customer->id }}">Selling
                                                                Location</label>
                                                            @if ($sellingCount > 1)
                                                                <select name="location" id="location"
                                                                    class="form-control" required>
                                                                    <option disabled value="">-- Choose Location --
                                                                    </option>
                                                                    @foreach ($sellings as $selling)
                                                                        <option value="{{ $selling->id }}"
                                                                            {{ $customer->selling_id == $selling->id ? 'selected' : '' }}>
                                                                            -- {{ $selling->location->name }} --
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            @else
                                                                <input type="hidden" name="location" id="location"
                                                                    class="form-control" value="{{ $sellings[0]->id }}">
                                                                <input type="text" name="area-copy" id="area-copy"
                                                                    class="form-control"
                                                                    value="{{ $sellings[0]->location->name }}" readonly>
                                                            @endif
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info btn-block">
                                                                <i class="fas fa-paper-plane"></i> Save Changes
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Delete Button -->
                                        <button class="btn btn-danger btn-sm delete" id="{{ $customer->id }}"
                                            title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                        <form action="{{ route('customer.delete', $customer->id) }}"
                                            onsubmit="showSpinner()" method="GET" id="deleteform{{ $customer->id }}">
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Customers Found</h5>
                                        <p class="text-muted mb-0">You haven't added any locations yet.<br>
                                            <span class="small">Click <strong>Register Customer</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="bg-light">
                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Credit Limit</th>
                            <th>Advance</th>
                            <th>Email</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>

        </div>
    </div>

    @section('scripts')
        <script>
            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $('#master').on('click', function(e) {

                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }

            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('customer.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection

@endsection
