@extends('layouts.master')

@section('content')

    <form action="{{ route('damage.stock.report') }}" onsubmit="showSpinner()" method="get" class="was-validated">

        <div class="card table-responsive">
            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td><button type="button" class="btn btn-danger" id="deleteall"><i
                                        class="fa-solid fa-trash-alt"></i> Delete all</button>
                            </td>

                            <td>
                                <select name="area" id="area" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                        @foreach ($selling->storage as $storage)
                                            <option value="{{ $storage->location_id }}">
                                                -- {{ $storage->location->name }} --</option>
                                        @endforeach
                                    @endforeach
                                </select>
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                    <option value="set duration">-- Set Duration-- </option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                @php
                    $total = 0;
                @endphp

                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-striped table-hover align-middle"
                        style="text-align: center;">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width: 2%">
                                    <input type="checkbox" id="checkall" title="Select All">
                                </th>
                                <th>Date</th>
                                <th>Location</th>
                                <th>Product</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>Reason</th>
                                <th>User</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($results as $result)
                                @php
                                    $sum = $result->price * $result->qty;
                                    $total += $sum;
                                @endphp
                                <tr>
                                    <td>
                                        <input type="checkbox" class="selected" id="{{ $result->id }}" title="Select Row">
                                    </td>
                                    <td>{{ $result->created_at->format('Y-m-d H:i') }}</td>
                                    <td>{{ $result->location->name ?? '-' }}</td>
                                    <td>{{ $result->product->product ?? '-' }}  {{ $result->batch_no ? '| Batch '.$result->batch_no : '' }}</td>
                                    <td>{{ number_format($result->price, 2) }}</td>
                                    <td>
                                        {{ $result->qty }} {{ $result->unit->name ?? '' }}
                                    </td>
                                    <td>{{ number_format($sum, 2) }}</td>
                                    <td>{{ $result->reason ?? '-' }}</td>
                                    <td>{{ $result->user->name ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-secondary">
                            <tr>
                                <th>
                                    <input type="checkbox" id="checkall" title="Select All">
                                </th>
                                <th colspan="5" class="text-end"><strong>Grand Total:</strong></th>
                                <th>
                                    <h5 class="mb-0 text-success">{{ number_format($total, 2) }}</h5>
                                </th>
                                <th colspan="2"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        });

        //global variable
        let type = "";
        let start = "";
        let end = "";

        $("#start").on("change", function() {
            start = $(this).val();
        });

        $("#end").on("change", function() {
            end = $(this).val();
        });

        $("#type").on("change", function() {
            type = $(this).val();

            if (type == "today") {
                $("#start").attr("required", false).fadeOut("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set date") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set duration") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", true).fadeIn("slow");
            }
        });

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            let selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length === 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select at least one item!',
                });
                return;
            }

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('delete.damage.stock') }}",
                        type: "GET",
                        data: {
                            ids: selected
                        },
                        success: function(data) {
                            if (data.deleted && data.deleted.length > 0) {
                                // Remove deleted rows
                                data.deleted.forEach(function(id) {
                                    $("#" + id).closest('tr').remove();
                                });
                            }

                            Swal.fire({
                                icon: 'success',
                                title: data.message,
                                showConfirmButton: false,
                                timer: 2000
                            });
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Something went wrong!'
                            });
                        }
                    });
                }
            });
        });
    </script>
@endsection

@endsection
