@extends('layouts.master')

@section('content')
    <style>
        .batch-select {
            width: 100px;
            display: inline-block;
            margin-left: 10px;
            /* optional spacing */
        }
    </style>
    <form action="{{ route('store.damage.stock') }}" onsubmit="showSpinner()" method="post">
        @csrf
        @method('POST')

        <div class="card table-responsive">
            <div class="card-header">
                <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                    style="text-align:center; width: 30%">
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped align-middle shadow-sm">
                        <thead class="table-dark text-center">
                            <tr>
                                <th style="width: 3%">#</th>
                                <th style="width: 15%;">Location</th>
                                <th>Product</th>
                                <th style="width: 10%;">Batch.No</th>
                                <th style="width: 10%;">Reason</th>
                                <th style="width: 10%;">Unit</th>
                                <th style="width: 10%">Qty</th>
                                <th>
                                    <button type="button" class="btn btn-success btn-sm" id="addRow" title="Add Row">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </th>
                            </tr>
                        </thead>
                        <tbody id="tbody">
                            <!-- Dynamic rows will be appended here -->
                        </tbody>
                    </table>
                </div>

                <br>
                <center>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-paper-plane"></i> Save damages</button>
                </center>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(document).ready(function() {
            var ajaxResponse = []; // store AJAX response globally
            var index = 1;

            let lastKeyTime = 0;
            let barcodeBuffer = "";

            // =========================
            // Add Row
            $("#addRow").on("click", function() {
                let tr = `
                            <tr id="tr${index}">
                                <td><input type="hidden" name="id[]" id="id${index}" class="form-control id"></td>
                                <td>
                                    <select name="location[]" id="location${index}" class="form-control location" required>
                                        <option disabled selected value="">-- Select Location --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --</option>
                                            @foreach ($selling->storage as $storage)
                                                <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --</option>
                                            @endforeach
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <input type="text" name="search[]" class="form-control search" id="search${index}" placeholder="Search by product name or barcode.." required>
                                    <div id="list${index}" style="display:none; position:absolute; z-index:10; width:40%; border-radius:0 0 0.5rem 0.5rem; box-shadow:0 4px 12px rgba(0,0,0,0.12);" class="bg-white border border-primary">
                                        <ol id="results${index}" class="list-group list-group-flush"></ol>
                                    </div>
                                </td>
                                <td style="min-width: 10%;"><input type="text" name="batch_no[]" id="batch${index}" class="form-control batch"></td>
                                <td>
                                    <select name="reason[]" id="reason${index}" class="form-control reason" required>
                                        <option disabled selected value="">Reason</option>
                                        <option value="flat">-- Flat --</option>
                                        <option value="expire">-- Expire --</option>
                                        <option value="broken">-- Broken --</option>
                                    </select>
                                </td>
                                <td>
                                    <select name="unit[]" id="unit${index}" class="form-control unit" required></select>
                                    <input type="hidden" name="cont[]" id="cont${index}" class="form-control cont" readonly>
                                    <input type="hidden" name="price[]" id="price${index}" class="form-control price" readonly>
                                </td>
                                <td><input type="number" name="qty[]" id="qty${index}" class="form-control qty" min="1" value="1" required></td>
                                <td><button type="button" id="${index}" class="btn btn-danger removeRow"><i class="fas fa-trash-alt"></i></button></td>
                            </tr>`;
                $("#tbody").append(tr);
                index++;
            });

            // =========================
            // Search (manual / barcode)
            $(document).on("keyup", ".search", function(e) {
                let rowId = $(this).attr("id").replace("search", "");
                const query = $(this).val();

                // Skip Enter key (barcode handled separately)
                if (e.which === 13) return;

                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) return; // very fast typing may be barcode
                lastKeyTime = currentTime;

                if (query) fetchProducts(query, false, rowId); // manual search
            });

            $(document).on("keydown", ".search", function(e) {
                const rowId = $(this).attr("id").replace("search", "");
                const char = e.key;
                const currentTime = new Date().getTime();

                if (currentTime - lastKeyTime < 30) barcodeBuffer += char;
                else barcodeBuffer = char;
                lastKeyTime = currentTime;

                if (e.key === "Enter") {
                    e.preventDefault();
                    const barcode = $(this).val().trim();
                    if (barcode) fetchProducts(barcode, true, rowId); // barcode scan
                    barcodeBuffer = "";
                }
            });

            // =========================
            // Fetch products AJAX
            function fetchProducts(query, isBarcode = false, rowId) {
                let locationId = $("#location" + rowId).val();
                if (!query || !locationId) return;

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query,
                        barcode: isBarcode ? query : null,
                        locationId
                    },
                    success: function(data) {
                        ajaxResponse = data; // global storage
                        let resultsContainer = $("#results" + rowId);
                        resultsContainer.empty();
                        $("#list" + rowId).fadeIn("slow");

                        // Barcode scan: direct add if exactly 1 product
                        if (isBarcode && data.length === 1) {
                            addProductToRow(data[0], rowId);
                            $("#list" + rowId).fadeOut("slow");
                          //  $("#search" + rowId).val("").focus();
                            return;
                        }

                        // Manual search: populate suggestion list
                        if (!isBarcode) {
                            if (data.length === 0) {
                                resultsContainer.append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">No suggestions..</button></li>'
                                );
                                return;
                            }

                            data.forEach((product, i) => {
                                let batchSelectHtml = '';
                                if (product.batches && product.batches.length > 0) {
                                    batchSelectHtml = `<select class="batch-select form-control d-none" data-index="${i}" data-row="${rowId}">
                            <option value="" disabled selected>-- Select Batch --</option>`;
                                    product.batches.forEach(batch => {
                                        batchSelectHtml +=
                                            `<option value="${batch.batch_no}" data-qty="${batch.qty}" data-exp="${batch.exp}">${batch.batch_no} | Stock: ${batch.qty}</option>`;
                                    });
                                    batchSelectHtml += `</select>`;
                                }

                                resultsContainer.append(`
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <button type="button" class="btn btn-link items" data-index="${i}" data-row="${rowId}">
                                ${product.product} | Stock: ${product.totalQty} ${product.unit[0]?.name ?? ''}
                            </button>
                            ${batchSelectHtml}
                        </li>
                    `);
                            });
                        }
                    }
                });
            }

            // =========================
            // Click on suggestion
            $(document).on("click", ".items", function() {
                let rowId = $(this).data("row");
                let productIndex = $(this).data("index");
                let product = ajaxResponse[productIndex];

                addProductToRow(product, rowId);
            });
            // =========================

            // Fill row with product info
            function addProductToRow(product, rowId) {
                // Populate search input first
                const searchInput = $("#search" + rowId);
                searchInput.val(product.product);
                $("#id" + rowId).val(product.id);

                // Fill units
                let unitSelect = $("#unit" + rowId);
                unitSelect.empty().append('<option value="">-- Unit --</option>');
                if (product.unit?.length > 0) {
                    product.unit.forEach((val, i) => {
                        unitSelect.append(
                            `<option value="${val.id}" ${i===0?"selected":""}>${val.name}</option>`);
                    });
                    $("#cont" + rowId).val(product.unit[0].unit_cont);
                    $("#price" + rowId).val(product.unit[0].selling);
                }

                // Batch
                $("#batch" + rowId).val("Null");

                // Hide list instantly
                $("#list" + rowId).hide();

                // Make sure input stays focused
                searchInput.focus();
            }


            // Remove row
            $(document).on("click", ".removeRow", function() {
                $(this).closest("tr").remove();
            });

            $(document).on("change", ".batch-select", function() {
                let rowId = $(this).data("row");
                let selectedBatch = $(this).find("option:selected");

                if (!selectedBatch.val()) return;

                $("#batch" + rowId).val(selectedBatch.val());
                $("#qty" + rowId).val(selectedBatch.data("qty"));
            });

            // Handle batch selection
            $(document).on("change", ".batch-select", function() {
                let rowId = $(this).data("row");
                let productIndex = $(this).data("index");
                let product = ajaxResponse[productIndex];
                let selectedBatch = $(this).find("option:selected");

                if (!selectedBatch.val()) return;

                // 1️⃣ Hide search results
                $("#list" + rowId).fadeOut("slow");

                // 2️⃣ Populate fields with selected batch details
                $("#search" + rowId).val(product.product);
                $("#id" + rowId).val(product.id);
                $("#batch" + rowId).val(selectedBatch.val());
                $("#qty" + rowId).val(selectedBatch.data("qty"));

                // Populate units
                let unitSelect = $("#unit" + rowId);
                unitSelect.empty().append('<option value="">-- Unit --</option>');
                if (product.unit?.length > 0) {
                    product.unit.forEach((val, i) => {
                        unitSelect.append(
                            `<option value="${val.id}" ${i === 0 ? "selected" : ""}>${val.name}</option>`
                        );
                    });
                    $("#cont" + rowId).val(product.unit[0].unit_cont);
                    $("#price" + rowId).val(product.unit[0].selling);
                }

                // Hide the batch select dropdown
                $(this).addClass("d-none");
            });


            // Unit change
            $(document).on("change", ".unit", function() {
                let rowId = $(this).attr("id").replace("unit", "");
                let unitId = $(this).val();
                let productId = $("#id" + rowId).val();
                let locationId = $("#location" + rowId).val();

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "GET",
                    data: {
                        unitId,
                        productId,
                        locationId
                    },
                    success: function(data) {
                        $("#cont" + rowId).val(data.unit_cont);
                        $("#price" + rowId).val(data.selling);
                    }
                });
            });
        });
    </script>
@endsection

@endsection
