@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <h5>Delete products..</h5>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <div class="row align-items-center">
                    <div class="col-md-7 mb-2 mb-md-0">
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white">
                                <i class="fas fa-barcode"></i>
                            </span>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode...">
                        </div>
                        <div id="list"
                            style="display:none; position: absolute; z-index: 10; width: 100%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                            class="bg-white border border-primary">
                            <ol id="results" class="list-group list-group-flush"></ol>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group shadow-sm">
                            <span class="input-group-text bg-info text-white">
                                <i class="fas fa-store"></i>
                            </span>
                            <select name="location" id="location" class="form-control" style="text-align: center" required>
                                <option disabled selected>-- Choose Location --</option>
                                @foreach ($sellings as $selling)
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                    @foreach ($selling->storage as $storage)
                                        <option value="{{ $storage->location_id }}">
                                            -- {{ $storage->location->name }} --</option>
                                    @endforeach
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <br>

            <form action="{{ route('delete.product') }}" onsubmit="showSpinner()" method="get" id="deleteform">
                @csrf
                <div class="row">
                    <div class="col-10">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle shadow-sm"
                                style="background: #fff;">
                                <thead class="table-dark">
                                    <tr>
                                        <th style="width: 65%">Product</th>
                                        <th style="width: 25%; text-align: center;">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody">
                                    <!-- Dynamic rows will be appended here -->
                                </tbody>
                            </table>
                        </div>
                        <style>
                            .table thead th {
                                vertical-align: middle;
                                font-size: 1.1rem;
                                letter-spacing: 0.5px;
                            }

                            .table tbody td {
                                vertical-align: middle;
                                font-size: 1rem;
                            }

                            .btn-primaryer {
                                background: #dc3545;
                                color: #fff;
                                border: none;
                                transition: background 0.2s;
                            }

                            .btn-primaryer:hover {
                                background: #b52a37;
                                color: #fff;
                            }
                        </style>
                    </div>

                    <div class="col">
                        <button type="button" class="btn btn-primary" id="delete"><i class="fa fa-paper-plane"></i>
                            Completly delete this
                            Product(s)</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            var index = 1;
            var query;
            var location;
            var ajaxresults;

            $("#location").on("change", function() {
                location = $(this).val();
            });

            // store AJAX search results
            let ajaxResponse = []; 

            // =========================
            // Search products with barcode detection
            // =========================
            let lastKeyTime = 0;
            let barcodeBuffer = "";

            function fetchProducts(query, isBarcode = false) {
                let locationId = $("#location").val();
                if (!query || !locationId) {
                    $("#results").empty();
                    $("#list").hide();
                    return;
                }

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query,
                        barcode: isBarcode ? query : null,
                        locationId
                    },
                    success: function(response) {
                        console.log("Ajax Response:", response);
                        ajaxResponse = response;
                        $("#results").empty();
                        $("#list").fadeIn("slow");

                        // Barcode scan result (expect only 1 product)
                        if (isBarcode && response.length === 1) {
                            addProductToTable(response[0]);
                            $("#search").val("").focus();
                            $("#list").fadeOut("slow");
                            return;
                        }

                        // Manual typing: show suggestions
                        if (!isBarcode) {
                            if (response.length === 0) {
                                $("#results").append(
                                    `<li><button type="button" class="btn btn-outline-secondary form-control items">No suggestions..</button></li>`
                                );
                                return;
                            }

                            response.forEach((product, index) => {
                                if (product.batches && product.batches.length > 0) {
                                    let batchButton = `
                        <button type="button" class="btn btn-outline-info form-control batch-btn" data-index="${index}">
                            ${product.product} | Select Batch ⏷
                        </button>`;
                                    $("#results").append(`<li>${batchButton}</li>`);

                                    // hidden dropdown
                                    let batchDropdown = `<select class="form-control batch-select d-none" data-index="${index}">
                                            <option value="" disabled selected>-- Select Batch --</option>`;
                                    product.batches.forEach(batch => {
                                        batchDropdown += `
                            <option value="${batch.batch_no}" 
                                    data-qty="${batch.qty}" 
                                    data-exp="${batch.exp}">
                                Batch No: ${batch.batch_no} | Exp: ${batch.exp} | Stock: ${batch.qty} ${product.unit[0].name}
                            </option>`;
                                    });
                                    batchDropdown += `</select>`;
                                    $("#results li:last").append(batchDropdown);
                                } else {
                                    let qtyDisplay = product.totalQty ?? 0;
                                    let unitName = product.unit?.[0]?.name ?? "";
                                    $("#results").append(`
                        <li class="product-item" data-index="${index}">
                            <button type="button" class="btn btn-outline-secondary form-control items">
                                ${product.product} | Stock: ${qtyDisplay} ${unitName}
                            </button>
                        </li>`);
                                }
                            });
                        }
                    }
                });
            }

            // Manual typing search (keyup)
            $("#search").on("keyup", function(e) {
                let query = $(this).val();

                // Skip if Enter pressed (barcode handled separately)
                if (e.which === 13) return;

                // Ignore very fast typing (likely barcode)
                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) return;

                lastKeyTime = currentTime;

                if (query.length > 0) {
                    fetchProducts(query, false); // manual search
                }
            });

            // Barcode scan detection (Enter key)
            $("#search").on("keydown", function(e) {
                const currentTime = new Date().getTime();
                const char = e.key;

                // Build barcode buffer if keys are fast
                if (currentTime - lastKeyTime < 30) {
                    barcodeBuffer += char;
                } else {
                    barcodeBuffer = char;
                }
                lastKeyTime = currentTime;

                if (e.key === "Enter") {
                    e.preventDefault();
                    let barcode = $(this).val().trim();
                    if (barcode !== "") {
                        fetchProducts(barcode, true); // barcode search
                    }
                    barcodeBuffer = "";
                }
            });

            // Toggle batch dropdown
            $(document).on("click", ".batch-btn", function() {
                let index = $(this).data("index");
                $(`.batch-select[data-index="${index}"]`).toggleClass("d-none").focus();
            });

            // When batch is selected
            $(document).on("change", ".batch-select", function() {
                let index = $(this).data("index");
                let selected = $(this).find("option:selected");
                if (selected.val()) {
                    let batchData = {
                        batch_no: selected.val(),
                        qty: selected.data("qty"),
                        exp: selected.data("exp")
                    };
                    addProductToTable(ajaxResponse[index], batchData);
                    $(this).val("").addClass("d-none");
                }
            });

            // Product without batch clicked
            $(document).on("click", ".product-item", function() {
                let index = $(this).data("index");
                addProductToTable(ajaxResponse[index]);
            });

            // Add product to table
            function addProductToTable(product, batchData = null) {
                let batchNo = batchData ? batchData.batch_no : '';
                let trId = `tr${product.id}_${batchNo}`;
                if ($("#" + trId).length) return; // prevent duplicates

                let tr = `
                        <tr id="${trId}">
                            <td>
                                <input type="hidden" name="product_id[]" value="${product.id}">
                                <input type="hidden" name="location_id[]" value="${product.location_id}">
                                <input type="hidden" name="batch_no[]" value="${batchNo}">
                                ${product.product}${batchNo ? ' | Batch# ' + batchNo : ''}
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn btn-danger btn-sm removeRow">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </td>
                        </tr>`;
                $("#tbody").append(tr);

                $("#search").val("").focus();
                $("#list").fadeOut("slow");
            }

            // Remove row
            $(document).on("click", ".removeRow", function() {
                $(this).closest("tr").remove();
            });

            // Submit form on button click
            $("#delete").on("click", function() {
                let customerMessage = "No product was selected!";

                // No products selected
                if ($("#tbody tr").length === 0) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops!',
                        html: `<div style="font-size:1.2rem; color:#721c24; font-weight:500;">
                                        ${customerMessage}
                                </div>`,
                        background: '#ffeaea',
                        showConfirmButton: false,
                        timer: 4000,
                        timerProgressBar: true,
                        position: 'top-end',
                        toast: true,
                        customClass: {
                            popup: 'swal2-border-radius'
                        }
                    });

                    return;
                }

                // Confirm deletion
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $("#deleteform").submit();
                        showSpinner();
                    }
                });
            });
        });
    </script>
@endsection

@endsection
