<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12.5px;
            text-transform: uppercase;
            border-top: 1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:nth-child(2),
        .items tbody tr td:nth-child(2) {
            width: 70%;
            min-width: 70%;
            max-width: 70%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 10px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }

        .total {
            font-size: 10px;
            border-top: 1px dashed black !important;
            border-bottom: 1px dashed black !important;
        }

        .total.text,
        .total.price {
            text-align: right;
        }

        .line {
            border-top: 1px solid black !important;
        }

        .heading .sn {
            width: 5%;
        }

        .heading.rate {
            width: 10%;
        }

        p {
            padding: 1px;
            margin: 0;
        }

        section,
        footer {
            font-size: 12px;
        }
    </style>
</head>

<body id="body">
    <header>
        <div id="logo" class="media" data-src="logo.png" src="./logo.png"></div>
    </header>
    <table class="bill-details">

        <tbody>
            <tr style="text-align: center">
                <td>
                    <span>{{ $profileData->name }}</span><br>
                    <span>{{ $profileData->address }}</span><br>
                    <span>{{ $profileData->phone }}</span><br>
                    <span>Date: {{ $order->created_at }}</span><br>
                    <span>
                        @if ($order->customer_id)
                            Customer: {{ $order->customer->name }} <br>
                        @endif
                    </span>
                    <span class="receipt">Dispatch Memo</span>
                </td>
            </tr>
        </tbody>
    </table>

    <table class="items">
        <thead>
            <tr>
                <th class="heading qty">SN</th>
                <th class="heading name">Item</th>
                <th class="heading qty">Qty</th>
                <th class="heading rate" style="text-align: center;">Price</th>
                <th class="heading amount" style="text-align: left">Amount</th>
            </tr>
        </thead>

        <tbody>
            <tr>
                <td style="text-align: center;">1</td>
                <td>Transaport ({{ $transDetails[0] }})</td>
                <td style="text-align: center;">{{ $transDetails[2] }}Trips</td>
                <td style="text-align: center;">{{ number_format($transDetails[1]) }}</td>
                <td style="text-align: left;">{{ number_format($transDetails[1] * $transDetails[2]) }}</td>
            </tr>

            @foreach ($order->items as $item)
                <tr>
                    <td style="text-align: center;">{{ $loop->index + 1 }}</td>
                    <td>{{ $item->product ? $item->product->product : ($item->product()->withTrashed()->first() ? $item->product()->withTrashed()->first()->product : 'N/A') }}
                    <td style="text-align: center;">{{ $item->qty }}{{ $item->unit->name }}@if ($item->cont > 1)
                            ({{ $item->cont }})
                        @endif
                    </td>
                    <td style="text-align: center;">{{ number_format($item->price) }}</td>

                    <td style="text-align: left;">{{ number_format($item->amount) }}</td>
                </tr>
            @endforeach

            <tr>
                <th colspan="4" class="total text" style="text-align: right;">Total @if ($order->discount)
                        <br> Net
                    @endif
                   <br> Paid
                   <br> Due
                </th>
                <th class="total price" style="text-align: left;white-space: nowrap;">
                    {{ number_format($order->total + $transDetails[1] * $transDetails[2]) }}
                    @if (number_format($order->discount))
                        <br>{{ number_format($order->net) }}
                    @endif
                    <br>{{ number_format($order->paid) }}
                    <br>  {{ number_format(($order->total + $transDetails[1] * $transDetails[2]) - $order->paid) }}
                </th>
            </tr>
        </tbody>
    </table>
    <section>
        {{-- <p>
            Paid by : <span>CASH</span>
        </p> --}}
        <p style="text-align:center">
            Thank you for your visit!
        </p>
    </section>
    <footer style="text-align:center">
        <p>Powered by Dukamax Business Software</p>
    </footer>

    <!--
This script block does the following:

1. It runs when the window is loaded.
2. If the status is 'hold', it closes the window.
3. If the status is not 'hold', it navigates to the previous page in the history and then redirects to the 'order.index' route with the 'id' and 'status' parameters.
4. It finally triggers the print dialog.
-->
    <script>
        window.print();
        window.onload = function() {
            document.getElementById("body").onclick = function() {
                window.location.href = "{{ route('dispatch') }}";
            }
        };
    </script>
</body>

</html>
