@extends('layouts.master')

@section('content')

    <div class="card shadow">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="deleteall">
                    <i class="fas fa-trash"></i> Delete All
                </button>
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#registerDriverModal">
                    <i class="fas fa-plus"></i> Register Driver
                </button>
                <div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <table class="table table-striped table-hover" id="example1">
                <thead class="thead-dark">
                    <tr>
                        <th style="width: 5%;" class="text-center"><input type="checkbox" id="checkall"></th>
                        <th style="width: 5%" class="text-center">S/N</th>
                        <th class="text-center">Name</th>
                        <th class="text-center">Address</th>
                        <th class="text-center">Phone</th>
                        <th style="width: 20%;" class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($drivers as $driver)
                        <tr>
                            <td class="text-center"><input type="checkbox" class="selected" value="{{ $driver->id }}">
                            </td>
                            <td class="text-center">{{ $loop->iteration }}</td>
                            <td class="text-center">{{ $driver->name }}</td>
                            <td class="text-center">{{ $driver->address }}</td>
                            <td class="text-center">{{ $driver->phone }}</td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <!-- Edit button -->
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#editDriverModal-{{ $driver->id }}">
                                        <i class="fas fa-pen"></i> Edit
                                    </button>

                                    <!-- Delete button -->
                                    <button class="btn btn-danger btn-sm delete" id="{{ $driver->id }}">
                                        <i class="fa fa-trash-alt"></i>
                                        <span class="d-none d-md-inline">Delete</span>
                                        <form action="{{ route('driver.destroy', $driver->id) }}" method="GET"
                                            id="deleteform{{ $driver->id }}">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </button>
                                </div>
                            </td>
                        </tr>

                        <!-- Edit Modal -->
                        <div class="modal fade" id="editDriverModal-{{ $driver->id }}" tabindex="-1"
                            aria-labelledby="editDriverLabel-{{ $driver->id }}" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="{{ route('driver.update', $driver->id) }}" method="POST"
                                        class="was-validated">
                                        @csrf
                                        @method('PUT')
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="editDriverLabel-{{ $driver->id }}">Update
                                                Driver
                                                Details</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="name-{{ $driver->id }}">Name</label>
                                                <input type="text" name="name" class="form-control"
                                                    value="{{ $driver->name }}" id="name-{{ $driver->id }}" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="address-{{ $driver->id }}">Address</label>
                                                <input type="text" name="address" class="form-control"
                                                    value="{{ $driver->address }}" id="address-{{ $driver->id }}"
                                                    required>
                                            </div>
                                            <div class="form-group">
                                                <label for="phone-{{ $driver->id }}">Phone</label>
                                                <input type="text" name="phone" class="form-control"
                                                    value="{{ $driver->phone }}" id="phone-{{ $driver->id }}" required>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary btn-block">
                                                <i class="fas fa-paper-plane"></i> Update Driver
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Register Driver Modal -->
        <div class="modal fade" id="registerDriverModal" tabindex="-1" aria-labelledby="registerDriverLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('driver.store') }}" method="POST" class="was-validated">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title" id="registerDriverLabel">Register New Driver</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="new-driver-name">Name</label>
                                <input type="text" name="name" class="form-control" id="new-driver-name" required>
                            </div>
                            <div class="form-group">
                                <label for="new-driver-address">Address</label>
                                <input type="text" name="address" class="form-control" id="new-driver-address"
                                    required>
                            </div>
                            <div class="form-group">
                                <label for="new-driver-phone">Phone</label>
                                <input type="text" name="phone" class="form-control" id="new-driver-phone"
                                    required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fas fa-paper-plane"></i> Register Driver
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $("#example1").DataTable();

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select at least one item!',
                });
            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('drivers.bulk.delete') }}",
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted!',
                                    text: data.message || 'Deleted successfully.',
                                    background: '#e6ffed',
                                    showConfirmButton: false,
                                    timer: 2000,
                                    position: 'top-end',
                                    toast: true
                                });

                                // Optional: delay reload to show the toast
                                setTimeout(function() {
                                    window.location.reload(true);
                                }, 2000);
                            },
                            error: function(xhr) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: xhr.responseJSON?.error ||
                                        'Something went wrong.',
                                });
                            }
                        });
                    }
                });
            }
        });


        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
