@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="deleteall">
                    <i class="fa fa-trash-alt"></i> Delete selected
                </button>
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa fa-plus"></i> Add Category
                </button>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <form action="{{ Route('expense.category.store') }}" method="post" class="was-validated">
                            @csrf
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Add Category</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover shadow-sm rounded" id="table">
                                        <thead class="thead-light">
                                            <tr>
                                                <th scope="col" style="width:5%" class="text-center align-middle">#</th>
                                                <th scope="col" class="text-center align-middle">Name</th>
                                                <th scope="col" class="text-center align-middle">Type</th>
                                                <th scope="col" class="text-center align-middle">
                                                    <button type="button" class="btn btn-success btn-sm" id="addRow"
                                                        title="Add Row">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody">
                                            <!-- Dynamic rows will be appended here -->
                                        </tbody>
                                    </table>
                                </div>
                                <style>
                                    #table th,
                                    #table td {
                                        vertical-align: middle !important;
                                    }

                                    #table th {
                                        background: #f8f9fa;
                                        font-weight: 600;
                                        letter-spacing: 0.5px;
                                    }

                                    #table tr {
                                        transition: background 0.2s;
                                    }

                                    #table tr:hover {
                                        background: #f1f7ff;
                                    }

                                    #addRow {
                                        box-shadow: 0 2px 6px rgba(40, 167, 69, 0.15);
                                    }
                                </style>
                            </div>
                            <div class="modal-footer">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"> <i
                                            class="fa fa-times"></i> Close</button>
                                    <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-paper-plane"></i>
                                        Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered align-middle shadow-sm">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width: 5%" class="text-center"><input type="checkbox" id="checkall"> </th>
                            <th style="width: 5%" class="text-center">#</th>
                            <th>Category Name</th>
                            <th>Type</th>
                            <th style="width: 25%" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($categories as $category)
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox" class="selected" id="{{ $category->id }}">
                                </td>
                                <td class="text-center">{{ $loop->iteration }}</td>
                                <td class="font-weight-bold text-capitalize">{{ $category->name }}</td>
                                <td class="font-weight-bold text-capitalize">{{ $category->expense_type }}</td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <!-- Delete button -->
                                        <button class="btn btn-danger btn-sm delete" id="{{ $category->id }}"
                                            title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                            <form action="{{ route('expense.category.destroy', $category->id) }}"
                                                method="GET" id="deleteform{{ $category->id }}">
                                            </form>
                                        </button>
                                        <!-- Edit button -->
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target="#edit-{{ $category->id }}" title="Edit">
                                            <i class="fa fa-pen"></i> Edit
                                        </button>
                                    </div>
                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="edit-{{ $category->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header bg-primary text-white">
                                                    <h5 class="modal-title">Update Category</h5>
                                                    <button type="button" class="close text-white" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{ route('expense.category.update', $category->id) }}"
                                                    method="get" class="was-validated">
                                                    @csrf
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <label for="cat-name-{{ $category->id }}">Category
                                                                Name</label>
                                                            <input type="text" name="name"
                                                                id="cat-name-{{ $category->id }}"
                                                                value="{{ $category->name }}" class="form-control"
                                                                required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-primary btn-block">
                                                            <i class="fa fa-paper-plane"></i> Save Changes
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4 " class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Locations Found</h5>
                                        <p class="text-muted mb-0">You haven't added any locations yet.<br>
                                            <span class="small">Click <strong>Register Location</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                var index = 1;

                // add row
                $("#addRow").on("click", function(e) {

                    e.preventDefault();

                    let tr = `
                            <tr id="tr${index}">
                                <td class="text-center">${index}</td>
                                <td>
                                <input 
                                    type="text" 
                                    name="cat[]" 
                                    class="form-control text-center" 
                                    placeholder="Enter Category" 
                                    required
                                >
                                </td>
                                <td class="text-center">
                                <button 
                                    type="button" 
                                    id="${index}" 
                                    class="btn btn-danger removeRow"
                                >
                                    <i class="fa fa-trash-alt"></i>
                                </button>
                                </td>
                            </tr>
                         `;

                    $("#tbody").append(tr);
                    index++;

                    $(".removeRow").on("click", function() {
                        var id = $(this).attr("id");
                        $("#tr" + id).remove();
                        total();
                    });

                });

                $(".removeRow").on("click", function() {
                    alert("hellooo..");
                    $(this).parent().remove();
                });

                $("#checkall").on("click", function() {
                    if ($(this).is(':checked', true)) {
                        $(".selected").prop('checked', true);
                    } else {
                        $(".selected").prop('checked', false);
                    }
                });

                $("#deleteall").on("click", function() {
                    var selected = [];
                    $(".selected:checked").each(function() {
                        selected.push($(this).attr("id"));
                    });

                    if (selected.length == 0) {

                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Select atleast one item!!',
                        });

                    } else {

                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Yes, delete it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{ route('expense.category.bulk.delete') }}",
                                    method: "GET",
                                    data: {
                                        'ids': selected
                                    },
                                    success: function(data) {
                                        window.location.reload(true);
                                    }
                                });

                                $(document).ready(function() {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: 'Selected categories deleted successfully.',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                });
                            }
                        });
                    }
                });

                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });
            });
        </script>
    @endsection

@endsection
