@extends('layouts.master')

@section('content')
    <form action="{{ route('expense.report') }}" method="get" class="was-validated">
        <div class="card table-responsive">
            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <button type="button" class="btn btn-danger" id="deleteall">
                                    <i class="fa fa-trash-alt fa-lg"></i> Delete all
                                </button>
                            </td>
                            <td>
                                <select name="location" id="location" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Type --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set date --</option>
                                    <option value="set duration">-- Set duration --</option>
                                </select>
                            </td>
                            <td>
                                <input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required>
                            </td>
                            <td>
                                <input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required>
                            </td>
                            <td>
                                <button type="submit" id="search" class="btn btn-primary">
                                    <i class="fa fa-search fa-lg"></i> Search
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-striped table-hover align-middle">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width: 4%;">
                                    <input type="checkbox" id="checkall" title="Select All">
                                </th>
                                <th style="width: 12%;">
                                    <i class="fa fa-calendar-alt text-primary"></i> Date
                                </th>
                                <th style="width: 16%;">
                                    <i class="fas fa-map-pin text-primary"></i> Location
                                </th>
                                <th style="width: 25%;">
                                    <i class="fa fa-list-alt text-info"></i> Category
                                </th>
                                <th>
                                    <i class="fa fa-align-left text-warning"></i> Description
                                </th>
                                <th style="width: 12%;" class="text-end">
                                    <i class="fa fa-coins text-success"></i> Amount
                                </th>
                                <th style="width: 12%;">
                                    <i class="fa fa-user text-secondary"></i> User
                                </th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($results as $data)
                                <tr>
                                    <td>
                                        <input type="checkbox" class="selected" id="{{ $data->id }}" title="Select row">
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($data->date)->format('d M Y') }}</td>
                                    <td class="text-start">
                                        <i class="fas fa-map-pin text-primary"></i>
                                        {{ $data->selling->location->name ?? '-' }}
                                    </td>
                                    <td class="font-weight-bold text-capitalize text-start">
                                        <i class="fa fa-list-alt text-info"></i>
                                        {{ $data->category->name ?? '-' }} -
                                        {{ $data->category->expense_type ?? '-' }}
                                    </td>
                                    <td class="text-start">{{ $data->description ?? '-' }}</td>
                                    <td class="text-end">
                                        <span class="badge bg-info fs-6">{{ number_format($data->sum) }}</span>
                                    </td>
                                    <td class="text-start">
                                        <i class="fa fa-user text-secondary"></i>
                                        {{ $data->user->name ?? '-' }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                        <tfoot>
                            <tr class="table-secondary">
                                <th colspan="3" class="align-middle">
                                    <div class="row g-2">
                                        <div class="col-8">
                                            <input type="date" name="changedate" id="date" class="form-control"
                                                style="text-align: center" title="Pick new date">
                                        </div>
                                        <div class="col-4">
                                            <button type="button" id="changedate"
                                                class="btn btn-success w-100 shadow-sm font-weight-bold">
                                                <i class="fa fa-calendar fa-lg"></i> Change date
                                            </button>
                                        </div>
                                    </div>
                                </th>
                                <th colspan="2" class="text-end align-middle"><strong>Total</strong></th>
                                <th colspan="2" class="text-end align-middle">
                                    <span class="badge bg-success fs-5">{{ number_format($total) }}</span>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

    {{--  Expenses per location  --}}
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>Expense per location</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="expense-location-table" class="table table-bordered table-striped table-hover align-middle">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width: 70%;">
                                    <i class="fas fa-map-pin text-primary"></i> Location
                                </th>
                                <th style="width: 30%;">
                                    <i class="fa fa-coins text-success"></i> Total
                                </th>
                            </tr>
                        </thead>

                        <tbody>
                            @php
                                $overall_total = 0;
                                // Calculate overall total based on type
                                if ($type == 'today') {
                                    $overall_total = \App\Models\PostExpense::where('date', $currentDate)->sum('sum');
                                } elseif ($type == 'set date') {
                                    $overall_total = \App\Models\PostExpense::where('date', $start)->sum('sum');
                                } elseif ($type == 'set duration') {
                                    $overall_total = \App\Models\PostExpense::whereBetween('date', [$start, $end])->sum(
                                        'sum',
                                    );
                                }
                            @endphp

                            @foreach ($sellings as $selling)
                                @php
                                    $location_total = 0;
                                    if (!empty($type)) {
                                        $location_total = \App\Models\PostExpense::where('selling_id', $selling->id)
                                            ->when($type == 'today', function ($query) use ($currentDate) {
                                                return $query->where('date', $currentDate);
                                            })
                                            ->when($type == 'set date', function ($query) use ($start) {
                                                return $query->where('date', $start);
                                            })
                                            ->when($type == 'set duration', function ($query) use ($start, $end) {
                                                return $query->whereBetween('date', [$start, $end]);
                                            })
                                            ->sum('sum');
                                    }
                                @endphp
                                <tr>
                                    <td class="text-start">
                                        <i class="fas fa-map-pin text-primary"></i>
                                        <strong>{{ $selling->location->name }}</strong>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-info fs-6">{{ number_format($location_total) }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-secondary">
                                <th class="text-end"><strong>Overall Total</strong></th>
                                <th class="text-end">
                                    <span class="badge bg-success fs-5">{{ number_format($overall_total) }}</span>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                @if ($sellings->isEmpty())
                    <div class="alert alert-warning text-center my-3">
                        <i class="fa fa-exclamation-circle"></i> No expense data found for the selected criteria.
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{--  Cash per account  --}}
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>Amount used from each account</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="account-expense-table" class="table table-bordered table-striped table-hover align-middle">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width: 70%;">
                                    <i class="fa fa-university text-primary"></i> Account
                                </th>
                                <th style="width: 30%;" class="text-end">
                                    <i class="fa fa-coins text-success"></i> Total Used
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $overall_account_total = 0;
                            @endphp
                            @foreach ($accounts as $account)
                                @php
                                    // Calculate total used from this account based on filters
                                    $query = \App\Models\PostExpense::query();
                                    if ($type == 'today') {
                                        $query->where('date', $currentDate);
                                    } elseif ($type == 'set date') {
                                        $query->where('date', $start);
                                    } elseif ($type == 'set duration') {
                                        $query->whereBetween('date', [$start, $end]);
                                    }
                                    if (!empty($location) && $location != 'all') {
                                        $query->where('selling_id', $location);
                                    }
                                    $account_total = $query->where('account_id', $account->id)->sum('sum');
                                    $overall_account_total += $account_total;
                                @endphp
                                <tr>
                                    <td class="text-start">
                                        <i class="fa fa-university text-primary"></i>
                                        <strong>{{ $account->type }} - {{ $account->name }}</strong>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-info fs-6">{{ number_format($account_total) }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-secondary">
                                <th class="text-end"><strong>Overall Account Total</strong></th>
                                <th class="text-end">
                                    <span class="badge bg-success fs-5">{{ number_format($overall_account_total) }}</span>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                    @if ($accounts->isEmpty())
                        <div class="alert alert-warning text-center my-3">
                            <i class="fa fa-exclamation-circle"></i> No account expense data found for the selected
                            criteria.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $(function() {
            $("#example1").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            // Global variables
            let type = "";
            let start = "";
            let end = "";
            let change = "";

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#type").on("change", function() {
                type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });

            $("#checkall").on("click", function() {
                $(".selected").prop('checked', $(this).is(':checked'));
            });

            $("#deleteall").on("click", function() {
                let selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length === 0) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select at least one item!!',
                    });
                } else {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('expenses.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: 'Delete Successfully',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    }).then(() => {
                                        window.location.reload(true);
                                    });
                                },
                                error: function(jqXHR, textStatus, errorThrown) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Oops!',
                                        text: 'Something went wrong',
                                        background: '#ffeaea',
                                        showConfirmButton: false,
                                        timer: 4000,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });

            $("#date").on("change", function() {
                change = $(this).val();
            });

            $("#changedate").on("click", function() {
                let selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length === 0) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select at least one item!!',
                    });
                } else {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You're about to change the expense date!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, change date!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('change.expenses.date') }}",
                                method: "GET",
                                data: {
                                    'ids': selected,
                                    'newdate': change
                                },
                                success: function(data) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Date updated successfully!!',
                                        showConfirmButton: false,
                                        timer: 2000
                                    }).then(() => {
                                        window.location.reload(true);
                                    });
                                },
                                error: function(jqXHR, textStatus, errorThrown) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: 'An error occurred while processing your request.',
                                    });
                                }
                            });
                        }
                    });
                }
            });

        });
    </script>
@endsection

@endsection
