@extends('layouts.master')

@section('content')
    <div class="container-fluid">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h2 class="mb-0">📦 Expired & About To Expire Products</h2>
            </div>
            <div class="card-body">
                {{-- ✅ Expired Products --}}
                <div class="card mb-5">
                    <div class="card-header bg-danger text-white">
                        <strong>Expired Products (As of {{ now()->format('Y-m-d') }})</strong>
                    </div>
                    <div class="card-body p-0">
                        @if ($expiredProducts->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered mb-0 table-striped">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>#</th>
                                            <th>Product</th>
                                            <th>Qty</th>
                                            <th>Location</th>
                                            <th>Expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($expiredProducts as $index => $item)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $item->product->product ?? 'N/A' }}</td>
                                                <td>{{ $item->qty }} {{ $item->unit->name ?? 'N/A' }}</td>
                                                <td>{{ $item->product->location->name ?? 'N/A' }}</td>
                                                <td><span class="badge bg-danger">{{ $item->exp }}</span></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="p-3 mb-0">✅ No expired products found.</p>
                        @endif
                    </div>
                </div>

                {{-- ✅ About To Expire Products --}}
                <div class="card mb-0">
                    <div class="card-header bg-warning">
                        <strong>Products About To Expire (Next 30 Days)</strong>
                    </div>
                    <div class="card-body p-0">
                        @if ($aboutToExpireProducts->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered mb-0 table-striped">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Product</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>Location</th>
                                            <th>Expiry Date</th>
                                            <th>Days Left</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($aboutToExpireProducts as $index => $item)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $item->product->product ?? 'N/A' }}</td>
                                                <td>{{ $item->unit->name ?? 'N/A' }}</td>
                                                <td>{{ $item->qty }}</td>
                                                <td>{{ $item->product->location->location ?? 'N/A' }}</td>
                                                <td><span class="badge bg-warning">{{ $item->exp }}</span></td>
                                                <td>
                                                    {{ \Carbon\Carbon::parse($item->exp)->diffInDays(\Carbon\Carbon::now()) }}
                                                    days
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="p-3 mb-0">✅ No products about to expire in the next 30 days.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        // Optional: Add any specific JS for this page if needed
        $(document).ready(function() {
         
        });
    </script>
@endsection

@endsection
