@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">

            <table>
                <tbody>
                    <td>
                        <button type="button" class="btn btn-outline-danger" id="bulkdelete">
                            <i class="fas fa-trash-alt"></i> Delete selected
                        </button>
                    </td>

                    <td>
                        <!-- Large modal -->
                        <button type="button" class="btn btn-outline-info" data-toggle="modal" data-target=".game">
                            <i class="fas fa-plus"></i> Register game
                        </button>

                        <div class="modal fade game" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">

                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Register New Game</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>

                                    <form action="{{ route('game.store') }}" onsubmit="showSpinner()" method="post"
                                        class="was-validated">
                                        @csrf
                                        @method('POST')

                                        <div class="card-body">
                                            <label for="name">Game name</label>
                                            <input type="text" name="name" class="form-control" id="name"
                                                required>

                                            <label for="duration">Duration</label>
                                            <select name="duration" id="duration" class="form-control">
                                                <option disabled selected value="">-- Select Duration --</option>
                                                <option value="1">-- Daily --</option>
                                                <option value="2">-- Weekly --</option>
                                                <option value="3">-- Monthly --</option>
                                                <option value="4">-- Annualy --</option>
                                            </select>

                                            <label for="life-circle">Life cycle</label>
                                            <select name="life-circle" id="life-circle" class="form-control">
                                                <option disabled selected value="">-- Select Duration --</option>
                                                <option value="1">-- Daily --</option>
                                                <option value="2">-- Weekly --</option>
                                                <option value="3">-- Monthly --</option>
                                                <option value="4">-- Annualy --</option>
                                            </select>

                                            <label for="members">Members</label>
                                            <input type="number" name="members" class="form-control" id="members"
                                                required>

                                            <label for="p-amount">Principle amount</label>
                                            <input type="number" name="p-amount" class="form-control" id="p-amount" required>

                                            <label for="r-amount">Return amount</label>
                                            <input type="number" name="r-amount" class="form-control" id="r-amount"
                                                required>
                                        </div>

                                        <div class="card-footer">
                                            <button class="btn btn-outline-info btn-block"><i class="fas fa-paper-plane fa-lg"></i> Register</button>
                                        </div>

                                    </form>

                                </div>
                            </div>
                        </div>
                    </td>

                    {{-- <td>
                            <form action="{{ route('upload.game.excel') }}" method="post"
                                enctype="multipart/form-data">
                                @csrf
                                <input type="file" name="file" required style="text-align: center">

                                <button type="submit" class="btn btn-success">Upload Execl</button>
                            </form>
                        </td> --}}
                </tbody>
            </table>

        </div>
        <div class="card-body">

            <table class="table table-stripped table-hover" id="customer">

                <thead>

                    <tr>
                        <th style="width:5%"><input type="checkbox" id="master"></th>
                        <th>Name</th>
                        <th>Duration</th>
                        <th>Members</th>
                        <th>Life cycle</th>
                        <th>Priciple</th>
                        <th>Return</th>
                        <th style="width:20%">Action</th>
                    </tr>
                </thead>

                <tbody>

                    @foreach ($games as $game)
                        <tr>
                            <td><input type="checkbox" class="sub_chk" id="{{ $game->id }}"></td>
                            <td>{{ $game->name }}</td>
                            <td>
                                @switch($game->duration)
                                    @case(1)
                                        Daily
                                    @break

                                    @case(2)
                                        Weekly
                                    @break

                                    @case(3)
                                        Monthly
                                    @break

                                    @case(4)
                                        Annualy
                                    @break
                                @endswitch
                            </td>
                            <td>{{ number_format($game->member) }}</td>
                            <td>
                                @switch($game->life_circle)
                                    @case(1)
                                        Daily
                                    @break

                                    @case(2)
                                        Weekly
                                    @break

                                    @case(3)
                                        Monthly
                                    @break

                                    @case(4)
                                        Annualy
                                    @break
                                @endswitch
                            </td>
                            <td>{{ number_format($game->p_amount) }}</td>
                            <td>{{ number_format($game->r_amount) }}</td>
                            <td>
                                {{-- edit trigger model --}}
                                <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                    data-target="#edit-{{ $game->id }}">
                                    <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                </button>

                                <div class="modal fadedashboard" id="edit-{{ $game->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <form action="{{ route('game.update', $game->id) }}" onsubmit="showSpinner()"
                                                method="get" class="was-validated">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Update game
                                                        details</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                </div>

                                                <div class="modal-body">
                                                    <label for="name">Game name</label>
                                                    <input type="text" name="name" class="form-control"
                                                        id="name" value="{{ $game->name }}" required>

                                                    <label for="duration">Duration</label>
                                                    <select name="duration" id="duration" class="form-control">
                                                        <option value="1"
                                                            {{ $game->duration == 1 ? 'selected' : '' }}>Daily</option>
                                                        <option value="2"
                                                            {{ $game->duration == 2 ? 'selected' : '' }}>Weekly</option>
                                                        <option value="3"
                                                            {{ $game->duration == 3 ? 'selected' : '' }}>Monthly
                                                        </option>
                                                        <option value="4"
                                                            {{ $game->duration == 4 ? 'selected' : '' }}>Annualy
                                                        </option>
                                                    </select>

                                                    <label for="life-circle">Life cycle</label>
                                                    <select name="life-circle" id="life-circle" class="form-control">
                                                        <option value="1"
                                                            {{ $game->life_circle == 1 ? 'selected' : '' }}>Daily</option>
                                                        <option value="2"
                                                            {{ $game->life_circle == 2 ? 'selected' : '' }}>Weekly</option>
                                                        <option value="3"
                                                            {{ $game->life_circle == 3 ? 'selected' : '' }}>Monthly
                                                        </option>
                                                        <option value="4"
                                                            {{ $game->life_circle == 4 ? 'selected' : '' }}>Annualy
                                                        </option>
                                                    </select>

                                                    <label for="members">Members</label>
                                                    <input type="number" name="members" class="form-control"
                                                        id="members" value="{{ $game->no_of_memeber }}" required>

                                                    <label for="p-amount">Principle amount</label>
                                                    <input type="number" name="p-amount" class="form-control"
                                                        id="p-amount" value="{{ $game->p_amount }}" required>

                                                    <label for="r-amount">Return amount</label>
                                                    <input type="number" name="r-amount" class="form-control"
                                                        id="r-amount" value="{{ $game->r_amount }}" required>
                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-outline-info btn-block"><i class="fa-solid fa-paper-plane fa-lg"></i> Update</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>

                                {{-- delete model --}}
                                <button class="btn btn-outline-danger delete" id="{{ $game->id }}">
                                    <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i>

                                    <form action="{{ route('game.destroy', $game->id) }}" onsubmit="showSpinner()"
                                        method="GET" id="deleteform{{ $game->id }}">
                                    </form>
                                </button>
                            </td>
                        </tr>
                    @endforeach

                </tbody>

                <tfoot>

                    <tr>
                        <th style="width: 40px;"><input type="checkbox" id="checkall"></th>
                        <th>Name</th>
                        <th>Duration</th>
                        <th>Members</th>
                        <th>Life cycle</th>
                        <th>Priciple</th>
                        <th>Return</th>
                        <th>Action</th>
                    </tr>

                </tfoot>

            </table>

        </div>
    </div>

    @section('scripts')
        @if (session()->has('success'))
            <script>
                Swal.fire({
                    icon: 'success',
                    title: '{{ session()->get('success') }}',
                    showConfirmButton: false,
                    timer: 2000
                })
            </script>
        @endif

        <script>
            $("#customer").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $('#master').on('click', function(e) {

                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }

            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('game.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection

@endsection
