<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hosting Expired</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
        }

        .image {
            width: 100%;
            max-width: 400px;
            margin-bottom: 1.5rem;
        }

        h1 {
            color: #333;
            margin-bottom: 1rem;
        }

        .message {
            color: #555;
            margin-bottom: 1.5rem;
            font-size: 1.1rem;
        }

        strong {
            color: #d9534f;
            /* Highlighting the fee in red */
            font-size: 1.2rem;
        }

        .plan-details {
            background: #fff;
            padding: 1.5rem;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 2rem;
            max-width: 400px;
            /* Limit width for the plan details */
        }

        .plan-details h2 {
            color: #333;
            margin-bottom: 1rem;
        }

        .plan-details ul {
            list-style: none;
            padding: 0;
        }

        .plan-details li {
            color: #555;
            margin: 0.5rem 0;
        }

        .btn {
            background: #5cb85c;
            /* Green button */
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            font-size: 1rem;
            transition: background 0.3s;
        }

        .btn:hover {
            background: #4cae4c;
            /* Darker green on hover */
        }

        .btn-secondary {
            background: #ccc;
            color: #333;
        }

        .btn-secondary:hover {
            background: #bbb;
        }
    </style>
</head>

<body>
    <img src="{{ asset('dist/img/sorry.webp') }}" alt="Hosting Expired" class="image">
    <h1>We're Sorry!</h1>
    <p class="message">Your site's hosting subscription <Strong>250,000 Tsh</Strong> has expired. Please contact your
        developer for renewal</p>

    <div class="plan-details">
        <h2>250,000 Tsh Hosting Plan</h2>
        <ul>
            <li>✔ 100 GB Disk Space</li>
            <li>✔ 24/7 Customer Support</li>
            <li>✔ Free SSL Certificate</li>
            <li>✔ 99.9% Uptime Guarantee</li>
            <li>✔ Autobackup & cloud storage</li>
            <li>✔ AI Tool</li>
        </ul>
    </div>
</body>

</html>
