@extends('layouts.master')

@section('content')
    <style>
        @media print {
            .print-safe-text {
                color: black !important;
            }
        }
    </style>

    <form action="{{ route('get.income.report') }}" method="get" class="was-validated">
        <div class="card">
            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                @if ($sellingCount > 1)
                                    <select name="area" id="area" class="form-control text-center" required>
                                        <option disabled selected>-- Choose Location --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->id }}">
                                                -- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>
                                @else
                                    <input type="hidden" name="area" value="{{ $sellings[0]->id }}">
                                    <input type="text" class="form-control text-center"
                                        value="{{ $sellings[0]->location->name }}" readonly>
                                @endif
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control text-center" required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                    <option value="set duration">-- Set Duration --</option>
                                </select>
                            </td>

                            <td>
                                <input type="date" name="start" id="start"
                                    class="form-control text-center date-field" style="display:none;">
                            </td>
                            <td>
                                <input type="date" name="end" id="end"
                                    class="form-control text-center date-field" style="display:none;">
                            </td>

                            <td>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i> Search
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body table-responsive">
                <div id="report-section">
                    <!-- Dynamic Heading -->
                    <h5 class="mb-4 text-center">
                        {{ $sellings[0]->location->name ?? 'Business Name' }} — Income Statement
                        @if ($start && $end)
                            ({{ $start }} to {{ $end }})
                        @elseif($start)
                            ({{ $start }})
                        @else
                            (Today)
                        @endif
                    </h5>

                    <table class="table table-bordered text-center" style="width:100%">
                        <thead>
                            <tr style="background-color:#e0e0e0">
                                <th style="width: 25%;">Heading</th>
                                <th>Amount (TZS)</th>
                                <th>% of Net Sales</th>
                            </tr>
                        </thead>

                        <tbody>
                            <!-- Revenue -->
                            <tr style="background-color:#f8f8f8; font-weight:bold;">
                                <th colspan="3">Revenue</th>
                            </tr>
                            <tr>
                                <td style="background-color:#fafafa">Cash Sales</td>
                                <td>{{ $cashSales ? number_format($cashSales) : '-' }}</td>
                                <td>-</td>
                            </tr>
                            <tr>
                                <td style="background-color:#fafafa">Credit Sales</td>
                                <td>{{ $creditSales ? number_format($creditSales) : '-' }}</td>
                                <td>-</td>
                            </tr>
                            <tr>
                                <td style="background-color:#fafafa"><strong>Total Sales</strong></td>
                                <td><strong>{{ $totalSales ? number_format($totalSales) : '-' }}</strong></td>
                                <td>-</td>
                            </tr>

                            <!-- Less: Sales Deductions -->
                            <tr style="background-color:#f8f8f8; font-weight:bold;">
                                <th colspan="3">Less: Sales Deductions</th>
                            </tr>
                            <tr>
                                <td style="background-color:#fdf2f2">Discounts</td>
                                <td>{{ $discount ? number_format($discount) : '-' }}</td>
                                <td>-</td>
                            </tr>
                            <tr>
                                <td style="background-color:#fdf2f2">Sales Returns</td>
                                <td>{{ $salesReturn ? number_format($salesReturn) : '-' }}</td>
                                <td>-</td>
                            </tr>
                            <tr>
                                <td style="background-color:#fdf2f2"><strong>Total Deductions</strong></td>
                                <td><strong>{{ $salesDeductions ? number_format($salesDeductions) : '-' }}</strong></td>
                                <td>-</td>
                            </tr>

                            <!-- Net Sales -->
                            <tr style="font-weight:bold;">
                                <td style="background-color:#f9f9f9"><strong>Net Sales</strong></td>
                                <td><strong>{{ $netSales ? number_format($netSales) : '-' }}</strong></td>
                                <td>-</td>
                            </tr>

                            <!-- COGS -->
                            <tr style="font-weight:bold;">
                                <td>COGS</td>
                                <td>{{ $cogs ? number_format($cogs) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ $cogs ? number_format(($cogs / $netSales) * 100, 2) : '-' }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>

                            <!-- Gross Profit -->
                            <tr style="font-weight:bold;">
                                <td>Gross Profit</td>
                                <td>{{ $grossProfit ? number_format($grossProfit) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ $grossProfit ? number_format(($grossProfit / $netSales) * 100, 2) : '-' }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>

                            <!-- Expenses -->
                            <tr style="font-weight:bold;" @if (!$operatingExpenses) style="display:none;" @endif>
                                <td style="background-color:#f8d7da;">Operating Expenses</td>
                                <td>{{ $operatingExpenses ? number_format($operatingExpenses) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ number_format(($operatingExpenses / $netSales) * 100, 2) }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>

                            <tr @if (!$administrativeExpenses) style="display:none;" @endif>
                                <td style="background-color:#f8d7da;">Administrative Expenses</td>
                                <td>{{ $administrativeExpenses ? number_format($administrativeExpenses) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ number_format(($administrativeExpenses / $netSales) * 100, 2) }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>

                            <tr @if (!$sellingExpenses) style="display:none;" @endif>
                                <td style="background-color:#f8d7da;">Selling & Distribution Expenses</td>
                                <td>{{ $sellingExpenses ? number_format($sellingExpenses) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ number_format(($sellingExpenses / $netSales) * 100, 2) }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>

                            <tr @if (!$financeExpenses) style="display:none;" @endif>
                                <td style="background-color:#f8d7da;">Finance Expenses</td>
                                <td>{{ $financeExpenses ? number_format($financeExpenses) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ number_format(($financeExpenses / $netSales) * 100, 2) }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>

                            <tr @if (!$extraordinaryExpenses) style="display:none;" @endif>
                                <td style="background-color:#f8d7da;">Extraordinary Expenses</td>
                                <td>{{ $extraordinaryExpenses ? number_format($extraordinaryExpenses) : '-' }}</td>
                                <td>
                                    @if ($netSales > 0)
                                        {{ number_format(($extraordinaryExpenses / $netSales) * 100, 2) }}%
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                        </tbody>

                        <!-- Net Profit / Loss -->
                        <tfoot>
                            @if ($netProfit > 0)
                                <tr style="background-color:#20c997; font-weight:bold;">
                                    <th>Net Profit</th>
                                    <th>{{ number_format($netProfit) }}</th>
                                    <th>
                                        @if ($netSales > 0)
                                            {{ number_format(($netProfit / $netSales) * 100, 2) }}%
                                        @else
                                            -
                                        @endif
                                    </th>
                                </tr>
                            @elseif($netProfit < 0)
                                <tr style="background-color:#dc3545; font-weight:bold;">
                                    <th>Net Loss</th>
                                    <th>{{ number_format($netProfit) }}</th>
                                    <th>
                                        @if ($netSales > 0)
                                            {{ number_format(($netProfit / $netSales) * 100, 2) }}%
                                        @else
                                            -
                                        @endif
                                    </th>
                                </tr>
                            @else
                                <tr style="background-color:#6c757d; font-weight:bold;">
                                    <th>Net Profit/Loss</th>
                                    <th>-</th>
                                    <th>-</th>
                                </tr>
                            @endif
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

    <!-- Print Button -->
    <div class="text-center mt-3 mb-3">
        <button onclick="printReport()" class="btn btn-secondary">
            <i class="fa-solid fa-print"></i> Print Report
        </button>
    </div>
@endsection

@section('scripts')
    <script>
        const typeSelect = document.getElementById('type');
        const startField = document.getElementById('start');
        const endField = document.getElementById('end');

        typeSelect.addEventListener('change', function() {
            let selectedType = this.value;

            if (selectedType === 'set date') {
                startField.style.display = 'inline-block';
                endField.style.display = 'none';
                endField.value = '';
            } else if (selectedType === 'set duration') {
                startField.style.display = 'inline-block';
                endField.style.display = 'inline-block';
            } else {
                startField.style.display = 'none';
                endField.style.display = 'none';
                startField.value = '';
                endField.value = '';
            }
        });

        function printReport() {
            let originalContent = document.body.innerHTML;
            let reportContent = document.getElementById('report-section').innerHTML;
            document.body.innerHTML = reportContent;
            window.print();
            document.body.innerHTML = originalContent;
            location.reload();
        }
    </script>
@endsection
