@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <h3 class="card-title">In house geusts</h3>
        </div>

        <div class="card-body">
            <table class="table table-stripped table-hover"
                style="border: 1px solid #dee2e6; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1), 0 8px 16px rgba(0,0,0,0.1)">
                <thead style="background-color: #f8fafc; border-bottom: 2px solid #dee2e6">
                    <tr>
                        <th>#</th>
                        <th>Check-in date</th>
                        <th>Customer</th>
                        <th>Phone</th>
                        <th>Room</th>
                        <th style="width: 25%">Action</th>
                    </tr>
                </thead>

                <tbody id="tbody">
                    @if ($insideCustomers->count() > 0)
                        @foreach ($insideCustomers as $customer)
                            <tr>
                                <td>{{ $loop->index + 1 }}</td>
                                <td>{{ $customer->in_date }}</td>
                                <td>{{ $customer->customer }}</td>
                                <td>{{ $customer->phone }}</td>
                                <td>{{ $customer->room->name }}</td>
                                <td>

                                    {{-- View more model --}}
                                    <button type="button" class="btn btn-secondary" data-toggle="modal"
                                        data-target="#view-{{ $customer->id }}">
                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="view-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Customer booking details
                                                    </h5>
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <div class="modal-body">

                                                    <table class="table table-stripped">

                                                        <thead>
                                                            <th>Heading</th>
                                                            <th>Description</th>
                                                        </thead>

                                                        <tbody>

                                                            <tr>
                                                                <td>check-in date</td>
                                                                <td>{{ $customer->in_date }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Customer</td>
                                                                <td>{{ $customer->customer }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Comment</td>
                                                                <td>{{ $customer->comment }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Room</td>
                                                                <td>{{ $customer->room->name }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Price</td>
                                                                <td>{{ $customer->room->price }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Total amount</td>
                                                                <td>{{ $customer->total }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Paid amount</td>
                                                                <td>{{ $customer->paid }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Due balance</td>
                                                                <td>{{ $customer->due }}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div class="modal-footer">

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    {{-- Checkout button --}}

                                    <button type="button" class="btn btn-success" data-toggle="modal"
                                        data-target="#checkout-{{ $customer->id }}">
                                        <i class="fa fa-sign-out" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="checkout-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">
                                                        Check out customer</h5>

                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('checkout', $customer->id) }}" method="GET"
                                                    class="was-validated">

                                                    <div class="modal-body">
                                                        <label for="customer">Full name</label>
                                                        <input type="text" name="customer" id="customer"
                                                            value="{{ $customer->customer }}" class=" form-control"
                                                            readonly>

                                                        <label for="price">Room price</label>
                                                        <input type="text" name="price"
                                                            value="{{ $customer->room->price }}" id="price"
                                                            class=" form-control" readonly>

                                                        <label for="days">Days</label>
                                                        <input type="text" name="days"
                                                            value="{{ $customer->days }} Days" id="days"
                                                            class=" form-control" readonly>

                                                        <label for="paid">Paid amount</label>
                                                        <input type="text" name="paid" id="paid"
                                                            value="{{ $customer->paid }}" class="form-control paid"
                                                            readonly>

                                                        <label for="due">Due balance</label>
                                                        <input type="text" name="due" id="due{{ $customer->id }}"
                                                            value="{{ $customer->due }}" class="form-control due" readonly>

                                                        <div class="payment-details">
                                                            <label for="amount">Amount</label>
                                                            <input type="text" name="amount"
                                                                id="amount{{ $customer->id }}" class="form-control amount"
                                                                required>

                                                            <label for="account">Payment method</label>
                                                            <select name="account" id="account{{ $customer->id }}"
                                                                class="form-control account" required>
                                                                <option disabled selected value="">--Select Account--
                                                                </option>
                                                                @foreach ($accounts as $account)
                                                                    <option value="{{ $account->id }}">
                                                                        {{ $account->type }} - {{ $account->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <input type="submit" value=" Confirm check-out"
                                                            class="btn btn-info btn-block submit"
                                                            id="submit{{ $customer->id }}" style="display: none">
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Transfer to another room --}}
                                    <button type="button" class="btn btn-warning" data-toggle="modal"
                                        data-target="#transfer-{{ $customer->id }}">
                                        <i class="fa fa-exchange" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="transfer-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Room transfer</h5>
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('room.transfer', $customer->id) }}" method="GET"
                                                    class="was-validated">

                                                    <div class="modal-body">
                                                        <label for="customer">Full name</label>
                                                        <input type="text" name="customer" id="customer"
                                                            value="{{ $customer->customer }}" class=" form-control"
                                                            readonly>

                                                        <label for="from">From</label>
                                                        <input type="text" name="from"
                                                            value="{{ $customer->room->name }}" id="from"
                                                            class=" form-control" readonly>

                                                        <label for="to">To</label>
                                                        <select name="to" id="to" class="form-control">
                                                            <option>--Select room--</option>
                                                            * @foreach ($freeRooms as $free)
                                                                <option value="{{ $free->id }}">{{ $free->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                    </div>

                                                    <div class="modal-footer">
                                                        <input type="submit" value="Transfer"
                                                            class="btn btn-info btn-block" id="submit">
                                                    </div>

                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                    {{-- Deposite to another room --}}
                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                        data-target="#deposite-{{ $customer->id }}">
                                        <i class="fa-solid fa-money-check"></i>
                                    </button>

                                    <div class="modal fade" id="deposite-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Cash deposite</h5>
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('booking.deposit', $customer->id) }}"
                                                    method="GET" class="was-validated">

                                                    <div class="modal-body">
                                                        <label for="customer">Full name</label>
                                                        <input type="text" name="customer" id="customer"
                                                            value="{{ $customer->customer }}" class=" form-control"
                                                            readonly>

                                                        <label for="room">Room</label>
                                                        <input type="text" name="room"
                                                            value="{{ $customer->room->name }}" id="room"
                                                            class=" form-control" readonly>

                                                        <label for="due">Due</label>
                                                        <input type="text" name="due" id="due"
                                                            value="{{ $customer->due }}" class=" form-control" readonly>

                                                        <label for="paid">Paid</label>
                                                        <input type="number" name="paid" id="paid"
                                                            class=" form-control" required>

                                                        <label for="account">Account</label>
                                                        <select name="account" id="account" class="form-control"
                                                            required>
                                                            <option disabled selected value=""> Choose account
                                                            </option>
                                                            @foreach ($accounts as $account)
                                                                <option value="{{ $account->id }}">
                                                                    {{ $account->type }} - {{ $account->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <input type="submit" value="Confirm deposite"
                                                            class="btn btn-info btn-block" id="submit">
                                                    </div>

                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                    {{-- Edit button --}}

                                    <button type="button" class="btn btn-info" data-toggle="modal"
                                        data-target="#edit-{{ $customer->id }}">
                                        <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                    </button>

                                    <div class="modal fade" id="edit-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Update customer
                                                        details</h5>
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('booking.update', $customer->id) }}"
                                                    method="get" class="was-validated">

                                                    <div class="modal-body">

                                                        <label for="in">Check in date</label>
                                                        <input type="date" value="{{ $customer->in_date }}"
                                                            name="in" class="form-control" id="in" required>

                                                        <label for="customer">Full name</label>
                                                        <input type="text" name="customer"
                                                            value="{{ $customer->customer }}" class="form-control"
                                                            id="customer" required>

                                                        <label for="phone">Phone</label>
                                                        <input type="text" name="phone"
                                                            value="{{ $customer->phone }}" class="form-control"
                                                            id="phone" required>

                                                        <label for="comment">Comment</label>
                                                        <input type="text" name="comment"
                                                            value="{{ $customer->comment }}" class="form-control"
                                                            id="comment" required>

                                                        <label for="room">Room</label>
                                                        <input type="text" name="room"
                                                            value="{{ $customer->room->name }}" class="form-control"
                                                            id="room" readonly required>

                                                        <label for="price">Room price</label>
                                                        <input type="number" name="price"
                                                            value="{{ $customer->room->price }}" class="form-control"
                                                            id="price" readonly required>

                                                        <div id="account-div" style="display: none">
                                                            <label for="account">Account</label>
                                                            <select name="account" id="account" class="form-control">
                                                                <option disabled selected value=""> Choose account
                                                                </option>
                                                                @foreach ($accounts as $account)
                                                                    <option value="{{ $account->id }}">
                                                                        {{ $account->type }} - {{ $account->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>


                                                        <label for="status"> Status</label>
                                                        <select name="status" value="{{ $customer->status }}"
                                                            class="form-control" required>
                                                            <option value="{{ $customer->status }}" selected>
                                                                {{ $status == 1 ? 'Check-In' : 'Booking' }}</option>
                                                            <option value="check-in">Check in</option>
                                                            <option value="booking ">Booking</option>
                                                        </select>

                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit"
                                                            class="btn btn-info btn-block">Update</button>
                                                    </div>

                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                    {{-- delete model --}}

                                    <button class="btn btn-danger delete" id="{{ $customer->id }}">
                                        <i class="fa fa-trash fa-lg" aria-hidden="true"></i>

                                        <form action="{{ route('booking.delete', $customer->id) }}" method="GET"
                                            id="deleteform{{ $customer->id }}">
                                        </form>
                                    </button>

                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr style="border-bottom: 1px solid #dee2e6">
                            <td colspan="6">
                                <center><h4>No available check outs for Now..</h4></center>
                            </td>
                        </tr>
                    @endif
                </tbody>

                <tfoot>
                    <tr>
                        <th>#</th>
                        <th>Check-in date</th>
                        <th>Customer</th>
                        <th>Phone</th>
                        <th>Room</th>
                        <th>Action</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $(document).ready(function() {
            $("#customer").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $(".amount").on("keyup", function() {
                let id = $(this).attr("id").replace("amount", "");
                let amountInput = $(this).val();
                let dueAmount = $("#due" + id).val();
                if (amountInput === dueAmount) {
                    $("#amount" + id).attr("readonly", true);
                    $("#submit" + id).fadeIn("slow");
                }
            });

            $(".delete").on("click", function() {
                let id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });

        });
    </script>
@endsection
@endsection
