@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#ipModal">
                <i class="fas fa-plus"></i>
                Register IP
            </button>

            <!-- Modal -->
            <div class="modal fade" id="ipModal" tabindex="-1" role="dialog" aria-labelledby="ipModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="ipModalLabel">Register IP address</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ Route('store.ip') }}" method="post" class="was-validated">
                            @csrf
                            <div class="modal-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover align-middle mb-0" id="table">
                                        <thead class="thead-dark text-center">
                                            <tr>
                                                <th scope="col" style="width:5%">#</th>
                                                <th scope="col">IP Address</th>
                                                <th scope="col" style="width:10%">
                                                    <button type="button" class="btn btn-success btn-sm" id="addRow"
                                                        title="Add IP">
                                                        <i class="fas fa-plus"></i>
                                                    </button>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody" class="text-center align-middle">
                                            <!-- Dynamic rows will be added here -->
                                        </tbody>
                                    </table>
                                </div>
                                <p class="text-muted mt-2 mb-0"><small>Add multiple IP addresses before submitting.</small>
                                </p>
                            </div>
                            <div class="modal-footer">
                                <div class="btn-group" role="group" aria-label="Unit Actions">
                                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i
                                            class="fas fa-times"></i> Close</button>
                                    <button type="submit" class="btn btn-primary bt-sm"><i class="fas fa-paper-plane"></i>
                                        Register IP</button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="card-body table-responsive">
        <table class="table table-striped table-hover table-bordered align-middle text-center">
            <thead class="thead-dark">
                <tr>
                    <th style="width: 5%">#</th>
                    <th>IP Address</th>
                    <th style="width: 18%">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($ips as $ip)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $ip->name }}</td>
                        <td>
                            <!-- Delete Button -->
                            <form action="{{ route('delete.ip', $ip->id) }}" method="POST"
                                id="deleteform{{ $ip->id }}" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="button" class="btn btn-danger btn-sm delete" id="{{ $ip->id }}"
                                    title="Delete">
                                    <i class="fa fa-trash-alt"></i>
                                </button>
                            </form>

                            <!-- Edit Button -->
                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                data-target="#edit-{{ $ip->id }}" title="Edit">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </button>

                            <!-- Edit Modal -->
                            <div class="modal fade" id="edit-{{ $ip->id }}" tabindex="-1"
                                aria-labelledby="editLabel{{ $ip->id }}" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <div class="modal-header">
                                            <h5 class="modal-title" id="editLabel{{ $ip->id }}">Edit IP Address</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>

                                        <form action="{{ route('update.ip', $ip->id) }}" method="POST"
                                            class="was-validated">
                                            @csrf
                                            @method('PUT')
                                            <div class="modal-body">
                                                <input type="text" name="name" class="form-control text-center"
                                                    value="{{ $ip->name }}" required>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-primary btn-block">
                                                    <i class="fa-solid fa-pen-to-square"></i> Update
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center py-5">
                            <div class="d-flex flex-column align-items-center">
                                <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                    style="width: 80px; opacity: 0.5;">
                                <h5 class="mt-3 text-secondary font-weight-bold">No Units Found</h5>
                                <p class="text-muted mb-0">You haven't added any Units yet.<br>
                                    <span class="small">Click <strong>Register Unit</strong> to get
                                        started.</span>
                                </p>
                            </div>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    </div>

    @section('scripts')
        @if (session()->has('success'))
            <script>
                Swal.fire({
                    icon: 'success',
                    title: '{{ session()->get('success') }}',
                    showConfirmButton: false,
                    timer: 2000
                })
            </script>
        @elseif (session()->has('primary bt-sm'))
            <script>
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: '{{ session()->get('primary bt-sm') }}',
                });
            </script>
        @endif

        <script type="text/javascript">
            $(document).ready(function() {

                var index = 1;

                // add row
                $("#addRow").click(function(e) {
                    e.preventDefault();

                    var tr =

                        '<tr id="tr' + index + '">' +

                        '<td>' + index + '</td>' +

                        '<td><input type="text" name="ip[]" class="form-control" placeholder="Enter Ip address" style = "text-align: center;" required></td>' +

                        '<td><button type="button" id="' + index +
                        '" class="btn btn-danger removerow"><i class="fa fa-trash-alt fa-sm"></i></button></td>' +

                        '</tr>';

                    $("#tbody").append(tr);
                    index++;

                    $(".removerow").on("click", function() {
                        var id = $(this).attr("id");
                        $("#tr" + id).remove();
                    });
                });

                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });

            });
        </script>
    @endsection

@endsection
