@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <!-- Trigger Button -->
            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#assignIngredientsModal">
                <i class="fa fa-plus"></i> Assign Ingredients
            </button>

            <!-- Modal -->
            <div class="modal fade" id="assignIngredientsModal" tabindex="-1" role="dialog"
                aria-labelledby="assignIngredientsModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h5 class="modal-title" id="assignIngredientsModalLabel">
                                Assign Ingredients to <strong>{{ $product->product }}</strong>
                            </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <form action="{{ route('assign.ingridients', $product->id) }}" method="get"
                                class="was-validated">
                                @csrf

                                <input type="hidden" id="servicearea" class="form-control"
                                    value="{{ $product->location->name }}">

                                <div class="card card-primary">
                                    <div class="card-body">
                                        <table class="table table-striped text-center">
                                            <thead>
                                                <tr>
                                                    <th style="width: 5%">#</th>
                                                    <th style="width: 35%">Product</th>
                                                    <th style="width: 25%">Unit</th>
                                                    <th style="width: 20%">Qty</th>
                                                    <th>
                                                        <button type="button" class="btn btn-primary btn-sm addRow"
                                                            id="addRow">
                                                            <i class="fa fa-plus"></i>
                                                        </button>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody">
                                                <!-- Dynamic rows go here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-secondary btn-sm"
                                            data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary btn-sm">Confirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <div class="table-responsive rounded shadow-sm mt-3">
                <table class="table table-bordered table-hover align-middle text-center mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th style="width: 5%">#</th>
                            <th>Ingredient</th>
                            <th>Quantity</th>
                            <th style="width: 15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($menuItems as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td class="text-start">{{ $item->ingredient->name }}</td>
                                <td>{{ $item->qty }} {{ $item->ingredient->unit->name }}</td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger delete" id="{{ $item->id }}">
                                        <i class="fa fa-trash-alt"></i>
                                    </button>

                                    <form action="{{ route('delete.product.item', $item->id) }}" method="GET"
                                        id="deleteform{{ $item->id }}" style="display: none;">
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Ingridients Found</h5>
                                        <p class="text-muted mb-0">You haven't assigned any ingridients yet.<br>
                                            <span class="small">Click <strong>Assign Ingredients</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $("#assigned").DataTable();

            var index = 1;
            // add row
            $(".addRow").on("click", function() {

                let row = `
                        <tr id="tr${index}">
                            <td>
                                <input type="hidden" value="" name="id[]" id="id${index}" class="form-control id" style="text-align: center" readonly>
                            </td>

                            <td style="position: relative;">
                                <input type="search" name="search[]" class="form-control search" id="search${index}" placeholder="Search by product name or barcode.." required>
                                <div id="list${index}" 
                                    style="display:none; position: absolute; z-index: 10; width: 100%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);" 
                                    class="bg-white border border-primary">
                                    <ol id="results${index}" class="list-group list-group-flush"></ol>
                                </div>
                            </td>

                            <td>
                                <input type="hidden" value="" name="unit-id[]" id="unit-id${index}" class="form-control unit-id" style="text-align: center" readonly>
                                <input type="text" name="unit[]" class="form-control unit" id="unit${index}" placeholder="Unit.." required>
                            </td>

                            <td>
                                <input type="text" name="qty[]" id="qty${index}" class="form-control qty" style="text-align: center" required>
                            </td>

                            <td>
                                <button type="button" id="${index}" class="btn btn-danger removeRow">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </td>
                        </tr>
                        `;


                $("#tbody").append(row);
                index++;

                $(".removeRow").on("click", function() {
                    var id = $(this).attr("id");
                    $("#tr" + id).remove();
                });

            });

            $(document).on("keyup", ".search", function() {
                var id = $(this).attr("id").replace("search", "");
                var search = $(this).val();
                var ujumbe = "No suggestions..";

                $.ajax({

                    url: "{{ route('get.ingredients') }}",
                    method: "get",
                    item: {
                        'item': search
                    },
                    success: function(response) {
                        $("#results" + id).empty();
                        console.log(response);

                        if (search != "") {
                            if (response.length == 0) {
                                $("#list" + id).fadeIn("slow");
                                $("#results" + id).append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            for (var i = 0; i < response.length; i++) {
                                $("#list" + id).fadeIn("slow");
                                $("#results" + id).append(
                                    '<li><button type="button" class="form-control items btn btn-outline-secondary" id="' +
                                    response[i].id + '">' +
                                    response[i].name + '</button></li>');

                                var unit = response[i].unit.name;
                                var unitId = response[i].unit.id;

                                $(".items").on("click", function() {
                                    var ingredientId = $(this).attr("id");
                                    var selected = $(this).html();
                                    $("#id" + id).val(ingredientId);
                                    $("#search" + id).val(selected);
                                    $("#unit-id" + id).val(unitId);
                                    $("#unit" + id).val(unit);
                                    $("#list" + id).fadeOut("slow");
                                });
                            }
                        }
                    }
                });
            });

            $(document).on("change", ".unit", function() {
                var unitId = $(this).val();
                var index = $(this).attr("id").replace("unit", "");
                var productId = $("#id" + index).val();
                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    item: {
                        'unitId': unitId,
                        'productId': productId,
                    },

                    success: function(item) {
                        console.log(item.unit_cont);
                        $("#cont" + index).val(item.unit_cont);
                    }
                });
            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection
@endsection
