@extends('layouts.master')

@section('content')

    {{-- Content body (Page Body) --}}
    <div class="content">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">📦 Products Missing Prices</h4>
            </div>

            <div class="card-body">
                <h5 class="mb-3 text-secondary">🛒 Products Missing Buying Prices</h5>

                @if ($missingBuyingPrices->isEmpty())
                    <p class="text-success">✅ All products have buying prices.</p>
                @else
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead class="bg-dark text-white">
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Buying</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($missingBuyingPrices as $index => $product)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $product->product ?? 'N/A' }}</td>
                                        <td class="text-danger font-weight-bold">{{ $product->buying ?? 'N/A' }}</td>
                                        <td>{{ $product->location->name ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif

                <hr class="my-4">

                <h5 class="mb-3 text-secondary">💰 Products Missing Selling Prices</h5>

                @if ($missingSellingPrices->isEmpty())
                    <p class="text-success">✅ All products have selling prices.</p>
                @else
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead class="bg-dark text-white">
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Unit</th>
                                    <th>Unit Content</th>
                                    <th>Selling</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($missingSellingPrices as $index => $product)
                                    @if ($product->unit->isEmpty())
                                        <tr class="table-warning text-center">
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $product->product ?? 'N/A' }}</td>
                                            <td colspan="4" class="text-danger font-italic">No unit assigned</td>
                                        </tr>
                                    @else
                                        @foreach ($product->unit as $unit)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $product->product ?? 'N/A' }}</td>
                                                <td>{{ $unit->unit->name ?? 'N/A' }}</td>
                                                <td>{{ $unit->unit_cont ?? 'N/A' }}</td>
                                                <td class="text-danger font-weight-bold">Missing</td>
                                                <td>{{ $product->location->name ?? 'N/A' }}</td>
                                            </tr>
                                        @endforeach
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $("#data-table").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
    </script>
@endsection

@endsection
