@extends('layouts.master')

@section('content')

    <div class="card mb-3">
        <div class="card-header">
            <h5>New Customer Order</h5>
        </div>

        <div class="card-body">
            <div class="container-fluid">
                <form action="{{ route('customer.order.store', ['flag' => $flag, 'id' => $id]) }}" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-10">
                            <table class="table table-stripped table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col" style="width: 45%">Product</th>
                                        <th scope="col" style="width: 15%">Buying</th>
                                        <th scope="col" style="width: 15%">Selling</th>
                                        <th scope="col" style="width: 8%">Qty</th>
                                        <th scope="col" style="width: 8%">Profit</th>
                                        <th scope="col" style="width: 5%">Margin</th>
                                        <th scope="col"><button type="button" class="btn btn-outline-info"
                                                id="addRow"><i class="fas fa-plus"></i></button></th>
                                    </tr>
                                </thead>

                                @php
                                    $iteration = 200;
                                @endphp


                                <tbody id="tbody">
                                    @if (session('orderItems'))
                                        @foreach (session('orderItems') as $key => $item)
                                            @php
                                                $iteration++;
                                            @endphp

                                            <tr id="tr{{ $key }}">
                                                <td><input type="text" class="form-control"
                                                        id="product{{ $iteration }}" name="product[]"
                                                        placeholder="Enter Product name.." required
                                                        value="{{ $item['product'] }}"></td>
                                                <td><input type="number" class="form-control buying_price"
                                                        id="buying_price{{ $iteration }}" name="buying_price[]"
                                                        placeholder="Buying Price" required
                                                        value="{{ $item['buying_price'] }}"></td>
                                                <td><input type="number" class="form-control selling_price"
                                                        id="selling_price{{ $iteration }}" name="selling_price[]"
                                                        placeholder="Selling Price" required
                                                        value="{{ $item['selling_price'] }}"></td>
                                                <td><input type="number" class="form-control qty"
                                                        id="qty{{ $iteration }}" name="qty[]" placeholder="Qty"
                                                        required value="{{ $item['qty'] }}"></td>
                                                <td id="profit{{ $iteration }}">
                                                    {{ $item['selling_price'] - $item['buying_price'] }}</td>
                                                <td id="margin{{ $iteration }}">
                                                    {{ round((($item['selling_price'] - $item['buying_price']) / $item['selling_price']) * 100, 2) }}%
                                                </td>
                                                <td><button type="button" class="btn btn-outline-danger removeRow"
                                                        id="removeRow{{ $iteration }}"><i
                                                            class="fas fa-trash-alt"></i></button></td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>

                        <div class="col was-validated">
                            <input type="date" class="form-control" id="date" name="date"
                                value="{{ date('Y-m-d') }}" style="text-align: center;" required>

                            <input type="number" class="form-control" id="total-selling" name="total-selling"
                                placeholder="Total Selling"
                                value="{{ optional(session('orderDetails'))['total_selling'] }}" readonly
                                style="text-align: center;">

                            <input type="number" class="form-control" id="total-buying" name="total-buying"
                                placeholder="Total Buying" value="{{ optional(session('orderDetails'))['total_buying'] }}"
                                readonly style="text-align: center;">

                            <input type="number" class="form-control" id="total-profit" name="total-profit"
                                placeholder="Total Profit"
                                value="{{ optional(session('orderDetails'))['total_selling'] - optional(session('orderDetails'))['total_buying'] }}"
                                readonly style="text-align: center;">

                            <input type="number" class="form-control" id="paid" name="paid" placeholder="Paid"
                                value="" style="text-align: center;" required>

                            <input type="number" class="form-control" id="due" name="due"
                                placeholder="Due balance" value="" readonly style="text-align: center;">

                            <select class="form-control" id="account" name="account" required
                                style="text-align: center;" required>
                                <option disabled selected>-- Choose Account --</option>
                                @foreach ($accounts as $account)
                                    <option value="{{ $account->id }}">-- {{ $account->type }} - {{ $account->name }} --
                                    </option>
                                @endforeach
                            </select>

                            <select class="form-control" id="customer" name="customer" required
                                style="text-align: center;" required>
                                <option disabled selected>-- Choose Customer --</option>
                                @foreach ($customers as $customer)
                                    <option value="{{ $customer->id }}">-- {{ $customer->name }} --</option>
                                @endforeach
                            </select>

                            <button type="submit" class="btn btn-outline-info btn-block" style="margin-top: 10px;"><i
                                    class="fas fa-paper-plane"></i> Confirm</button>
                            <button class="btn btn-outline-danger btn-block" type="reset"><i class="fas fa-ban"></i>
                                Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            });
        </script>
    @endif

    <script>
        let index = {{ count(session('orderItems', [])) }};

        $(document).on("click", "#addRow", function() {
            let tr = `
                <tr id="tr${index}">
                    <td><input type="text" class="form-control" id="product${index}" name="product[]" placeholder="Enter Product name.." required></td>
                    <td><input type="number" class="form-control buying_price" id="buying_price${index}" name="buying_price[]" placeholder="Buying Price" required></td>
                    <td><input type="number" class="form-control selling_price" id="selling_price${index}" name="selling_price[]" placeholder="Selling Price" required></td>
                    <td><input type="number" class="form-control qty" id="qty${index}" name="qty[]" placeholder="Qty" required></td>
                    <td id="profit${index}">0</td>
                    <td id="margin${index}">0%</td>
                    <td><button type="button" class="btn btn-outline-danger removeRow" data-row-id="${index}"><i class="fas fa-trash-alt"></i></button></td>
                </tr>`;
            $("#tbody").append(tr);
            index++;
        });

        $(document).on("click", ".removeRow", function() {
            let rowId = $(this).data("row-id");
            $(`#tr${rowId}`).remove();
            updateRowIndexes();
            calculateTotal();
        });

        $(document).on("input", ".buying_price, .selling_price, .qty", function() {
            calculateTotal();
        });

        function updateRowIndexes() {
            $("#tbody tr").each(function(i) {
                $(this).attr("id", "tr" + i);
                $(this).find(".buying_price").attr("id", "buying_price" + i);
                $(this).find(".selling_price").attr("id", "selling_price" + i);
                $(this).find(".qty").attr("id", "qty" + i);
                $(this).find("#profit" + i).attr("id", "profit" + i);
                $(this).find("#margin" + i).attr("id", "margin" + i);
                $(this).find(".removeRow").data("row-id", i);
            });
            index = $("#tbody tr").length; // Reset the index based on the new row count
        }

        function calculateTotal() {
            let totalBuying = 0;
            let totalSelling = 0;
            let totalProfit = 0;

            $("tbody tr").each(function() {
                let id = $(this).attr("id").replace("tr", "");
                let buyingPrice = Number($("#buying_price" + id).val()) || 0;
                let sellingPrice = Number($("#selling_price" + id).val()) || 0;
                let qty = Number($("#qty" + id).val()) || 0;

                let buyingTotal = buyingPrice * qty;
                let sellingTotal = sellingPrice * qty;

                totalBuying += buyingTotal;
                totalSelling += sellingTotal;

                let profit = sellingTotal - buyingTotal;
                totalProfit += profit;

                let profitMargin = buyingPrice ? ((profit / buyingTotal) * 100).toFixed(2) + '%' : '0%';

                $("#profit" + id).text(profit);
                $("#margin" + id).text(profitMargin);
            });

            $("#total-buying").val(totalBuying);
            $("#total-selling").val(totalSelling);
            $("#total-profit").val(totalProfit);
        }

        $("#paid").on("keyup", function() {
            let paid = Number($(this).val()) || 0;
            let totalSelling = Number($("#total-selling").val()) || 0;
            let due = totalSelling - paid;
            $("#due").val(due);
        });
    </script>
@endsection

@endsection
