<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ config('app.name') }}</title>

    {{-- Google Font: Source Sans Pro --}}
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    {{-- Font Awesome Icons --}}
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/css/font-awesome.css') }}">
    {{-- Theme style --}}
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
    {{-- Sweet Alert --}}
    <link rel="stylesheet" href="{{ asset('plugins/sweetalert2/sweetalert2.min.css') }}">
    {{-- DataTable --}}
    <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">

    <style>
        .invoice {
            padding: 3%;
        }

        .status {
            border: solid;
            border-color: grey;
            border-radius: 40px;
            padding-top: 0px;
            height: 20%;
            font-size: 14px
        }
    </style>

</head>

<body>

    <section class="invoice">
        <!-- title row -->
        <div class="row">
            <div class="col-12">
                <h2 class="page-header">
                    <i class="fas fa-globe"></i> {{ $profile->name }}.
                    <small class="float-right">Date: {{ $currentDate }}</small>
                </h2>
            </div>
            <!-- /.col -->
        </div>

        <!-- info row -->
        <div class="row invoice-info">
            <div class="col-sm-4 invoice-col">
                From
                <address>
                    <strong>{{ $profile->name }}</strong><br>
                    Address: {{ $profile->address }}<br>
                    Phone: {{ $profile->phone }}<br>
                    Email: {{ $profile->email }}
                </address>
            </div>
            <!-- /.col -->
            <div class="col-sm-4 invoice-col">
                To
                <address>
                    @foreach ($sale->customers as $customer)
                        <strong>{{ $customer->name }}</strong><br>
                        Address: {{ $customer->address }}<br>
                        Phone: {{ $customer->phone }}<br>
                        Email: {{ $customer->email }}
                    @endforeach
                </address>
            </div>
            <!-- /.col -->
            <div class="col-sm-4 invoice-col">
                <b>Invoice #000{{ $sale->id }}</b><br>
                <br>
                <b>Order ID:</b> #{{ $sale->id }}<br>
                <b>Due date:</b> {{ $sale->duedate }}<br>
                <b>Status:
                    @if ($sale->due)
                        <button class="btn btn-warning status">Pending</button>
                    @else
                        <button class="btn btn-success status">Cleared</button>
                    @endif
                </b>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

        <!-- Table row -->
        <div class="row">
            <div class="col-12 table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Price</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($sale->items as $item)
                            <tr>
                                <td>{{ $item->product }}</td>
                                <td>{{ $item->qty }}</td>
                                <td>{{ $item->price }}</td>
                                <td>{{ $item->amount }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

        <div class="row">
            <!-- accepted payments column -->
            <div class="col-6">
                <p class="lead">Payment Methods:</p>
                <img src="{{ asset('dist/img/credit/visa.png') }}" alt="Visa">
                <img src="{{ asset('dist/img/credit/mastercard.png') }}" alt="Mastercard">
                <img src="{{ asset('dist/img/credit/american-express.png') }}" alt="American Express">
                <img src="{{ asset('dist/img/credit/paypal2.png') }}" alt="Paypal">

                <p class="text-muted well well-sm shadow-none" style="margin-top: 10px;">
                    Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning heekya handango
                    imeem plugg dopplr
                    jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.
                </p>
            </div>
            <!-- /.col -->

            <div class="col-6">
                <p class="lead">Amount Due {{ $sale->due }}</p>

                <div class="table-responsive">
                    <table class="table">
                        <tr>
                            <th style="width:50%">Subtotal:</th>
                            <td>Tsh {{ $sale->total }}</td>
                        </tr>

                        <tr>
                            <th>- Discount: </th>
                            @if ($sale->discount)
                                <td> Tsh 5.80</td>
                            @else
                                <td>Tsh 0</td>
                            @endif
                        </tr>
                        <tr>
                            <th>- Tax (18%)</th>
                            @if ($sale->tax)
                                <td> Tsh {{ $sale->tax }}</td>
                            @else
                                <td>Tsh 0</td>
                            @endif
                        </tr>

                        <tr>
                            <th>+ Transport:</th>
                            @if ($sale->transport)
                                <td> Tsh 5.80</td>
                            @else
                                <td>Tsh 0</td>
                            @endif
                        </tr>

                        <tr>
                            <th>-Paid:</th>
                            <td>Tsh {{ $sale->paid }}</td>
                        </tr>

                        <tr>
                            <th>Due Balance:</th>
                            <td>Tsh {{ $sale->due }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            <!-- /.col -->

        </div>
        <!-- /.row -->

    </section>
    <!-- /.content -->

    {{-- jQuery --}}
    <script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
    {{-- Bootstrap 4 --}}
    <script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    {{-- Sweet Alert --}}
    <script src="{{ asset('plugins/sweetalert2/sweetalert2.min.js') }}"></script>
    {{-- DataTable --}}
    <script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>
    <script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/vfs_fonts.js') }}"></script>
    {{-- AdminLTE App --}}
    <script src="{{ asset('dist/js/adminlte.min.js') }}"></script>
    <script>
        window.addEventListener("load", window.print());
    </script>
</body>

</html>
