@extends('layouts.master')

@section('content')
    <style>
        .invoice {
            padding: 3%;
        }
        .status{
            border: solid;
            border-color: grey;
            border-radius: 40px;
            padding-top: 0px;
            height: 20%;
            font-size: 14px
        }
    </style>

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5>Invoice</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <!-- Main content -->
        <div class="invoice">

            <!-- title row -->
            <div class="row">
                <div class="col-12">
                    <h4>
                        <i class="fas fa-globe"></i> {{ $profile->name}}.
                        <small class="float-right">Date: {{$currentDate}}</small>
                    </h4>
                </div>
                <!-- /.col -->
            </div>

            <!-- info row -->
            <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                    From
                    <address>
                        <strong>{{$profile->name}}</strong><br>
                        Address: {{$profile->address}}<br>
                        Phone: {{$profile->phone}}<br>
                        Email: {{$profile->email}}
                    </address>
                </div>
                <!-- /.col -->
                <div class="col-sm-4 invoice-col">
                    To
                    <address>
                        @foreach ($sale->customers as $customer)
                        <strong>{{$customer->name}}</strong><br>
                        Address: {{ $customer->address}}<br>
                        Phone: {{ $customer->phone}}<br>
                        Email: {{$customer->email}}
                        @endforeach
                    </address>
                </div>
                <!-- /.col -->
                <div class="col-sm-4 invoice-col">
                    <b>Invoice #000{{$sale->id}}</b><br>
                    <br>
                    <b>Order ID:</b> #{{$sale->id}}<br>
                    <b>Payment Due:</b> {{$sale->duedate}}<br>
                    <b>Status:
                        @if ($sale->due)
                        <button class="btn btn-warning status">Pending</button>
                        @else
                        <button class="btn btn-success status">Cleared</button>
                        @endif</b>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->

            <!-- Table row -->
            <div class="row">
                <div class="col-12 table-responsive">
                    <table class="table table-striped">

                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Qty</th>
                                <th>Price</th>
                                <th>Amount</th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($sale->items as $item )
                            <tr>
                                <td>{{$item->product}}</td>
                                <td>{{$item->qty}}</td>
                                <td>{{$item->price}}</td>
                                <td>{{$item->amount}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->

            <div class="row">
                <!-- accepted payments column -->
                <div class="col-6">
                    <p class="lead">Payment Methods:</p>
                    <img src="{{ asset('dist/img/credit/visa.png') }}" alt="Visa">
                    <img src="{{ asset('dist/img/credit/mastercard.png') }}" alt="Mastercard">
                    <img src="{{ asset('dist/img/credit/american-express.png') }}" alt="American Express">
                    <img src="{{ asset('dist/img/credit/paypal2.png') }}" alt="Paypal">

                    <p class="text-muted well well-sm shadow-none" style="margin-top: 10px;">
                        Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning
                        heekya handango imeem
                        plugg
                        dopplr jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.
                    </p>
                </div>
                <!-- /.col -->

                <div class="col-6">
                    <p class="lead">Amount Due {{$sale->due}}</p>

                    <div class="table-responsive">
                        <table class="table">
                            <tr>
                                <th style="width:50%">Subtotal:</th>
                                <td>Tsh {{$sale->total}}</td>
                            </tr>

                            <tr>
                                <th>- Discount: </th>
                                @if ($sale->discount)
                                <td> Tsh 5.80</td>
                                @else
                                <td>Tsh 0</td>
                                @endif
                            </tr>

                            <tr>
                                <th>- Tax (18%)</th>
                                @if ($sale->tax)
                                <td> Tsh {{$sale->tax}}</td>
                                @else
                                <td>Tsh 0</td>
                                @endif
                            </tr>

                            <tr>
                                <th>+ Transport:</th>
                                @if ($sale->transport)
                                <td> Tsh 5.80</td>
                                @else
                                <td>Tsh 0</td>
                                @endif
                            </tr>

                            <tr>
                                <th>-Paid:</th>
                                <td>Tsh {{$sale->paid}}</td>
                            </tr>

                            <tr>
                                <th>Due Balance:</th>
                                <td>Tsh {{$sale->due}}</td>
                            </tr>

                        </table>
                    </div>
                </div>
                <!-- /.col -->

            </div>
            <!-- /.row -->

            <!-- this row will not appear when printing -->
            <div class="row no-print">
                <div class="col-12">
                    <a href="{{ route('print.sale.invoice', $sale->id) }}" rel="noopener" target="_blank" class="btn btn-default"><i
                            class="fas fa-print"></i> Print</a>

                    @if ($sale->due > 0)
                    <button type="button" class="btn btn-success float-right" data-toggle="modal"
                        data-target="#deposite"><i class="far fa-credit-card"></i>
                       Submit payment
                    </button>

                    <div class="modal fade" id="deposite" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <h5 class="modal-title">Pay now</h5>
                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>

                                <form action="{{ route('pay.customer.debt', $sale->id) }}" method="get">
                                    @csrf

                                    <div class="modal-body">

                                        <label for="date">Date</label>
                                        <input type="date" name="date" class="form-control" id="date"
                                            value="{{ date('Y-m-d') }}" required>

                                        <label for="customer">Customer</label>
                                        <input type="text" name="customer" class="form-control" id="customer"
                                            value="{{ $sale->customer }}" readonly>

                                        <label for="due">Due amount</label>
                                        <input type="text" name="due" class="form-control" id="due"
                                            value="{{ $sale->due }}" readonly>

                                        <label for="paid">Paid amount</label>
                                        <input type="text" name="paid" class="form-control" id="3" required>

                                        <label for="account"> Account Name</label>
                                        <select name="account" class="form-control" id="account" required>
                                            <option disabled selected value="">--Choose Account--</option>
                                            @foreach (App\Models\Account::all() as $account)
                                                <option value="{{ $account->name }}">
                                                    {{ $account->name }}
                                                </option>
                                            @endforeach
                                        </select>

                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-info btn-block">Confirm payment</button>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                @endif

                    <button type="button" class="btn btn-primary float-right" style="margin-right: 5px;">
                        <i class="fas fa-download"></i> Generate PDF
                    </button>
                </div>
            </div>

        </div>
    </div>
    {{-- /.content --}}

@section('scripts')
@if (session()->has('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: '{{ session()->get('success') }}',
        showConfirmButton: false,
        timer: 2000
    })
</script>
@endif

@endsection
@endsection
