@extends('layouts.master')

@section('content')
    <div class="container-fluid">
        <div class="card shadow-lg border-0 rounded-lg">
            <div class="card-header bg-primary text-white d-flex align-items-center">
                <h6 class="mb-0"><i class="fas fa-plus-circle mr-2"></i>Create New Requisition</h6>
            </div>
            <div class="card-body">
                <form action="{{ route('requisition.store') }}" method="POST">
                    @csrf

                    {{-- Top Row: Remarks & Location --}}
                    <div class="row mb-3">
                        <div class="col-md-4 mb-3">
                            <label for="location" class="font-weight-bold">
                                <i class="fas fa-map-pin text-info mr-1"></i> Location
                            </label>
                            <select name="location" id="location" class="form-control shadow-sm text-center" required>
                                <option disabled selected value="">-- Choose Location --</option>
                                @foreach ($sellings as $selling)
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="location" class="font-weight-bold">
                                <i class="fas fa-map-pin text-info mr-1"></i> Supplier
                            </label>
                            <select name="supplier" id="supplier" class="form-control shadow-sm text-center">
                                <option disabled selected value="">-- Choose Supplier --</option>
                                @foreach ($suppliers as $supplier)
                                    <option value="{{ $supplier->id }}">-- {{ $supplier->name }} --
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="remarks" class="font-weight-bold">
                                <i class="fas fa-comment-alt text-info mr-1"></i> Remarks
                            </label>
                            <textarea name="remarks" id="remarks" class="form-control shadow-sm" rows="1"
                                placeholder="Reason for this requisition..."></textarea>
                        </div>
                    </div>

                    {{-- Items Table --}}
                    <div class="table-responsive mt-4">
                        <table class="table table-bordered table-hover" id="items-table">
                            <thead class="thead-light text-center">
                                <tr>
                                    <th style="width: 30%"><i class="fas fa-box-open"></i> Product</th>
                                    <th style="width: 15%"><i class="fas fa-balance-scale"></i> Unit</th>
                                    <th style="width: 15%"><i class="fas fa-sort-numeric-up"></i> Qty</th>
                                    <th style="width: 30%"><i class="fas fa-sticky-note"></i> Note</th>
                                    <th style="width: 10%"><i class="fas fa-cogs"></i> Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class="position-relative">
                                        <input type="text" name="search[]" id="search0"
                                            class="form-control text-center search" placeholder="Search product..."
                                            required>
                                        <div id="list0"
                                            class="position-absolute bg-white border border-primary w-100 rounded-bottom shadow-sm"
                                            style="display:none; z-index: 1000;">
                                            <ol id="results0" class="list-group list-group-flush"></ol>
                                        </div>
                                        <input type="hidden" name="product_id[]" id="id0">
                                        <input type="hidden" name="price[]" id="price0">
                                        <input type="hidden" name="cont[]" id="cont0">
                                    </td>
                                    <td>
                                        <select name="unit[]" id="unit0" class="form-control text-center unit"
                                            required>
                                            <option disabled selected>-- Select Unit --</option>
                                            @foreach ($units as $unit)
                                                <option value="{{ $unit->id }}">-- {{ $unit->name }} --</option>
                                            @endforeach
                                        </select>
                                    </td>
                                    <td>
                                        <input type="number" name="qty[]" class="form-control text-center qty"
                                            min="1" required>
                                    </td>
                                    <td>
                                        <input type="text" name="note[]" class="form-control text-center note"
                                            placeholder="Optional note....">
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-sm remove-row">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    {{-- Add Item --}}
                    <button type="button" class="btn btn-primary btn-sm mb-3 shadow-sm" id="add-row">
                        <i class="fas fa-plus"></i> Add Item
                    </button>

                    {{-- Submit --}}
                    <div class="text-right">
                        <button type="submit" class="btn btn-success px-4 shadow-sm">
                            <i class="fas fa-paper-plane mr-1"></i> Submit Requisition
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@section('scripts')
    {{-- Dynamic Row Script --}}
    <script>
        let rowCount = 1;

        // Add new row dynamically
        $('#add-row').on('click', function() {
            const newRow = `
            <tr>
                <td class="position-relative">
                    <input type="text" name="search[]" id="search${rowCount}" class="form-control text-center search" placeholder="Search product..." required>
                    <div id="list${rowCount}" class="position-absolute bg-white border border-primary w-100 rounded-bottom shadow-sm" style="display:none; z-index: 1000;">
                        <ol id="results${rowCount}" class="list-group list-group-flush"></ol>
                    </div>
                    <input type="hidden" name="product_id[]" id="id${rowCount}">
                    <input type="hidden" name="price[]" id="price${rowCount}">
                    <input type="hidden" name="cont[]" id="cont${rowCount}">
                </td>
                <td>
                    <select name="unit[]" id="unit${rowCount}" class="form-control text-center unit" required>
                        <option disabled selected>-- Select Unit --</option>
                        @foreach ($units as $unit)
                            <option value="{{ $unit->id }}">-- {{ $unit->name }} --</option>
                        @endforeach
                    </select>
                </td>
                <td>
                    <input type="number" name="qty[]" class="form-control text-center qty" min="1" required>
                </td>
                <td>
                    <input type="text" name="note[]" class="form-control text-center note" placeholder="Optional note....">
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-danger btn-sm remove-row"><i class="fas fa-trash-alt"></i></button>
                </td>
            </tr>
            `;
            $('#items-table tbody').append(newRow);
            rowCount++;
        });

        // Remove row
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
        });

        // Initiate variable
        let selectedLocation; // ✅ Renamed

        // Listen for location change
        $(document).on("change", "#location", function() {
            selectedLocation = $(this).val();
        });

        // Initialize id variable
        let id;

        // Product search AJAX
        $(document).on("keyup", ".search", function() {
            let query = $(this).val();
            id = $(this).attr('id').replace("search", "");
            console.log(id);

            if (query === '') {
                $("#list" + id).hide();
                return;
            }

            $.ajax({
                url: "{{ route('get.location.product') }}",
                method: "get",
                data: {
                    query: query,
                    locationId: selectedLocation // ✅ use new variable
                },
                success: function(data) {
                    $("#results" + id).empty();
                    if (data.length === 0) {
                        $("#list" + id).show();
                        $("#results" + id).append(
                            '<li class="list-group-item text-center text-muted">No suggestions...</li>'
                        );

                        // Hide after 2 seconds
                        setTimeout(function() {
                            $("#list" + id).fadeOut("slow", function() {
                                $("#results" + id)
                                    .empty(); // Optional: clear the message
                            });
                        }, 2000);
                    } else {
                        $("#list" + id).show();
                        for (let i = 0; i < data.length; i++) {
                            $("#results" + id).append(`
                            <li class="list-group-item p-1">
                                <button type="button" id="${i}" class="btn btn-outline-secondary btn-block items">
                                    ${data[i].product} | ${data[i].stock?.[0]?.qty || 0} ${data[i].unit[0].name}
                                </button>
                            </li>
                        `);
                        }
                    }

                    // Select product
                    $(".items").on("click", function() {
                        let index1 = $(this).attr('id');
                        let product = data[index1];

                        // Populate hidden fields
                        $("#search" + id).val(product.product);
                        $("#id" + id).val(product.id);
                        $("#price" + id).val(product.unit[0].selling);
                        $("#cont" + id).val(product.unit[0].unit_cont);

                        // Console log the assigned values
                        console.log("Assigned Values:");
                        console.log("Product Name:", $("#search" + id).val());
                        console.log("Product ID:", $("#id" + id).val());
                        console.log("Price:", $("#price" + id).val());
                        console.log("Unit Count:", $("#cont" + id).val());

                        // ✅ Replace unit dropdown with product-specific units
                        $("#unit" + id).empty();
                        $.each(product.unit, function(index, val) {
                            let selected = index === 0 ? 'selected' : '';
                            $("#unit" + id).append(
                                `<option value="${val.id}" ${selected}>-- ${val.name} --</option>`
                            );
                        });

                        $("#list" + id).fadeOut("slow");
                    });
                }
            });
        });

        // Unit change AJAX
        $(document).on("change", ".unit", function() {
            let unitId = $(this).val();
            id = $(this).attr("id").replace("unit", "");
            let productId = $("#id" + id).val();

            $.ajax({
                url: "{{ route('unit.details') }}",
                method: "get",
                data: {
                    unitId: unitId,
                    productId: productId,
                    locationId: selectedLocation // ✅ use new variable
                },
                success: function(data) {
                    $("#cont" + id).val(data.unit_cont);
                    $("#price" + id).val(data.selling);
                }
            });
        });
    </script>
@endsection
@endsection
