@extends('layouts.master')

@section('content')
    <style>
        .invoice {
            padding: 3%;
        }

        .btn.status {
            border: none;
            border-radius: 20px;
            padding: 6px 20px;
            height: auto;
            font-size: 14px;
            color: white;
        }
    </style>

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5>Invoice</h5>
        </center>
    </div>

    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">
        <!-- Main content -->
        <div class="card">
            <div class="card-header">
                {{ $customer->name }}'s invoice
            </div>

            <div class="card-body">
                <div class="invoice">

                    <!-- title row -->
                    <div class="row">
                        <div class="col-12">
                            <h4>
                                <small class="float-left">
                                    From<br>
                                    <b>{{ $profile->name }}</b><br>
                                    <b>Address:</b> {{ $profile->address }}<br>
                                    <b>Phone:</b> {{ $profile->phone }}<br>
                                    @if ($profile->email)
                                    <b>Email:</b> {{ $profile->email }}<br>
                                    @else
                                    <b>Email:</b> N/A<br>
                                    @endif
                                    <b>Invoice #:</b> 000{{ $order->id }}
                                </small>

                                <small class="float-right">
                                    To<br>
                                    <b>Customer:</b> {{ $customer->name }}<br>
                                    <b>Address:</b> {{ $customer->address }}<br>
                                    <b>Phone:</b> {{ $customer->phone }}<br>
                                    @if ($customer->email)
                                    <b>Email:</b> {{ $customer->email }}<br>
                                    @endif
                                    @if ($order->due)
                                        <button class="btn btn-warning btn-block status">Pending</button>
                                    @else
                                        <button class="btn btn-success btn-block status">Cleared</button>
                                    @endif
                                </small>
                            </h4>
                        </div>
                        <!-- /.col -->
                    </div>

                    <!-- Table row -->
                    <div class="row">
                        <div class="col-12 table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Unit</th>
                                        <th>Price</th>
                                        <th>Qty</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($items as $item)
                                        <tr>
                                            <td>{{ $item->product ? $item->product->product : ($item->product()->withTrashed()->first() ? $item->product()->withTrashed()->first()->product : 'N/A') }}
                                            </td>
                                            <td>{{ $item->unit->name }}</td>
                                            <td>{{ number_format($item->price) }}</td>
                                            <td>{{ $item->qty }}</td>
                                            <td>{{ number_format($item->amount) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->

                    <div class="row">
                        <!-- accepted payments column -->
                        <div class="col-6">

                        </div>
                        <!-- /.col -->

                        <div class="col-6">
                            <p class="lead">Amount Due {{ number_format($order->due) }}</p>

                            <div class="table-responsive">
                                <table class="table">
                                    <tr>
                                        <th style="width:50%">Subtotal:</th>
                                        <td>Tsh {{ number_format($order->total) }}</td>
                                    </tr>

                                    <tr>
                                        <th>- Paid:</th>
                                        <td>Tsh {{ number_format($order->paid) }}</td>
                                    </tr>

                                    <tr>
                                        <th>Due Balance:</th>
                                        <td>Tsh {{ number_format($order->due) }}</td>
                                    </tr>

                                </table>
                            </div>
                        </div>
                        <!-- /.col -->

                    </div>
                    <!-- /.row -->
                </div>
            </div>

            <div class="card-footer">
                <!-- this row will not appear when printing -->
                <div class="row no-print">
                    <div class="col-12">
                        <a href="#" rel="noopener" target="_blank"
                            class="btn btn-default"><i class="fas fa-print"></i> Print</a>

                        <button type="button" class="btn btn-primary float-right" style="margin-right: 5px;">
                            <i class="fas fa-download"></i> Generate PDF
                        </button>
                    </div>
                </div>

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif
@endsection
@endsection
