<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Waiter POS</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome 6 CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <!-- Sweat Alert -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.min.css">

    <style>
        body {
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)),
                url('https://images.unsplash.com/photo-1565299624946-b28f40a0ae38') no-repeat center center fixed;
            background-size: cover;
            font-family: Arial, sans-serif;
            background-color: grey;
        }

        .grid-container {
            display: grid;
            grid-template-columns: auto auto auto;
            background-color: gray;
            padding: 10px;
            gap: 10px;
        }

        .grid-item {
            background-color: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(0, 0, 0, 0.8);
            padding: 20px;
            font-size: 15px;
            text-align: center;
            border-radius: 10px;
            transition: 0.2s;
        }

        .grid-item:hover {
            background-color: #f0f0f0;
            cursor: pointer;
            transform: scale(1.05);
        }
    </style>
</head>

<body class="bg-light">
    <div class="container-fluid py-4">
        <!-- Categories -->
        <div class="card mb-3 shadow-sm position-relative">
            <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                <strong>Categories</strong>

                <!-- Dropdown Menu -->
                <div class="dropdown">
                    <a href="#" class="text-white text-decoration-none position-relative" id="orderDropdown"
                        data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-bell fa-lg"></i>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger"
                            id="order-count">{{ $recentOrdersCount }}</span>
                    </a>

                    <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="orderDropdown"
                        style="width: 250px;">
                        <li class="dropdown-header">New Orders</li>

                        @forelse($recentOrders as $cart)
                            <li>
                                <button type="button" class="dropdown-item order-item btn btn-primary btn-sm"
                                    data-bs-toggle="modal" data-bs-target="#exampleModal{{ $cart->id }}">
                                    <h6><i class="fas fa-receipt me-2 text-primary"></i>
                                        Order #{{ $cart->id }} - Table {{ $cart->table_id }}</h6>
                                </button>
                            </li>
                        @empty
                            <li>
                                <span class="dropdown-item text-muted text-center">No new orders</span>
                            </li>
                        @endforelse

                        <li>
                            <hr class="dropdown-divider">
                        </li>

                        <li>
                            <a href="{{ route('qr.code.orders', ['waiterId' => $waiterId, 'password' => $password]) }}"
                                class="dropdown-item text-center text-primary fw-bold">View All Orders</a>
                        </li>
                    </ul>
                </div>

                @foreach ($recentOrders as $cart)
                    <div class="modal fade" id="exampleModal{{ $cart->id }}" tabindex="-1"
                        aria-labelledby="exampleModalLabel{{ $cart->id }}" aria-hidden="true">
                        <div class="modal-dialog modal-xl modal-dialog-centered">
                            <div class="modal-content border-0 shadow-lg glass-modal">
                                <!-- Modal Header -->
                                <div class="modal-header text-white border-0"
                                    style="background: linear-gradient(90deg, #0d6efd, #0b5ed7);">
                                    <h5 class="modal-title fw-bold d-flex align-items-center"
                                        id="exampleModalLabel{{ $cart->id }}">
                                        <i class="bi bi-receipt-cutoff me-2"></i>
                                        {{ $cart->table->name }} - Order #00{{ $cart->id }}
                                    </h5>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal Body -->
                                <div class="modal-body p-4">
                                    <div class="table-responsive">
                                        <table
                                            class="table table-hover table-bordered align-middle cart-table mb-0 text-center">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>Image</th>
                                                    <th>Product</th>
                                                    <th>Qty</th>
                                                    <th>Price</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $cartTotal = 0; @endphp
                                                @foreach ($cart->cartItems as $item)
                                                    @php $cartTotal += $item->total; @endphp
                                                    <tr>
                                                        <td>
                                                            <img src="{{ $item->image ?? 'https://via.placeholder.com/60' }}"
                                                                class="img-thumbnail rounded shadow-sm product-img"
                                                                style="width:60px;height:60px;object-fit:cover;">
                                                        </td>
                                                        <td class="fw-semibold">{{ $item->product_name }}</td>
                                                        <td>{{ $item->qty }}</td>
                                                        <td>{{ number_format($item->price, 2) }}</td>
                                                        <td class="fw-bold text-success">
                                                            {{ number_format($item->total, 2) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr class="fw-bold cart-total-row">
                                                    <td colspan="4" class="text-end fs-6">Order Total:</td>
                                                    <td class="text-success fs-6">{{ number_format($cartTotal, 2) }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="5"
                                                        class="text-center bg-warning bg-opacity-25 fst-italic">
                                                        <i class="bi bi-chat-dots me-1"></i>
                                                        {{ $cart->comment ?? 'No Comment...' }}
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>

                                <!-- Modal Footer -->
                                <div class="modal-footer border-0">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">
                                            <i class="bi bi-x-circle me-1"></i> Close
                                        </button>
                                        <a href="{{ route('mark.order.as.seen', $cart->id) }}"
                                            class="btn btn-success btn-sm">
                                            <i class="bi bi-eye me-1"></i> Mark as Seen.
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="card-body bg-transparent">
                <div class="btn-group flex-wrap" role="group">
                    @php
                        $colors = ['primary', 'info', 'secondary', 'dark', 'success', 'danger', 'warning'];
                    @endphp

                    @foreach ($categories as $index => $category)
                        @php $color = $colors[$index % count($colors)]; @endphp
                        <button type="button" class="btn btn-{{ $color }} mb-2 category btn-sm"
                            id="{{ $category->id }}">
                            <i class="fas fa-tag me-1"></i> {{ $category->name }}
                        </button>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- POS Form -->
        <form action="{{ route('store.bill') }}" method="post" class="card shadow-sm p-3">
            @csrf

            <div class="row">
                <!-- Left: Products -->
                <div class="col-md-5">
                    <input type="search" id="search" class="form-control mb-3 use-keyboard-input"
                        placeholder="Search by product name..">
                    <div class="grid-container"></div>
                </div>

                <!-- Right: Cart -->
                <div class="col">
                    <table class="table table-bordered table-hover align-middle text-center shadow-sm">
                        <thead class="table-dark">
                            <tr>
                                <th style="width: 20%">
                                    <i class="fas fa-box me-1"></i> Name
                                </th>
                                <th style="width: 10%">
                                    <i class="fas fa-balance-scale me-1"></i> Unit
                                </th>
                                <th style="width: 10%">
                                    <i class="fas fa-tags me-1"></i> Price
                                </th>
                                <th style="width: 15%">
                                    <i class="fas fa-sort-numeric-up me-1"></i> Qty
                                </th>
                                <th style="width: 10%">
                                    <i class="fas fa-dollar-sign me-1"></i> Amount
                                </th>
                                <th style="width: 15%">
                                    <i class="fas fa-cogs me-1"></i> Action
                                </th>
                            </tr>
                        </thead>

                        <tbody id="tbody">
                            <tr id="jumla" class="table-light fw-bold">
                                <td colspan="2">&nbsp;</td>
                                <td colspan="2">
                                    <input type="hidden" name="waiter" id="waiter" value="{{ $waiterId }}"
                                        class="form-control text-center" readonly>
                                </td>
                                <td>&nbsp;</td>
                                <td colspan="2">
                                    <input type="text" name="total" id="total"
                                        class="form-control text-center fw-bold bg-light" placeholder="Total"
                                        readonly>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5">&nbsp;</td>
                                <td colspan="2">
                                    <select name="table" id="table" class="form-control text-center" required>
                                        <option selected disabled value="">-- Table --</option>
                                        @foreach ($tables as $table)
                                            <option value="{{ $table->id }}">-- {{ $table->name }} --</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5">&nbsp;</td>
                                <td colspan="2">
                                    <button type="submit" class="btn btn-success w-100 shadow-sm">
                                        <i class="fa fa-paper-plane me-1"></i> Confirm
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>

        <!-- 🔉 Enable Sound -->
        {{-- <audio id="order-audio" src="{{ asset('sound/notification.mp3') }}" preload="auto"></audio>
        <button id="enable-sound" class="btn btn-sm btn-outline-primary mt-2">
            🔊 Enable Sound Notifications
        </button> --}}
    </div>

    <!-- Keyboard -->
    @include('patial.keyboard')

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- SweetAlert2  JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        // 🔹 Keep your entire jQuery code here
        $(document).ready(function() {
            let index = 0;
            let waiterId = $("#waiter").val();
            let categoryId = null;

            // Category click
            $(".category").on("click", function() {
                categoryId = $(this).attr("id");
                $("#category").val(categoryId);

                $.ajax({
                    url: "{{ route('get.menu.by.category') }}",
                    method: "get",
                    data: {
                        'categoryId': categoryId,
                        'waiterId': waiterId,
                    },
                    success: function(data) {
                        $(".grid-container").empty();
                        console.log(data);

                        let menus = data.menus;
                        let businessName = data.business_name;

                        $("#business-name").text(businessName);

                        // Append grid buttons
                        menus.forEach((menu, i) => {
                            let imageHtml = '';
                            if (menu.image) {
                                imageHtml =
                                    `<img height="70" width="105" style="object-fit: cover; border-radius: 10px;" src="{{ asset('storage/images') }}/${menu.image}" alt="Product Image"><br>`;
                            }

                            $(".grid-container").append(
                                `<button type="button" class="grid-item" data-index="${i}">${imageHtml}${menu.product}</button>`
                            );
                        });

                        // Store menus globally for delegated click
                        window.menus = menus;
                    }
                });
            });

            // Search input
            $("#search").on('input', function() {
                let query = $(this).val();

                $.ajax({
                    url: "{{ route('get.category.menu') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'categoryId': categoryId,
                        'waiterId': waiterId,
                    },
                    success: function(data) {
                        $(".grid-container").empty();
                        console.log(data);

                        let menus = data.menus;
                        let businessName = data.business_name;

                        $("#business-name").text(businessName);

                        menus.forEach((menu, i) => {
                            let imageHtml = '';
                            if (menu.image) {
                                imageHtml =
                                    `<img height="50" width="50" style="object-fit: cover; border-radius: 10px;" src="{{ asset('storage/images') }}/${menu.image}" alt="Product Image"><br>`;
                            }

                            $(".grid-container").append(
                                `<button type="button" class="grid-item" data-index="${i}">${imageHtml}${menu.product}</button>`
                            );
                        });

                        // Store menus globally for delegated click
                        window.menus = menus;
                    }
                });
            });

            // Barcode search (on change)
            $("#search").on('change', function() {
                let barcode = $(this).val();

                $.ajax({
                    url: "{{ route('get.product.by.barcode') }}",
                    method: "get",
                    data: {
                        'barcode': barcode,
                    },
                    success: function(response) {
                        $(".grid-container").empty();
                        console.log(response);

                        let menus = response.menus;
                        let businessName = response.business_name;

                        $("#business-name").text(businessName);

                        menus.forEach((menu, i) => {
                            let imageHtml = '';
                            if (menu.image) {
                                imageHtml =
                                    `<img height="70" width="105" style="object-fit: cover; border-radius: 10px;" src="{{ asset('storage/images') }}/${menu.image}" alt="Product Image"><br>`;
                            }

                            $(".grid-container").append(
                                `<button type="button" class="grid-item" data-index="${i}">${imageHtml}${menu.product}</button>`
                            );
                        });

                        window.menus = menus;
                    }
                });
            });

            // Delegated click handler for all grid items
            $(document).on("click", ".grid-item", function() {
                let i = $(this).data("index");
                let menu = menus[i];
                let productId = menu.id;
                let product = menu.product;
                let unit = menu.unit[0].unit.name;
                let price = Number(menu.unit[0].selling).toLocaleString();
                let locationId = menu.location_id;

                let tr = `
                                <tr id="tr${index}">
                                    <td>
                                        <input type="hidden" name="id[]" value="${productId}" id="id${index}" class="form-control id" readonly>
                                        <input type="hidden" name="product[]" value="${product}" id="id${index}" class="form-control product" readonly>
                                        <input type="hidden" name="location[]" value="${locationId}" id="location${index}" class="form-control" readonly>
                                        ${product}
                                    </td>
                                    <td><input type="text" name="unit[]" value="${unit}" id="unit${index}" class="form-control unit" readonly></td>
                                    <td><input type="text" name="price[]" value="${price}" id="price${index}" class="form-control price" readonly></td>
                                    <td style="display:flex">
                                        <button type="button" class="btn btn-warning decrement" id="${index}"><i class="fas fa-minus"></i></button>
                                        <input type="text" name="qty[]" value="1" id="qty${index}" class="form-control text-center qty" readonly required>
                                        <button type="button" class="btn btn-primary increment" id="increment${index}"><i class="fas fa-plus"></i></button>
                                    </td>
                                    <td><input type="text" name="amount[]" value="${price}" id="amount${index}" class="form-control amount" readonly></td>
                                    <td><button type="button" class="btn btn-danger removeRow" id="${index}"><i class="fas fa-trash-alt"></i></button></td>
                                </tr>
                            `;
                $("#jumla").before(tr);
                index++;
                total();
            });

            // Remove row function
            $(document).on("click", ".removeRow", function() {
                let id = $(this).attr("id");
                $("#tr" + id).remove();
                total();
            });

            // Increment QTY function
            $(document).on("click", ".increment", function() {
                let id = $(this).attr("id").replace("increment", "");
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            // Decrement QTY function
            $(document).on("click", ".decrement", function() {
                let id = $(this).attr("id").replace("decrement", "");
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());

                let priceInput = $("#price" + id);
                // Remove commas from the price input and convert it to a float
                let price = parseFloat(priceInput.val().replace(/,/g, ''));

                let amountInput = $("#amount" + id);
                let amount = qty * price;

                // Format the amount with commas
                amountInput.val(amount.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }));

                // Call the total function to update the total amount
                total();
            }

            function total() {
                let amount = 0;
                let grandtotal = 0;

                $(".amount").each(function() {
                    // Ensure the number is properly parsed
                    amount += Number($(this).val().replace(/,/g, ''));
                });

                // Format total with commas
                $("#total").val(amount.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }));
            }

            $("#table").on("change", function() {
                let table = $(this).val();
                // if (table != "") {
                //     $("#room").attr("required", false).fadeOut("slow");
                // } else {
                //     $("#room").attr("required", true).fadeIn("slow");
                // }
            });

            // $("#room").on("change", function() {
            //     let table = $(this).val();
            //     if (table != "") {
            //         $("#table").attr("required", false).fadeOut("slow");
            //     } else {
            //         $("#table").attr("required", true).fadeIn("slow");
            //     }
            // });

            document.querySelectorAll('.order-item').forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();

                    const orderId = this.getAttribute('data-order-id');
                    const table = this.getAttribute('data-table');

                    const orderDetailsText = `
                                            <p><strong>Order Number:</strong> #${orderId}</p>
                                            <p><strong>Table:</strong> ${table}</p>
                                            <p><strong>Items:</strong></p>
                                            <ul>
                                                <li>Pizza Margherita x 2</li>
                                                <li>Coke x 1</li>
                                                <li>Caesar Salad x 1</li>
                                            </ul>
                                            <p><strong>Status:</strong> Preparing</p>
                                            `;

                    document.getElementById('orderInfo').innerHTML = orderDetailsText;

                    const orderModal = new bootstrap.Modal(document.getElementById(
                        'orderDetailsModal'));
                    orderModal.show();
                });
            });

            // 🕓 Run immediately on page load
            checkForNewOrders();

            // 🔁 Then repeat every 10 seconds
            setInterval(checkForNewOrders, 10000);
        });

        // 🧠 Keep track of last cart snapshot
        let lastOrderSnapshot = {};

        function checkForNewOrders() {
            $.ajax({
                url: '/recent/orders',
                method: 'GET',
                success: function(response) {
                    const newOrders = response.orders || [];
                    const $orderCountEl = $('#order-count');

                    // 🔍 Build new snapshot based on cart ID and last activity timestamp
                    const newSnapshot = {};
                    newOrders.forEach(cart => {
                        newSnapshot[cart.id] = cart.last_activity_at;
                    });

                    // 🧠 Compare with previous snapshot to detect changes
                    const hasChanges = JSON.stringify(newSnapshot) !== JSON.stringify(lastOrderSnapshot);

                    if (hasChanges) {
                        // ✅ Save new snapshot
                        lastOrderSnapshot = newSnapshot;

                        // ✅ Update badge count
                        $orderCountEl.text(newOrders.length);

                        // ✅ Rebuild dropdown items
                        let newOrdersHtml = '';
                        newOrders.forEach(cart => {
                            newOrdersHtml += `
                            <li>
                                <button type="button" class="dropdown-item order-item btn btn-primary btn-sm"
                                    data-bs-toggle="modal" data-bs-target="#exampleModal${cart.id}">
                                    <h6><i class="fas fa-receipt me-2 text-primary"></i>
                                        Order #${cart.id} - Table ${cart.table_id}</h6>
                                </button>
                            </li>
                        `;

                            // 🔁 Load modal for each cart (if not already in DOM)
                            if ($(`#exampleModal${cart.id}`).length === 0) {
                                $.ajax({
                                    url: `/orders/${cart.id}/modal`,
                                    method: 'GET',
                                    success: function(modalHtml) {
                                        $('body').append(modalHtml);
                                    },
                                    error: function(xhr) {
                                        console.error(
                                            `Failed to load modal for Cart #${cart.id}`,
                                            xhr);
                                    }
                                });
                            }
                        });

                        // ✅ Replace dropdown items (excluding header/footer)
                        const $dropdownMenu = $('.dropdown-menu');
                        $dropdownMenu.find('li').slice(1, -2).remove(); // remove middle items
                        $dropdownMenu.find('hr.dropdown-divider').parent().before(newOrdersHtml);

                        // ✅ SweetAlert popup for operator feedback
                        const ordersListHtml = newOrders.map(cart =>
                            `<li>Order <b>#${cart.id}</b> – Table <b>${cart.table_id}</b></li>`
                        ).join('');

                        Swal.fire({
                            icon: 'info',
                            title: `🆕 ${newOrders.length} New Order${newOrders.length > 1 ? 's' : ''}`,
                            html: `<ul style="text-align: left;">${ordersListHtml}</ul>`,
                            position: 'top-end',
                            showConfirmButton: true,
                        });
                    }
                },
                error: function(xhr) {
                    console.error('Error fetching recent orders:', xhr);
                }
            });
        }
    </script>
</body>

</html>
