@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <h4>Passed pending purchases.</h3>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">
            <div class="card-header">

            </div>
            <div class="card-body">

                <table id="example1" class="table table-bordered table-striped" style="text-align: center;">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Supplier</th>
                            <th>Amount due</th>
                            <th>Due date</th>
                            <th>User</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($madeni as $deni)
                            <tr>
                                <td>{{ $deni->date }}</td>
                                <td>{{ $deni->supplier }}</td>
                                <td><a href="{{ route('fetch.puchases', $deni->id) }}">{{ $deni->due }}</a></td>
                                </td>
                                <td>{{ $deni->duedate }}</td>
                                <td>{{ $deni->user }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>
                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Total ({{ $totaldebt }})</th>
                            <th>Due date</th>
                            <th>User</th>
                        </tr>
                    </tfoot>

                </table>
            </div>
            <div class="card-footer">

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        });
    </script>
@endsection

@endsection
