@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <h5><strong>Pay bills</strong></h5>
        </div>

        <form action="{{ route('clear.bill') }}" onsubmit="showSpinner()" method="post" class="was-validated">
            @csrf

            <div class="card-body">

                <label for="date">Date</label>
                <input type="date" name="date" id="date" value="{{ date('Y-m-d') }}" class="form-control">

                <label for="area">Location</label>
                <select name="area" class="form-control" id="area" required>
                    <option disabled selected value="">-- Select Location --</option>
                    <option value="all">-- All --</option>
                    @foreach ($sellings as $selling)
                        <option value="{{ $selling->id }}">-- {{ $selling->location->name }} --</option>
                    @endforeach
                </select>

                <label for="table">Tables</label>
                <select name="table" class="form-control" id="table" required>
                    <option disabled selected value="">-- Select Table --</option>
                    <option value="all">-- All --</option>
                    @foreach ($tables as $table)
                        <option value="{{ $table->id }}">-- {{ $table->name }} --</option>
                    @endforeach
                </select>

                <label for="waiter">Waiters</label>
                <select name="waiter" class="form-control" id="waiter" required>
                    <option disabled selected value="">-- Select Waiter --</option>
                    <option value="all">-- All --</option>
                    <option value="0">-- QR Code --</option>
                    @foreach ($waiters as $waiter)
                        <option value="{{ $waiter->id }}">-- {{ $waiter->name }} --</option>
                    @endforeach
                </select>

                <label for="balance">Balance</label>
                <input type="text" name="balance" id="balance" class="form-control" placeholder="Total bill" readonly>

                <label for="paid">Paid amount</label>
                <input type="number" name="paid" id="paid" class="form-control use-keyboard-input"
                    placeholder="Enter amount paid" required>

                <label for="due">Due balance</label>
                <input type="text" name="due" id="due" class="form-control" placeholder="Due balance" readonly>

                <label for="account">Payment method</label>
                <select name="account" class="form-control" id="account" required>
                    <option disabled selected value="">-- Select Account --</option>
                    @foreach ($accounts as $account)
                        <option value="{{ $account->id }}">-- {{ $account->type }} - {{ $account->name }} --</option>
                    @endforeach
                </select>

                <br>

                <center>
                    <button type="submit" class="btn btn-sm btn-success shadow-sm"
                        style="font-size: 1.2rem; font-weight: 600; border-radius: 10px; padding: 10px 20px">
                        -- <i class="fas fa-print mr-2"></i>Pay bill --</button>
                </center>
            </div>
        </form>
    </div>

    @include('patial.keyboard')

@section('scripts')
    <script>
        // Declare variables
        let date = $("#date").val();
        let area = $("#area").val();
        let table = $("#table").val();
        let waiter = $("#waiter").val();

        // Common function to fetch bill
        function fetchBill() {
            // Get latest values
            date = $("#date").val();
            area = $("#area").val();
            table = $("#table").val();
            waiter = $("#waiter").val();

            if (date && area && table && waiter) {
                $.ajax({
                    url: "{{ route('get.bill') }}",
                    method: "get",
                    data: {
                        date: date,
                        sellingId: area,
                        tableId: table,
                        waiterId: waiter
                    },
                    success: function(response) {
                        $("#balance").val(response.length === 0 ? 0 : response);
                    }
                });
            }
        }

        // Attach change event to all relevant inputs
        $("#date, #area, #table, #waiter").on("change", fetchBill);

        $("#paid").on("input", function() {
            paid = $(this).val();
            balance = $("#balance").val();
            $("#due").val(balance - paid);
        });

        function showSpinner() {
            // Show spinner to be called on form submission
            document.querySelector('.spinner').style.display = 'block';
        }

        window.addEventListener('load', function() {
            // hide the spinner after the page is loaded
            document.querySelector('.spinner').style.display = 'none';
        });
    </script>
@endsection

@endsection
