@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5 class="text-black-50">Pending requisition</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">
            <div class="card-header">

                <button type="button" class="btn btn-danger" id="deleteall">Delete all</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".customer">Make new
                    requisition</button>

                <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">

                            <div class="card">

                                <div class="card-header">
                                New requisition..
                                </div>

                                <form action="{{ route('store.requisition') }}" method="get">
                                    @csrf

                                    <table>
                                        <tbody>
                                            <tr>
                                                <td><input type="date" name="date" value="{{ date('Y-m-d') }}"
                                                        class="form-control"></td>
                                                <td>
                                                    <select name="location" id="location" class="form-control"
                                                        style="text-align: center">
                                                        <option value="">--Choose location--</option>
                                                        @foreach (App\Models\Location::all() as $location)
                                                            <option value="{{ $location->name }}">{{ $location->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div class="card-body">
                                        <table class="table table-striped">

                                            <thead style="text-align: center">
                                                <th style="width: 2%">#</th>
                                                <th>Product</th>
                                                <th style="width: 15%">Unit</th>
                                                <th style="width: 15%">Qty</th>
                                                <th><button type="button" class="btn btn-info" id="addRow">+</button></th>
                                            </thead>

                                            <tbody id="tbody">

                                            </tbody>

                                        </table>

                                    </div>

                                    <div class="card-footer">

                                        <center>
                                            <button type="submit" class="btn btn-info">Post Requisition</button>
                                        </center>

                                    </div>

                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <div class="card-body">

                <table class="table table-stripped" id="customer">
                    <thead>

                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th style="width: 15%">Date</th>
                            <th>Location</th>
                            <th>Requisition #</th>
                            <th style="width: 15%">Status</th>
                            <th style="width: 15%">User</th>
                            <th>Action</th>
                        </tr>

                    </thead>

                    <tbody>

                        @php
                            $requisitions = App\Models\Requisition::where("status", "pending")->get();
                        @endphp
                        @foreach ($requisitions as $requisition)
                            <tr>
                                <td><input type="checkbox" class="selected" id="{{$requisition->id}}"></td>
                                <td>{{ $requisition->date }}</td>
                                <td>{{ $requisition->location }}</td>
                                <td>00{{ $requisition->id}}</td>
                                <td>{{ $requisition->status }}</td>
                                <td>{{ $requisition->user }}</td>
                                <td>

                                    {{-- view trigger model --}}
                                    <button type="button" class="btn btn-secondary" data-toggle="modal"
                                        data-target="#view-{{ $requisition->id }}">
                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="view-{{ $requisition->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                    <div class="card">

                                                        <div class="card-header">
                                                            Requested items from <b>{{$requisition->location}}</b> by <b>{{ $requisition->user}}</b>
                                                        </div>

                                                        <div class="card-body">

                                                            <table class="table table-striped" style="text-align: center">

                                                                <thead>
                                                                    <th style="width: 2%">#</th>
                                                                    <th>Product</th>
                                                                    <th style="width: 15%">Unit</th>
                                                                    <th style="width: 15%">Qty</th>
                                                                </thead>

                                                                <tbody>
                                                                    @php
                                                                        $items = App\Models\RequisitionItem::where("requisition_id", $requisition->id)->get();
                                                                    @endphp

                                                                    @foreach ( $items as $item )
                                                                    <tr>
                                                                        <td>{{ $loop->index++}}</td>
                                                                        <td>{{ $item->items}}</td>
                                                                        <td>{{ $item->unit}}</td>
                                                                        <td>{{ $item->qty}}</td>
                                                                    </tr>
                                                                    @endforeach
                                                                </tbody>

                                                            </table>

                                                            </div>
                                                    </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Deny trigger model --}}
                                    <button type="button" class="btn btn-danger" data-toggle="modal"
                                        data-target="#deny-{{ $requisition->id }}">
                                        <i class="fa fa-times" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="deny-{{ $requisition->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                            <form action="{{ route('deny.requisition', $requisition->id)}}" method="get">
                                                <div class="modal-body">
                                                <label for="reason">Deny reason</label>
                                                <input type="text" name="reason" id="reason" class="form-control" placeholder="Enter deny reason..">
                                                </div>

                                                <div class="modal-footer">
                                                        <input type="submit" value="Submit" class="btn btn-info">
                                                </div>

                                            </form>

                                            </div>
                                        </div>
                                    </div>

                                    {{-- Approve trigger model --}}
                                    <form action="{{ route('approve.requisition', $requisition->id)}}" method="get">
                                        <button type="submit" class="btn btn-success">  <i class="fa fa-check" aria-hidden="true"></i></button>
                                    </form>

                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                    <tfoot>
                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th style="width: 15%">Date</th>
                            <th>Location</th>
                            <th>Requisition #</th>
                            <th style="width: 15%">Status</th>
                            <th style="width: 15%">User</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $("#customer").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        var index = 1;
            var ajaxresults;

        // add row
        $("#addRow").on("click", function() {

            var tr =

                '<tr id="tr' + index + '">' +

                '<td>' + index + '</td>' +

                '<td>' +
                '<input type="text" name="item[]" id="item' + index +
                '" class="form-control item" placeholder="Enter Item..." style="text-align: center" required>' +
                '</td>' +

                '<td>' +
                '<select name="unit[]" id="unit'+index+'" class="form-control unit" style="text-align: center"required>' +
                    '<option>Unit</option>'+
                '@foreach(App\Models\Unit::all() as $unit)'+
                    '<option value="{{ $unit->name }}">{{ $unit->name }}</option>'+
                '@endforeach'+
                '</select>' +
                '</td>' +

                '<td>' +
                '<input type="number" name="qty[]" id="qty' + index +
                '" class="form-control qty" placeholder="Qty" style="text-align: center" required>' +
                '</td>' +

                '<td><button type="button" id="' + index +
                '" class="btn btn-danger removeRow">-</button></td>' +

                '</tr>';

            $("#tbody").append(tr);
            index++;

            $(".removeRow").on("click", function() {
                var id = $(this).attr("id");
                $("#tr" + id).remove();
            });

        });

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {
                alert("please select at least one items!!");
            } else {
                if (confirm("Are you sure..")) {
                    $.ajax({
                        url: "{{ route('requisitions.bulk.delete') }}",
                        method: "GET",
                        data: {
                            'ids': selected
                        },
                        success: function(data) {
                            window.location.reload(true);
                        }
                    });
                }

            }

        });
    </script>
@endsection

@endsection
