@extends('layouts.bar-layout')

@section('title', 'Place - Order')

@push('styles')
    <style>
        body {
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)),
                url('https://images.unsplash.com/photo-1565299624946-b28f40a0ae38') no-repeat center center fixed;
            background-size: cover;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: Arial, sans-serif;
        }

        .login-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border-radius: 15px;
            box-shadow: 0 0 25px rgba(0, 0, 0, 0.5);
            color: white;
            width: 100%;
            max-width: 400px;
            padding: 30px;
        }

        .login-card h4 {
            font-weight: 600;
        }

        .form-control {
            text-align: center;
            background-color: rgba(255, 255, 255, 0.8);
        }

        .btn-primary {
            background: #007bff;
            border: none;
        }

        .btn-primary:hover {
            background: #0056b3;
        }
    </style>
@endpush

@section('content')
    @php
        $user = Auth::user();
    @endphp

    {{-- @if ($user->hasRole('Admin')) --}}
        {{-- Back button for admin --}}
        <a href="{{ route('home') }}" class="btn btn-secondary position-absolute top-0 end-0 m-3">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    {{-- @else --}}
        {{-- Logout button for non-admins --}}
        {{-- <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
            class="btn btn-danger position-absolute top-0 end-0 m-3">
            <i class="fa fa-sign-out"></i> Logout
        </a>

        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    @endif --}}


    <div class="d-flex justify-content-center align-items-center vh-100">
        <div class="login-card">
            <h4 class="text-center mb-4">Waiter Login</h4>

            <form action="{{ route('validate.waiters.details') }}" method="get" class="was-validated">
                @csrf
                <div class="mb-3">
                    <label for="waiter" class="form-label">Select Waiter</label>
                    <select name="waiter" id="waiter" class="form-control text-center" required>
                        <option disabled selected value="">-- Select Waiter --</option>
                        @foreach ($waiters as $waiter)
                            <option value="{{ $waiter->id }}">-- {{ $waiter->name }} -- </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" id="password" name="password" class="form-control" placeholder="Enter Password"
                        required>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">
                        Next <i class="fa fa-arrow-right"></i>
                    </button>
                </div>
            </form>
        </div>
        <div class="d-flex justify-content-center align-items-center vh-100">

            @push('scripts')
                <script>
                    function showSuccess(event) {
                        event.preventDefault();
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: 'Order Placed.',
                            background: '#e6ffed',
                            showConfirmButton: false,
                            timer: 2500,
                            timerProgressBar: true,
                            position: 'top-end',
                            toast: true
                        });
                    }
                </script>
            @endpush
        @endsection
