@extends('layouts.master')

@section('content')


    <div class="card">
        <div class="card-header">
            Post Expense
        </div>

        <div class="card-body table-responsive">
            <form action="{{ route('post.expense.store') }}" onsubmit="showSpinner()" method="post" class="was-validated">
                @csrf

                <div class="table-responsive">
                    <table class="table table-bordered table-hover shadow-sm align-middle" id="table"
                        style="background: #fff;">
                        <thead class="table-dark">
                            <tr>
                                <th colspan="5" class="p-3">
                                    <div class="row g-2 align-items-center">
                                        <div class="col-auto">
                                            <label for="date" class="form-label mb-0 fw-bold">Date:</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="date" name="date" id="date" value="{{ date('Y-m-d') }}"
                                                class="form-control" style="max-width: 180px;">
                                        </div>
                                        <div class="col-auto">
                                            <label for="location" class="form-label mb-0 fw-bold">Location:</label>
                                        </div>
                                        <div class="col">
                                            @if ($sellingCount > 1)
                                                <select name="location" id="location" class="form-control text-center"
                                                    style="max-width: 250px;" required>
                                                    <option disabled selected>-- Choose Location --</option>
                                                    @foreach ($sellings as $selling)
                                                        <option value="{{ $selling->id }}">--
                                                            {{ $selling->location->name }} --</option>
                                                    @endforeach
                                                </select>
                                            @else
                                                <input type="hidden" name="location" id="location"
                                                    value="{{ $sellings[0]->id }}">
                                                <input type="text" name="area-copy" id="area-copy" class="form-control"
                                                    value="{{ $sellings[0]->location->name }}" style="max-width: 250px;"
                                                    readonly>
                                            @endif
                                        </div>
                                    </div>
                                </th>
                            </tr>
                            <tr class="text-center align-middle">
                                <th style="width:25%"><i class="fas fa-list-alt"></i> Expense Category</th>
                                <th style="width:25%"><i class="fas fa-align-left"></i> Description</th>
                                <th style="width:15%"><i class="fas fa-money-bill-wave"></i> Amount</th>
                                <th style="width:25%"><i class="fas fa-university"></i> Account</th>
                                <th style="width:10%">
                                    <button type="button" class="btn btn-success btn-sm" id="addRow" title="Add Row">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr id="amount" class="bg-light">
                                <td></td>
                                <td></td>
                                <td colspan="3">
                                    <div class="input-group">
                                        <span class="input-group-text fw-bold">Total</span>
                                        <input type="text" readonly name="total" id="total" value="0"
                                            class="form-control text-end fw-bold" style="background: #f8f9fa;">
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td colspan="3">
                                    <button id="submit" class="btn btn-primary w-100 fw-bold">
                                        <i class="fas fa-paper-plane"></i> Post Expense
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            let location;
            let sellingCount = {{ $sellingCount }}; // Access the PHP variable in JavaScript

            if (sellingCount > 1) { // If there are multiple selling locations
                $("#location").on("change", function() {
                    location = $(this).val();
                    locationAccounts(location); // Call locationAccount function
                });
            } else { // If there's one selling one selling location
                location = $("#location").val();
                locationAccounts(location); // Call locationAccount function
            }

            function locationAccounts(location) {
                $.ajax({
                    url: "{{ route('get.location.accounts') }}",
                    method: "get",
                    data: {
                        'sellingId': location
                    },
                    success: function(response) {
                        var selectElement = $('#account');
                        // Clear any existing options
                        selectElement.empty();
                        // Add the default option if needed
                        selectElement.append(
                            '<option disabled selected value="">-- Account --</option>');
                        // Iterate over the response data and add options
                        $.each(response, function(index, item) {
                            selectElement.append('<option value="' + item.id +
                                '">-- ' +
                                item.type + ' - ' + item.name + ' --</option>');
                        });
                    }
                });
            }

            let index = 1;

            // add row
            $("#addRow").click(function() {

                let tr = `
                    <tr id="tr${index}">
                        <td>
                            <select name="cat[]" class="form-control cat" id="${index}" style="text-align: center;" required>
                                <option disabled selected value="">-- Category --</option>
                                @foreach (App\Models\ExpenseCategory::all() as $cat)
                                    <option value="{{ $cat->id }}">-- {{ $cat->name }} --</option>
                                @endforeach
                            </select>
                        </td>

                        <td>
                            <input type="text" name="desc[]" id="${index}" class="form-control desc" required>
                        </td>

                        <td>
                            <input type="number" name="sum[]" id="${index}" class="form-control sum" required>
                        </td>

                        <td>
                            <select name="account[]" class="form-control account" id="${index}" style="text-align: center;" required>
                                <option disabled selected value="">-- Account --</option>
                                @foreach ($accounts as $account)
                                    <option value="{{ $account->id }}">-- {{ $account->type }} - {{ $account->selling->location->name }} --</option>
                                @endforeach
                            </select>
                        </td>

                        <td>
                            <button type="button" id="${index}" class="btn btn-danger removeRow">
                                <i class="fa fa-trash-alt"></i>
                            </button>
                        </td>
                    </tr>
                `;

                $("#amount").before(tr);
                total();
                index++;

                $(".removeRow").on("click", function() {
                    let id = $(this).attr("id");
                    $(`#tr${id}`).remove();
                    total();
                });
            });

            function total() {
                $(".sum").keyup(function() {
                    let sum = 0;
                    $(".sum").each(function() {
                        sum += Number($(this).val());
                        $("#total").val(sum);
                    })
                });
            }

            $("#account").on("change", function() {
                let account = $(this).val();
                let total = $("#total").val();

                $.ajax({
                    url: "{{ route('get.account.balance') }}",
                    method: "get",
                    data: {
                        'account': account,
                    },
                    success: function(data) {
                        console.log(data);
                        if (total > data.balance) {
                            alert(account + " has insuficient fund " + (
                                data.balance));
                            $("#submit").fadeOut("slow");

                        } else {
                            $("#submit").fadeIn("slow");
                        }
                    }
                });
            });
        });
    </script>
@endsection

@endsection
