<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12.5px;
            text-transform: uppercase;
            border-top: 1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:nth-child(2),
        .items tbody tr td:nth-child(2) {
            width: 70%;
            min-width: 70%;
            max-width: 70%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 10px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }

        .total {
            font-size: 10px;
            border-top: 1px dashed black !important;
            border-bottom: 1px dashed black !important;
        }

        .total.text,
        .total.price {
            text-align: right;
        }

        .line {
            border-top: 1px solid black !important;
        }

        .heading .sn {
            width: 5%;
        }

        .heading.rate {
            width: 15%;
        }

        p {
            padding: 1px;
            margin: 0;
        }

        section,
        footer {
            font-size: 12px;
        }
    </style>
</head>

<body id="body">
    <header>
        <div id="logo" class="media" data-src="logo.png" src="./logo.png"></div>
    </header>
    <table class="bill-details">
        <tbody>
            <tr style="text-align: center;">
                <td><span class="receipt">{{ $profileData->name }}</span><br>
                    <span>Waiter: {{ $waiterData->name }}</span><br>
                    <span>Table: {{ $tableData->name }}</span><br>
                    <span>{{ $dateTime }}</span><br>
                    <span class="receipt">Customer Bill</span><br>
                    <span class="receipt">Order No: 00{{ $orderNumber }}</span>
                </td>
            </tr>
        </tbody>
    </table>

    <table class="items">
        <thead>
            <tr>
                <th class="heading sn">SN</th>
                <th class="heading name">Item</th>
                <th class="heading sn">Qty</th>
                <th class="heading rate" style="text-align: left;">Price</th>
                <th class="heading rate" style="text-align: left;">Amount</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($orderArray['id'] as $key => $id)
                <tr>
                    <td style="text-align: center;">{{ $key + 1 }}</td>
                    <td>{{ $orderArray['product'][$key] }}</td>
                    <td style="text-align: center;">{{ $orderArray['qty'][$key] }}{{ $orderArray['unit'][$key] }}
                    </td>
                    <td style="text-align: left;">{{ number_format($orderArray['price'][$key]) }}</td>
                    <td style="text-align: left;">{{ number_format($orderArray['amount'][$key]) }}</td>
                </tr>
            @endforeach

            <tr>
                <th colspan="4" class="total text" style="text-align: right;">Total</th>
                <th class="total price" style="text-align: left;white-space: nowrap;">
                    {{ number_format($orderTotal) }}</th>
            </tr>
        </tbody>
    </table>
    <section>
        <p style="text-align:center">
        {{-- <h3> Original Reciept</h3> --}}
        </p>
    </section>
    <footer style="text-align:center">
        <p>Powered by Dukamax Business Software</p>
    </footer>

    <script>
        window.print();
        // JavaScript code
        var statusCheck = '<?php echo $status; ?>';
        var roleCheck = '<?php echo addslashes($role); ?>';
        console.log(statusCheck, roleCheck);

        document.getElementById("body").addEventListener("click", function() {
            if (statusCheck === "end" && roleCheck === "Counter") {
                window.location.href = "{{ route('order') }}";
            } else if (statusCheck === "end" && roleCheck !== "Counter") {
                window.location.href = "{{ route('place.oder.index', $status) }}";
            } else if (statusCheck === "split") {
                window.location.href = "{{ route('waiters.bill.view') }}";
            }
        });
    </script>

</body>

</html>
