@extends('layouts.master')

@section('content')
    <style>
        /* General Invoice Styles */
        .invoice-box {
            max-width: 900px;
            margin: 10px auto;
            padding: 40px;
            border: 1px solid #eee;
            border-radius: 12px;
            background: #fff;
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 16px;
            color: #555;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.08);
        }

        /* Header */
        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(90deg, #337ab7 0%, #5bc0de 100%);
            color: white;
            padding: 30px 40px;
            border-radius: 10px;
            margin-bottom: 10px;
        }

        .invoice-header h1 {
            font-size: 36px;
            margin: 0;
        }

        .invoice-summary p {
            margin: 4px 0;
        }

        .invoice-summary h4 {
            margin-top: 10px;
        }

        /* Addresses */
        .invoice-address {
            background: #f9f9f9;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(51, 122, 183, 0.07);
            margin-bottom: 10px;
        }

        .invoice-address strong {
            font-size: 18px;
            color: #337ab7;
            letter-spacing: 1px;
        }

        /* Table */
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 18px rgba(51, 122, 183, 0.08);
            table-layout: fixed;
        }

        .invoice-table th {
            background: linear-gradient(90deg, #337ab7 0%, #5bc0de 100%);
            color: #fff;
            text-align: center;
            padding: 14px;
            font-size: 16px;
            white-space: nowrap;
        }

        .invoice-table td {
            padding: 14px;
            text-align: center;
            border-bottom: 1px solid #eee;
            white-space: nowrap;
            font-size: 14px;
            /* reduced font size */
        }

        .invoice-table tr:nth-child(even) {
            background: #f4f8fb;
        }

        /* Column widths */
        .invoice-table th:nth-child(1) {
            width: 5%;
        }

        .invoice-table th:nth-child(2) {
            width: 45%;
        }

        .invoice-table th:nth-child(3) {
            width: 15%;
        }

        .invoice-table th:nth-child(4) {
            width: 15%;
        }

        .invoice-table th:nth-child(5) {
            width: 20%;
        }

        /* Totals */
        .total-section {
            margin-top: 10px;
            text-align: right;
            background: linear-gradient(90deg, #337ab7 0%, #5bc0de 100%);
            color: #fff;
            padding: 20px 30px;
            border-radius: 10px;
            font-size: 20px;
            font-weight: bold;
        }

        /* Signature */
        .signature {
            margin-top: 50px;
            text-align: right;
        }

        .signature span {
            display: inline-block;
            border-bottom: 2px solid #337ab7;
            padding-bottom: 6px;
            font-family: 'Brush Script MT', cursive;
            font-size: 32px;
            color: #337ab7;
        }

        /* Print Styles */
        @media print {
            body * {
                visibility: visible;
            }

            .invoice-box {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }

            .btn-group {
                display: none;
            }

            /* Keep all sections intact */
            .invoice-header,
            .invoice-address {
                page-break-inside: avoid;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
                /* keep header/address intact */
            }

            .invoice-table {
                page-break-inside: auto;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
                /* allow table rows to split across pages */
            }

            .total-section,
            .signature {
                page-break-inside: avoid;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
                /* keep totals/signature intact */
            }
        }

        /* Force 3 columns to stay in one row */
        .row {
            display: flex !important;
            flex-wrap: nowrap !important;
        }

        .invoice-address {
            flex: 1 1 50% !important;
            /* change from 33.33% to 50% */
            max-width: 50% !important;
            box-sizing: border-box;
        }

        .invoice-address p {
            margin: 1px 0;
            /* reduce top & bottom spacing */
        }

        .hide-on-print {
            display: none !important;
        }
        }
    </style>

    <div class="invoice-box">
        {{-- Header --}}
        <div class="invoice-header">
            <div>
                <img src="{{ asset('storage/logos/' . $profileData->logo) }}" alt="Company Logo" style="height:80px;">
                <h4>PROFORMA INVOICE</h4>
            </div>
            <div class="invoice-summary">
                <p><strong>Invoice #:</strong> 000{{ $profoma->id }}</p>
                <p><strong>Date:</strong> {{ $profoma->created_at }}</p>
                <h4>Total: TZS {{ number_format($profoma->total, 2) }}</h4>
            </div>
        </div>

        {{-- Addresses --}}
        <div class="row">
            <div class="col-md-6 invoice-address">
                <strong>SENT BY</strong>
                <hr>
                <p>{{ $profileData->selling->location->name }}</p>
                <p>{{ $profileData->address ?? 'Unknown' }}</p>
                <p>{{ $profoma->phone }}</p>
            </div>
            <div class="col-md-6 invoice-address">
                <strong>SENT TO</strong>
                <hr>
                <p>{{ $profoma->customer->name }}</p>
                <p>{{ $profoma->customer->address }}</p>
                <p>{{ $profoma->customer->phone }}</p>
            </div>
        </div>

        {{-- Items Table --}}
        <table class="invoice-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Description</th>
                    <th>Unit Price</th>
                    <th>Qty</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($profoma->profomaItems as $index => $item)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td class="text-left">{{ $item->product->product }}</td>
                        <td class="text-right">TZS {{ number_format($item->price, 2) }}</td>
                        <td>{{ $item->qty }} {{ $item->unit->name }}</td>
                        <td>TZS {{ number_format($item->price * $item->qty, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{-- Totals --}}
        <div class="total-section">
            TOTAL: TZS {{ number_format($profoma->total, 2) }}
        </div>

        {{-- Signature --}}
        <div class="signature">
            <span>{{ $profileData->selling->location->name }}</span>
            <div style="font-size:14px; color:#888;">Served by: {{ Auth::user()->name }}</div>
        </div>

        {{-- Buttons --}}
        <center style="margin-top: 30px;">
            <div class="btn-group">
                <button class="btn btn-primary" onclick="window.print()"><i class="fa fa-print"></i> Print</button>
                <a href="{{ route('profoma.invoice.view') }}" class="btn btn-secondary"><i class="fa fa-arrow-left"></i>
                    Back</a>
            </div>
        </center>
    </div>
@endsection
