@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            @if ($flag == 1)
                Order progess..
            @else
                Past due date order(s).
            @endif

        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped table-hover" style="text-align: center" id="orders">
                    <thead class="table-dark">
                        <tr>
                            <th style="width:1%">#</th>
                            <th>Customer</th>
                            <th>Expectaion</th>
                            <th style="width: 20%">Stage</th>
                            <th>Progess</th>
                            <th style="width:25%">Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($orders as $order)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $order->customer ? $order->customer->name : 'LMT Textile' }}</td>
                                <td>{{ $order->expectation }}</td>
                                <td>
                                    @if ($order->stage == 1)
                                        <span class="badge bg-danger" style="border-radius: 20px;"
                                            id="{{ $order->id }}">Knitting...</span>
                                    @elseif ($order->stage == 2)
                                        <span class="badge bg-warning text-dark" style="border-radius: 20px;"
                                            id="{{ $order->id }}">Cutting...</span>
                                    @elseif ($order->stage == 3)
                                        <span class="badge bg-secondary" style="border-radius: 20px;"
                                            id="{{ $order->id }}">Joining...</span>
                                    @elseif ($order->stage == 4)
                                        <span class="badge bg-primary" style="border-radius: 20px;"
                                            id="{{ $order->id }}">Ironing...</span>
                                    @elseif ($order->stage == 5)
                                        <span class="badge bg-info text-dark" style="border-radius: 20px;"
                                            id="{{ $order->id }}">Embroidering...</span>
                                    @elseif ($order->stage == 6)
                                        <span class="badge bg-success" style="border-radius: 20px;"
                                            id="{{ $order->id }}">Packaging...</span>
                                    @endif
                                </td>
                                <td>
                                    <!-- Calculate the progress for each order and display it -->
                                    <?php
                                    $progress = 0;
                                    if ($order->stage > 1) {
                                        $progress = (($order->stage - 1) / 6) * 100;
                                    }
                                    ?>

                                    <div class="progress" style="margin-top: 5px">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="{{ $progress }}"
                                            aria-valuemin="0" aria-valuemax="100" style="width: {{ $progress }}%">
                                            {{ number_format($progress, 2) }}%
                                        </div>
                                    </div>
                                </td>

                                <td>
                                    <div class="btn-group" role="group">
                                        {{-- Rewind Modal --}}
                                        <button class="btn btn-warning btn-sm rewind" id="{{ $order->id }}">
                                            <i class="fa fa-backward" aria-hidden="true"></i> Back
                                            <form
                                                action="{{ route('process.order', ['order_id' => $order->id, 'stage' => 1]) }}"
                                                method="GET" id="rewind-form{{ $order->id }}">
                                            </form>
                                        </button>

                                        {{-- Forward Modal --}}
                                        <button class="btn btn-info btn-sm forward" id="{{ $order->id }}"
                                            stage="{{ $order->stage }}" genre="{{ $order->genre }}">
                                            <i class="fa fa-forward" aria-hidden="true"></i> Next
                                            <form
                                                action="{{ route('process.order', ['order_id' => $order->id, 'stage' => 2]) }}"
                                                method="GET" id="forward-form{{ $order->id }}">
                                            </form>
                                        </button>

                                        {{-- Locations modal --}}
                                        <div class="modal fade" id="locationModal" tabindex="-1" role="dialog"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Select Location</h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <form
                                                        action="{{ route('process.stock.order', ['orderId' => $order->id]) }}"
                                                        method="GET" id="location-form{{ $order->id }}"
                                                        class="was-validated">

                                                        <div class="modal-body">
                                                            <!-- Your select field for locations goes here -->
                                                            <select name="area" class="form-control" id="locationSelect" required>
                                                                <option selected disabled value="">-- Select Location --
                                                                </option>
                                                                @foreach ($sellings as $selling)
                                                                    <option value="{{ $selling->location_id }}">
                                                                       -- {{ $selling->location->name }} --
                                                                    </option>
                                                                @endforeach
                                                                <!-- Add more options as needed -->
                                                            </select>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-primary btn-sm location-button"
                                                                id="{{ $order->id }}"
                                                                data-dismiss="modal"><i class="fa fa-paper-plane"></i> Confirm</button>
                                                            <!-- Add a button for further actions if needed -->
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- View Modal --}}
                                        <button type="button" class="btn btn-secondary btn-sm" data-toggle="modal"
                                            data-target="#view{{ $order->id }}">
                                            <i class="fa fa-eye" aria-hidden="true"></i> View
                                        </button>

                                        <div class="modal fade" id="view{{ $order->id }}" tabindex="-1" role="dialog"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl" role="document">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">
                                                            {{ $order->customer ? $order->customer->name : 'LMT Textile' }}'s
                                                            Order</h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <div class="table-responsive">
                                                            <table class="table table-bordered table-hover">
                                                                <thead class="thead-dark">
                                                                    <tr>
                                                                        <th class="text-center">#</th>
                                                                        <th class="text-center">Product Name</th>
                                                                        <th class="text-center">Unit</th>
                                                                        <th class="text-center">Size</th>
                                                                        <th class="text-center">Color</th>
                                                                        <th class="text-center">Main Design</th>
                                                                        <th class="text-center">Sub Design</th>
                                                                        <th class="text-center">QTY</th>
                                                                        <th class="text-center">Price</th>
                                                                        <th class="text-center">Amount</th>
                                                                    </tr>
                                                                </thead>

                                                                <tbody>
                                                                    @foreach ($order->items as $item)
                                                                        <tr>
                                                                            <td class="text-center">{{ $loop->iteration }}
                                                                            </td>
                                                                            <td>{{ $item->product->product }}</td>
                                                                            <td class="text-center">
                                                                                {{ $item->unit->name }}
                                                                            </td>
                                                                            <td class="text-center">{{ $item->size }}
                                                                            </td>
                                                                            <td class="text-center">{{ $item->color }}
                                                                            </td>
                                                                            <td class="text-center">{{ $item->main }}
                                                                            </td>
                                                                            <td class="text-center">{{ $item->sub }}
                                                                            </td>
                                                                            <td class="text-center">
                                                                                {{ number_format($item->qty) }}</td>
                                                                            <td class="text-center">
                                                                                {{ number_format($item->price) }}</td>
                                                                            <td class="text-center">
                                                                                {{ number_format($item->price * $item->qty) }}
                                                                            </td>
                                                                        </tr>
                                                                    @endforeach

                                                                    <tr class="font-weight-bold">
                                                                        <td colspan="8" class="text-right">Total</td>
                                                                        <td colspan="2" class="text-center">
                                                                            {{ number_format($order->total) }}</td>
                                                                    </tr>

                                                                    <tr class="font-weight-bold">
                                                                        <td colspan="8" class="text-right">Paid</td>
                                                                        <td colspan="2" class="text-center">
                                                                            {{ number_format($order->paid) }}</td>
                                                                    </tr>

                                                                    <tr class="font-weight-bold">
                                                                        <td colspan="8" class="text-right text-danger">
                                                                            Due
                                                                        </td>
                                                                        <td colspan="2"
                                                                            class="text-center text-danger">
                                                                            {{ number_format($order->due) }}</td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                        {{-- Cancel Modal --}}
                                        <button class="btn btn-danger btn-sm cancel" id="{{ $order->id }}">
                                            <i class="fa fa-trash-alt" aria-hidden="true"></i> Delete
                                            <form action="{{ route('cancel.production.order', $order->id) }}"
                                                method="GET" id="cancel-form{{ $order->id }}">
                                            </form>
                                        </button>

                                        {{-- Postpond Modal --}}
                                        @if ($flag == 2)
                                            <button type="button" class="btn btn-success btn-sm postpond"
                                                data-toggle="modal" data-target="#postpond{{ $order->id }}">
                                                <i class="fa fa-calendar-days" aria-hidden="true"></i>
                                            </button>

                                            <div class="modal fade" id="postpond{{ $order->id }}" tabindex="-1"
                                                role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">

                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">
                                                                {{ $order->customer ? $order->customer->name : 'LMT Textile' }}'s
                                                                Order</h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>

                                                        <form
                                                            action="{{ route('postpond.order', ['order_id' => $order->id]) }}"
                                                            onsubmit="showSpinner()" method="GET"
                                                            id="postpond-form{{ $order->id }}">

                                                            @csrf

                                                            <div class="modal-body">
                                                                <input type="date" name="date"
                                                                    style="text-align: center" class="form-control">
                                                            </div>

                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-success"><i
                                                                        class="fa fa-paper-plane"></i> Postpond</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $("#orders").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        // document.addEventListener("DOMContentLoaded", function() {
        //     var progressBars = document.querySelectorAll('.progress-bar');
        //     progressBars.forEach(function(progressBar) {
        //         var maxProgress = parseInt(progressBar.getAttribute('aria-valuemax'));
        //         var width = 0;
        //         var interval = setInterval(function() {
        //             if (width >= maxProgress) {
        //                 clearInterval(interval);
        //             } else {
        //                 width++;
        //                 progressBar.style.width = width + '%';
        //                 progressBar.setAttribute('aria-valuenow', width);
        //                 progressBar.textContent = width +
        //                     '%'; // Update the text content with current progress
        //             }
        //         }, 10);
        //     });
        // });


        // Handle forward button click
        $(".forward").on("click", function() {
            var id = $(this).attr("id");

            // Get the order's stage and genre from data attributes
            var stage = $(this).attr('stage');
            var genre = $(this).attr('genre');

            // Check if the stage is 6 and genre is 2
            if (stage == 6 && genre == 2) {
                // Show the modal with locations select field
                $('#locationModal').modal('show');
            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "you want to progess..?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, forward!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        showSpinner()
                        document.getElementById("forward-form" + id).submit();
                    }
                })
            }

        });

        // Handle location button click
        $(".location-button").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "you want to progess..?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, forward!'
            }).then((result) => {
                if (result.isConfirmed) {
                    showSpinner()
                    document.getElementById("location-form" + id).submit();
                }
            })
        });

        // Handle rewinding button click
        $(".rewind").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "Confirm reverting this order one stage..?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, forward!'
            }).then((result) => {
                if (result.isConfirmed) {
                    showSpinner()
                    document.getElementById("rewind-form" + id).submit();
                }
            })
        });

        // Handle cancel button click
        $(".cancel").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, forward!'
            }).then((result) => {
                if (result.isConfirmed) {
                    showSpinner()
                    document.getElementById("cancel-form" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
