@extends('layouts.master')

@section('content')

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5 class="text-black-50">Profoma invoice</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">
        @php
            $profiles = App\Models\BusinessProfile::all();
            $profoma = App\Models\ProfomaInvoice::find($profomaid);
            $customer = App\Models\Customer::where('name', $profoma->customer)->first();
            $items = App\Models\ProfomaInvoiceItems::where('profoma_id', $profomaid)
                ->orderBy('product', 'asc')
                ->get();
            $subtotal = App\Models\ProfomaInvoiceItems::where('profoma_id', $profomaid)->sum('amount');
        @endphp

        <style>
           #total{
            text-align: right;
            padding-right: 105px;
            padding-top: 30px;
           }
            table, th, tbody{
            border:solid;
            border-collapse: collapse;
            }

            #head-div1 {

            }

            #head-div2 {
                text-align: right;
            }

            #div1 {
                padding-top: 2%;
            }

            #div2 {
                text-align: center;
                font-family: initial;
            }

            #div3 {
                text-align: right;
                padding-top: 2%;
                padding-right: 2%;
            }

            #customer-div {
                border: solid;
                margin-right: 50%;
                padding: 1%;
            }

            #profoma {
                text-align: right;
                padding: 1%;
            }

            #profoma-div {
                border: solid;
                text-align: right;
                padding: 1%;
            }

            #bottom-div1 {
                border: solid;
                text-align: center;
                padding: 1%;
            }

            #bottom-div2 {
                border: solid;
                padding: 1%;
            }

            #slogan {
                text-align: center;
            }

            .image {
                width: 100px;
                height: 70px;
            }
        </style>

        <div id="printarea">

            <div class="container">
                <div class="row">
                    <div class="col" id="head-div1">

                    </div>
                    <div class="col" id="head-div2">
                        <button class="btn btn-info" id="print">Print this profoma</button>
                    </div>
                </div>
            </div>
            <hr><br>
            <div class="container">
                <div class="row">
                    <div class="col" id="div1">
                        <img src="{{ asset('dist/img/logo.ico') }}" alt="DukaMax Logo" class="image">
                    </div>

                    <div class="col" id="div2">
                        @foreach ($profiles as $profile)
                            <h4> {{ $profile->name }} </h4>
                            <h5> {{ $profile->address }} </h5>
                            <h6>Mobile: {{ $profile->phone }} </h6>
                            @if ($profile->email)
                                <h6>Emial: {{ $profile->email }} </h6>
                            @endif
                        @endforeach
                    </div>

                    <div class="col" id="div3">
                        <img src="{{ asset('dist/img/logo.ico') }}" alt="DukaMax Logo" class="image">
                    </div>

                </div>
            </div>

            <br>

            <div class="container">
                <div class="col">
                    <div class="div" id="profoma">
                        <h3>PROFOMA INVOICE</h3>
                    </div>
                </div>
            </div>

            <div class="container">
                <div class="row">
                    <div class="col" id="customer-div">
                      <b>To:</b> {{ $customer->name }} <br>
                        {{ $customer->address }} <br>
                        {{ $customer->phone }} <br>
                        @if ($customer->tin)
                            {{ $customer->tin }} <br>
                        @endif
                        @if ($customer->vrn)
                            {{ $customer->vrn }} <br>
                        @endif
                    </div>

                    <div class="col" id="profoma-div">
                        Profoma #: 00{{ $profoma->id }} <br>
                        Isued date: {{ $profoma->date }} <br>
                    </div>

                </div>
            </div>

            <div class="container">
                <div class="row">
                    <div class="col">
                        <table class="table table-stripped">
                            <thead>
                                <tr>
                                    <th>Items</th>
                                    <th style="width: 10%">Qty</th>
                                    <th style="width: 10%">U/M</th>
                                    <th style="width:20%">Rate</th>
                                    <th style="width: 15%">Amount</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($items as $item)
                                @php
                                    $sum = 0;
                                    $sum += $item->amount;
                                @endphp
                                    <tr>
                                        <td>{{ $item->product }}</td>
                                        <td>{{ $item->qty }}</td>
                                        <td>{{ $item->unit }}</td>
                                        <td>{{ $item->price }}</td>
                                        <td>{{ $item->amount }}</td>
                                    </tr>
                                @endforeach

                            </tbody>
                            <tfoot>
                                <th colspan="3">
                                        We would like to officailly welcome you...We value your support and contribution to
                                        our
                                        business and we trust that your expireence to our business will bring you the utmost
                                        satisfaction.
                                </th>

                                <th colspan="2" id="total">
                                    <h5>Total 15000</h5>
                                </th>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <br>

            <div class="container">
                <div class="row">
                    <div class="col">
                      <b> Printed by:................................. </b>
                    </div>
                </div>
            </div>

            <br>
            <div id="slogan">
               <b> Powered by Dukamax Business Software. </b>
            </div>

            <br><br>

        </div>
    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script type="text/javascript">
        $(document).ready(function() {

            $("#print").on("click", function(){
                alert("Am working");
            })

        });
    </script>
@endsection

@endsection
