@extends('layouts.master')

@section('content')

    <form action="{{ route('get.purchases.report') }}" method="get" class="was-validated">
        <div class="card">
            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td><button type="button" class="btn btn-danger" id="deleteall"><i
                                        class="fas fa-trash-alt fa-lg"></i> Delete seleted</button></td>
                            <td>
                                @if ($sellingCount > 1)
                                    <select name="area" id="area" class="form-control" style="text-align: center"
                                        required>
                                        <option disabled selected>-- Choose Location --</option>
                                        <option value="all">-- All --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->id }}">
                                                -- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>
                                @else
                                    <input type="hidden" name="area" id="area" class="form-control"
                                        value="{{ $sellings[0]->id }}">

                                    <input type="text" name="area-copy" id="area-copy" class="form-control"
                                        value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                                @endif
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set date --</option>
                                    <option value="set duration">-- Set duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-primary"><i
                                        class="fas fa-search fa-lg"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-hover table-striped align-middle"
                        style="text-align: center;">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width:40px;"><input type="checkbox" id="checkall"></th>
                                <th>Date</th>
                                <th>Supplier</th>
                                <th>Invoice</th>
                                <th>Status</th>
                                <th>Location</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $sum = 0; @endphp
                            @foreach ($data as $result)
                                @php $sum += $result->total; @endphp
                                <tr>
                                    <td>
                                        <input type="checkbox" class="selected" id="{{ $result->id }}">
                                    </td>
                                    <td>
                                        {{ $result->created_at->format('Y-m-d') }}

                                        <small class="text-muted">{{ $result->created_at->format('H:i') }}</small>
                                    </td>
                                    <td>
                                        {{ $result->supplier->name ?? 'N/A' }}
                                    </td>
                                    <td>
                                        <a href="{{ route('purchased.items', $result->id) }}" class="btn btn-link p-0">
                                            {{ $result->invoice }}
                                        </a>
                                    </td>
                                    <td>
                                        <span
                                            class="badge 
                                                @if ($result->status == 'Completed') bg-success 
                                                @elseif($result->status == 'Pending') bg-warning 
                                                @else bg-secondary @endif">
                                            {{ ucfirst($result->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $result->selling->location->name }}</td>
                                    <td>
                                        <strong>{{ number_format($result->total, 2) }}</strong>
                                    </td>

                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-light">
                            <tr>
                                <th></th>
                                <th colspan="5" class="text-end">Total</th>
                                <th><strong>{{ number_format($sum, 2) }}</strong></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });

            $("#deleteall").on("click", function() {
                let selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select at least one item!!',
                    });
                } else {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You're about to delete the selected purchase(s)!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('purchases.bulk.delete') }}",
                                method: "POST",
                                data: {
                                    ids: selected,
                                    _token: "{{ csrf_token() }}" // include CSRF token here
                                },
                                success: function(data) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: 'Deleted successfully.',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        },
                                        willClose: () => {
                                            window.location.reload(true);
                                        }
                                    });
                                },

                                error: function(xhr, status, error) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error',
                                        text: 'Something went wrong!',
                                    });
                                }
                            });
                        }
                    });
                }
            });

        });

        //global variable
        let type = "";
        let area = "";
        let start = "";
        let end = "";

        $("#area").on("change", function() {
            area = $(this).val();
        });

        $("#start").on("change", function() {
            start = $(this).val();
        });

        $("#end").on("change", function() {
            end = $(this).val();
        });

        $("#type").on("change", function() {
            type = $(this).val();

            if (type == "today") {
                $("#start").attr("required", false).fadeOut("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set date") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set duration") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", true).fadeIn("slow");
            }
        });
    </script>
@endsection

@endsection
