@extends('layouts.master')

@section('content')
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 40px;
            background: #fff;
            color: #000;
        }

        .container {
            max-width: 800px;
            margin: auto;
            border: 1px solid #ccc;
            padding: 40px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .logo {
            width: 100px;
            height: 100px;
            background: #eee;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .invoice-details {
            text-align: right;
        }

        h1 {
            margin: 0;
        }

        .bill-to {
            margin-top: 40px;
        }

        .bill-to h3 {
            color: #2f487e;
        }

        .details-box {
            background: #edf3f8;
            padding: 10px;
            width: 250px;
            float: right;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 40px;
        }

        th,
        td {
            border: 1px solid #333;
            padding: 10px;
            text-align: center;
        }

        th {
            background: #2f487e;
            color: white;
        }

        .totals {
            margin-top: 30px;
            float: right;
            width: 300px;
        }

        .totals table {
            width: 100%;
        }

        .notes {
            clear: both;
            margin-top: 50px;
        }

        .notes h4 {
            color: #2f487e;
        }

        .footer {
            margin-top: 50px;
            /* font-size: 12px;
                    text-align: center; */
        }

        @media print {
            body {
                padding: 0;
            }

            .hide-on-print {
                display: none;
            }
        }
    </style>
    </head>

    <body>

        <div class="container">
            <div class="header" style="padding-bottom: 30px; border-bottom: 3px solid #2f487e;">
                <div class="logo" style="background: linear-gradient(135deg, #2f487e 60%, #4e6bb3 100%); border-radius: 12px; box-shadow: 0 2px 8px rgba(47,72,126,0.12); font-size: 1.5em; color: #fff; font-weight: bold;">
                    LOGO
                </div>
                <div class="invoice-details" style="text-align: right;">
                    <h1 style="letter-spacing: 2px; font-size: 2.5em; color: #2f487e; margin-bottom: 8px;">INVOICE</h1>
                    <p style="font-size: 1.1em; color: #4e6bb3; font-weight: 600;">
                        <strong>{{ $profile->selling->location->name }}</strong>
                    </p>
                    <p style="font-size: 1em; color: #6c757d;">{{ $profile->address }}, Tanzania</p>
                </div>
            </div>

            <div class="bill-to" style="margin-top: 40px; display: flex; justify-content: space-between; align-items: flex-start;">
                <div>
                    <h3 style="color: #2f487e; font-size: 1.3em; margin-bottom: 10px; letter-spacing: 1px;">BILL TO:</h3>
                    <div style="background: #f8fafc; border-radius: 10px; padding: 18px 24px; box-shadow: 0 2px 8px rgba(47,72,126,0.06); font-size: 1.08em;">
                        <strong style="font-size: 1.15em; color: #2f487e;">{{ $purchase->supplier->name }}</strong><br>
                        <span style="color: #4e6bb3;">{{ $purchase->supplier->address }}</span><br>
                        <span style="color: #6c757d;">Tanzania</span><br>
                        <span style="color: #adb5bd;">ZIP Code 00000</span>
                    </div>
                </div>
                <div class="details-box" style="background: linear-gradient(135deg, #e3eaf6 60%, #f8fafc 100%); border-radius: 10px; box-shadow: 0 2px 8px rgba(47,72,126,0.08); padding: 18px 24px; width: 270px; font-size: 1.08em;">
                    <p style="margin-bottom: 10px;">
                        <strong style="color: #2f487e;">INVOICE NUMBER:</strong>
                        <span style="color: #4e6bb3;">TRA-<span id="invoiceNumber">{{ $purchase->invoice }}</span></span>
                    </p>
                    <p style="margin-bottom: 10px;">
                        <strong style="color: #2f487e;">ISSUE DATE:</strong>
                        <span style="color: #4e6bb3;">{{ date('d/m/Y') }}</span>
                    </p>
                    <p style="margin-bottom: 10px;">
                        <strong style="color: #2f487e;">DUE DATE:</strong>
                        <span style="color: #4e6bb3;">{{ \Carbon\Carbon::now()->addWeek()->format('d/m/Y') }}</span>
                    </p>
                    <p style="margin-bottom: 10px;">
                        <strong style="color: #2f487e;">CURRENCY:</strong>
                        <span style="color: #4e6bb3;">Tsh</span>
                    </p>
                    <p style="margin-bottom: 0;">
                        <strong style="color: #2f487e;">AMOUNT DUE:</strong>
                        <span style="color: #e67e22; font-weight: bold;">{{ number_format($purchase->due, 0) }}</span>
                    </p>
                </div>
            </div>

            <table style="background: #f8fafc; border-radius: 10px; box-shadow: 0 2px 8px rgba(47,72,126,0.08); overflow: hidden;">
                <thead>
                    <tr style="background: linear-gradient(90deg, #2f487e 70%, #4e6bb3 100%); color: #fff;">
                        <th style="padding: 16px; font-size: 1.1em; border: none;">#</th>
                        <th style="padding: 16px; font-size: 1.1em; border: none;">Description</th>
                        <th style="padding: 16px; font-size: 1.1em; border: none;">QTY/HR</th>
                        <th style="padding: 16px; font-size: 1.1em; border: none;">Unit Cost</th>
                        <th style="padding: 16px; font-size: 1.1em; border: none;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($purchase->purchasedItems as $item)
                        <tr style="background: {{ $loop->even ? '#e3eaf6' : '#fff' }};">
                            <td style="padding: 14px; border: none; font-weight: 600; color: #2f487e;">{{ $loop->iteration }}</td>
                            <td style="padding: 14px; border: none; text-align: left;">
                                <span style="font-weight: 600;">{{ $item->product->product }} {{ $item->batch_no ? '| Batch'.$item->batch_no : '' }}</span>
                                @if(!empty($item->description))
                                    <br><span style="font-size: 0.95em; color: #6c757d;">{{ $item->description }}</span>
                                @endif
                            </td>
                            <td style="padding: 14px; border: none;">{{ $item->qty }} <span style="color:#4e6bb3;">{{ $item->unit->name }}</span></td>
                            <td style="padding: 14px; border: none;">{{ number_format($item->buying, 0) }}</td>
                            <td style="padding: 14px; border: none; font-weight: 600;">{{ number_format($item->buying * $item->qty, 0) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="totals">
                <table style="background: #f8fafc; border-radius: 10px; box-shadow: 0 2px 8px rgba(47,72,126,0.08); overflow: hidden;">
                    <tr style="background: #e3eaf6;">
                        <td style="text-align:left; font-weight:600; padding: 12px 16px; border: none;">SUBTOTAL</td>
                        <td style="text-align:right; font-weight:600; padding: 12px 16px; border: none;">{{ number_format($purchase->total, 0) }}</td>
                    </tr>
                    <tr>
                        <td style="text-align:left; color:#2f487e; font-weight:500; padding: 12px 16px; border: none;">DISCOUNT</td>
                        <td style="text-align:right; color:#2f487e; font-weight:500; padding: 12px 16px; border: none;">{{ number_format(0, 0) }}</td>
                    </tr>
                     <tr style="background: #e3eaf6;">
                        <td style="text-align:left; font-weight:600; padding: 12px 16px; border: none;">Net</td>
                        <td style="text-align:right; font-weight:600; padding: 12px 16px; border: none;">{{ number_format($purchase->net, 0) }}</td>
                    </tr>
                     <tr>
                        <td style="text-align:left; color:#2f487e; font-weight:500; padding: 12px 16px; border: none;">Paid</td>
                        <td style="text-align:right; color:#2f487e; font-weight:500; padding: 12px 16px; border: none;">{{ number_format($purchase->paid, 0) }}</td>
                    </tr>
                    <tr style="background: #2f487e;">
                        <td style="text-align:left; color:#fff; font-size:1.1em; font-weight:700; padding: 16px; border: none;">AMOUNT DUE</td>
                        <td style="text-align:right; color:#fff; font-size:1.1em; font-weight:700; padding: 16px; border: none;">
                            {{ number_format($purchase->due, 0) }}
                        </td>
                    </tr>
                </table>
            </div>

            <div class="notes">
                <h4>NOTES:</h4>
                <p>Thank you for your business.<br>
                    To ensure we correctly match your payment, always reference invoice numbers when making your payment.
                </p>
            </div>

            <div class="footer">
                <!-- Buttons for print/download -->
                <div class="hide-on-print" style="margin-top: 30px;">
                    <div class="btn-group" role="group">
                       <a href="{{ route('generate.pdf', [$purchase->supplier->id, $purchase->supplier->selling_id, isset($duration) ? $duration : '-', isset($start) ? $start : '-', isset($end) ? $end : '-', 2, $purchase->id, 'supplier']) }}"
                            class="btn btn-primary">
                            <i class="fas fa-download"></i> Generate PDF
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @section('scripts')
        <script>
            // Generate random invoice number
            const randomNum = Math.floor(1000 + Math.random() * 9000);
            document.getElementById('invoiceNumber').textContent = '00' + randomNum;
        </script>
    @endsection

@endsection
