
@extends('layouts.bar-layout')

@section('title', 'Customer - Orders')

@push('styles')
    <style>
        body {
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)),
                url('https://images.unsplash.com/photo-1565299624946-b28f40a0ae38') no-repeat center center fixed;
            background-size: cover;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: Arial, sans-serif;
        }

        .order-link {
            cursor: pointer;
            color: #0d6efd;
            text-decoration: underline;
        }

        .order-link:hover {
            color: #0a58ca;
        }

        .modal-lg {
            max-width: 900px;
        }

        .cart-total-row {
            background-color: #f1f3f5;
        }

        .comment-box {
            background-color: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 10px 15px;
            border-radius: 6px;
            font-style: italic;
            font-size: 0.9rem;
        }
    </style>
@endpush

@section('content')
    <div class="container">
        <div class="card glass-card">
            <div class="card-header">
                <h6><i class="bi bi-card-list me-2"></i> All Orders </h6>
            </div>
            <div class="card-body p-4">
                @if ($carts->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover align-middle" id="data-table">
                            <thead class="table-dark text-center">
                                <tr>
                                    <th><i class="bi bi-hash me-1"></i></th>
                                    <th class="text-center"><i class="bi bi-grid-3x3-gap-fill me-1"></i> Table Number
                                    </th>
                                    <th class="text-center"><i class="bi bi-receipt-cutoff me-1"></i> Order Number</th>
                                    <th class="text-center"><i class="bi bi-clock-history me-1"></i> Time Placed</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($carts as $cart)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td class="fw-bold text-center">{{ $cart->table->name }}</td>
                                        <td class="text-center">
                                            <span class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                                data-bs-target="#exampleModal{{ $cart->id }}">
                                                Order # 00{{ $cart->id }} <i class="fa fa-eye"></i>
                                            </span>

                                            <!-- Order Details Modal -->
                                            <div class="modal fade" id="exampleModal{{ $cart->id }}" tabindex="-1"
                                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-xl modal-dialog-centered">
                                                    <div class="modal-content border-0 shadow-lg glass-modal">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header text-white border-0"
                                                            style="background: linear-gradient(90deg, #0d6efd, #0b5ed7);">
                                                            <h5 class="modal-title fw-bold d-flex align-items-center"
                                                                id="exampleModalLabel">
                                                                <i class="bi bi-receipt-cutoff me-2"></i>
                                                                {{ $cart->table->name }} - Order #00{{ $cart->id }}
                                                            </h5>
                                                            <button type="button" class="btn-close btn-close-white"
                                                                data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>

                                                        <!-- Modal Body -->
                                                        <div class="modal-body p-4">

                                                            <div class="table-responsive">
                                                                <table
                                                                    class="table table-hover table-bordered align-middle cart-table mb-0 text-center">
                                                                    <thead class="table-light">
                                                                        <tr>
                                                                            <th>Image</th>
                                                                            <th>Name</th>
                                                                            <th>Qty</th>
                                                                            <th>Price</th>
                                                                            <th>Total</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @php $cartTotal = 0; @endphp
                                                                        @foreach ($cart->cartItems as $item)
                                                                            @php $cartTotal += $item->total; @endphp
                                                                            <tr>
                                                                                <td>
                                                                                    <img src="{{ $item->image ?? 'https://via.placeholder.com/60' }}"
                                                                                        class="img-thumbnail rounded shadow-sm product-img"
                                                                                        style="width:60px;height:60px;object-fit:cover;">
                                                                                </td>
                                                                                <td class="fw-semibold">
                                                                                    {{ $item->product_name }}</td>
                                                                                <td>{{ $item->qty }}</td>
                                                                                <td>{{ number_format($item->price, 2) }}
                                                                                </td>
                                                                                <td class="fw-bold text-success">
                                                                                    {{ number_format($item->total, 2) }}
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                    </tbody>
                                                                    <tfoot>
                                                                        <tr class="fw-bold cart-total-row">
                                                                            <td colspan="4" class="text-end fs-6">
                                                                                Order Total:</td>
                                                                            <td class="text-success fs-6">
                                                                                {{ number_format($cartTotal, 2) }}</td>
                                                                        </tr>
                                                                        {{-- @if ($cart->comment) --}}
                                                                        <tr>
                                                                            <td colspan="5"
                                                                                class="text-center bg-warning bg-opacity-25 fst-italic">
                                                                                <i class="bi bi-chat-dots me-1"></i>
                                                                                {{ $cart->comment }} No Comment...
                                                                            </td>
                                                                        </tr>
                                                                        {{-- @endif --}}
                                                                    </tfoot>
                                                                </table>
                                                            </div>

                                                        </div>

                                                        <!-- Modal Footer -->
                                                        <div class="modal-footer border-0">
                                                            <div class="btn-group" role="group">
                                                                <button type="button" class="btn btn-danger btn-sm"
                                                                    data-bs-dismiss="modal">
                                                                    <i class="bi bi-x-circle me-1"></i> Close
                                                                </button>
                                                                @if ($cart->flag == 1)
                                                                    <a href="{{ 'mark.order.as.seen', $cart->id }}"
                                                                        class="btn btn-success btn-sm">
                                                                        <i class="bi bi-eye me-1"></i> Mark as seen
                                                                    </a>
                                                                @endif
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">{{ $cart->created_at->format('d M Y h:i A') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="alert alert-info text-center fs-5 py-4 shadow-sm rounded-3">
                        <i class="bi bi-info-circle me-2"></i> No carts found.
                    </div>
                @endif
            </div>
            <div class="card-footer">
                <form action="{{ route('validate.waiters.details') }}" method="get">
                    <input type="hidden" name="waiter" id="waiter" value="{{ $waiterId }}"
                        class="form-control text-center" readonly>

                    <input type="hidden" name="password" id="password" value="{{ $password }}"
                        class="form-control text-center" readonly>

                    <button type="submit" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left me-1"></i> Back
                    </button>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(document).ready(function() {
                $('#data-table').DataTable({
                    responsive: true,
                    pageLength: 10,
                    order: [
                        [2, 'desc']
                    ], // sort by time column
                    language: {
                        search: "_INPUT_",
                        searchPlaceholder: "Search orders..."
                    }
                });
            });
        </script>
    @endpush
@endsection





