<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            width: 80mm;
        }

        header {
            text-align: center;
            margin-bottom: 5px;
        }

        #logo img {
            width: 60%;
            max-width: 50mm;
            display: block;
            margin: 0 auto 5px auto;
        }

        .store-info,
        .customer-info {
            text-align: center;
            margin-bottom: 5px;
        }

        .items {
            width: 100%;
            border-collapse: collapse;
        }

        .items th,
        .items td {
            border-bottom: 1px solid #000;
            padding: 2px 0;
            font-size: 11px;
        }

        .items th {
            text-align: left;
        }

        .items td.qty,
        .items td.price,
        .items td.disc,
        .items td.amount {
            text-align: right;
        }

        .totals {
            width: auto;
            margin-left: auto;
            /* pushes table to the right */
            text-align: right;
        }

        .totals tr td {
            font-weight: bold;
            padding: 2px 0;
        }

        .thank-you {
            text-align: center;
            margin-top: 5px;
            font-size: 12px;
        }

        footer {
            text-align: center;
            font-size: 10px;
            margin-top: 5px;
        }

        /* Print styling for thermal printer */
        @media print {
            body {
                width: 80mm;
            }
        }
    </style>
</head>

<body id="body">
    <header>
        <div id="logo">
            <img src="{{ asset('storage/logos/' . ($profileData['logo'] ?? 'logo.png')) }}" alt="Logo">
        </div>
        <h2>{{ $profileData->selling->location->name }}</h2>
        <div class="store-info">
            <span>{{ $profileData->address }}</span><br>
            <span>Contact: {{ $profileData->phone }}</span><br>
            <span>TIN: {{ $profileData->tin }}</span>
        </div>
    </header>

    <div class="customer-info">
        <span>Date: {{ $sale->created_at }}</span><br>
        <span>Customer: {{ $sale->customer->name ?? 'Walkin Customer' }}</span><br>
        <span>Served by: {{ $sale->user->name }}</span>
    </div>

    <table class="items">
        <thead>
            <tr>
                <th>SN</th>
                <th>Item</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Disc</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            @for ($i = 0; $i < count($items['product']); $i++)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td class="text-left">{{ $items['product'][$i] }}</td>
                    <td class="qty">
                        {{ $items['qty'][$i] }} {{ $items['unit'][$i] }}
                        @if ($items['cont'][$i] > 1)
                            ({{ $items['cont'][$i] }})
                        @endif
                    </td>

                    <td class="price">{{ number_format($items['price'][$i]) }}</td>
                    <td class="disc">{{ $items['disc'][$i] > 0 ? number_format($items['disc'][$i]) : '-' }}</td>
                    <td class="amount">{{ number_format($items['amount'][$i]) }}</td>
                </tr>
            @endfor
        </tbody>
    </table>

    <table class="totals">
        <tr>
            <td style="text-align:right;">Total:</td>
            <td style="text-align:right;">{{ number_format($sale->total ?? 0) }}</td>
        </tr>
        <tr>
            <td style="text-align:right;">Disc:</td>
            <td style="text-align:right;">{{ number_format($sale->discount ?? 0) }}</td>
        </tr>
        <tr>
            <td style="text-align:right;">Net:</td>
            <td style="text-align:right;">{{ number_format($sale->net ?? 0) }}</td>
        </tr>
        <tr>
            <td style="text-align:right;">Paid:</td>
            <td style="text-align:right;">{{ number_format($sale->paid ?? 0) }}</td>
        </tr>
        <tr>
            <td style="text-align:right;">Due:</td>
            <td style="text-align:right;">{{ number_format($sale->due ?? 0) }}</td>
        </tr>
    </table>

    <div class="thank-you">
        Thank you for your visit!
    </div>

    <footer>
        Powered by Dukamax (0757 290 359)
    </footer>

    <script>
        window.print();
        window.onload = function() {
            document.getElementById("body").onclick = function() {
                if ('{{ $status }}' === 'hold') {
                    window.close();
                } else {
                    window.location.href = "{{ route('sale.index', ['id' => 0, 'status' => $status]) }}";
                }
            }
        };
    </script>
</body>

</html>
