@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <button type="button" class="btn btn-outline-info" data-toggle="modal" data-target="#recievedLoanModal">
                <i class="fa-solid fa-plus"></i>
                New Loan
            </button>

            <div class="modal fade" id="recievedLoanModal" tabindex="-1" role="dialog"
                aria-labelledby="recievedLoanModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="recievedLoanModalLabel">Recieved a loan</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="{{ route('recieved.loan.store') }}" method="post" id="issue-loan"
                                class="was-validated" onsubmit="showSpinner()">
                                @csrf

                                <label for="date">Date</label>
                                <input type="date" name="date" value="{{ date('Y-m-d') }}" id="issue-date"
                                    class="form-control" required>

                                <label for="creditor">Creditor name</label>
                                <select name="creditor" id="creditor" class="form-control" required>
                                    <option disabled selected value="">-- Choose Creditor --</option>
                                    @foreach ($creditors as $creditor)
                                        <option value="{{ $creditor->id }}">-- {{ $creditor->name }} --</option>
                                    @endforeach
                                </select>

                                <label for="principle">Principle</label>
                                <input type="number" name="principle" id="principle" class="form-control"
                                    placeholder="Enter Principle" required>

                                <label for="account">Account</label>
                                <select name="account" id="account" class="form-control" required>
                                    <option disabled selected value="">-- Select Account --</option>
                                    @foreach ($accounts as $account)
                                        <option value="{{ $account->id }}">-- {{ $account->type }} - {{ $account->name }} --
                                    @endforeach
                                </select>

                                <label for="rdate">Return Date</label>
                                <input type="date" name="rdate" id="return-date" class="form-control" required>

                                <label for="loan-purpose">Loan purpose</label>
                                <input type="text" name="purpose" id="loan-purpose" class="form-control"
                                    placeholder="Loan purpose" required>

                                <label for="intrest">Interest</label>
                                <input type="number" name="intrest" id="intrest" value="" class="form-control"
                                    required>

                                <label for="tamount">Total return amount</label>
                                <input type="number" name="tamount" id="tamount" class="form-control" readonly required>

                                <label for="installment">Installment</label>
                                <input type="number" name="installment" id="installment" class="form-control" required>

                                <label for="iamount">Installment amount </label>
                                <input type="number" name="iamount" readonly id="iamount" class="form-control" required>

                            </form>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i
                                    class="fa-solid fa-xmark fa-lg"></i> Close</button>
                            <button type="submit" form="issue-loan" class="btn btn-outline-primary"><i
                                    class="fa-solid fa-paper-plane fa-lg"></i> Confirm</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Creditor</th>
                        <th>Principle</th>
                        <th>Next Installment</th>
                        <th>Installment Amount</th>
                        <th>Confirmed By</th>
                        <th>Status</th>
                        <th style="width: 25%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($loans as $loan)
                        <tr>
                            <td>{{ $loop->index + 1 }}</td>
                            <td>{{ $loan->creditor->name }}</td>
                            <td>{{ number_format($loan->principle) }}</td>
                            <td>{{ $loan->next_installment_date }}</td>
                            <td>{{ number_format($loan->next_installment_amount) }}</td>
                            <td>{{ $loan->user->name }}</td>
                            <td>
                                @if ($loan->status == 1)
                                    <span class="badge badge-warning p-2 pl-3 pr-3 rounded-pill"
                                        style="background-color: #ffc107; color: #000; font-size: 1rem;">Pending</span>
                                @elseif ($loan->status == 2)
                                    <span class="badge badge-success p-2 pl-3 pr-3 rounded-pill"
                                        style="background-color: #198754; color: #fff; font-size: 1rem;">Cleared</span>
                                @endif
                            </td>
                            <td>
                                <!-- Delete Modal -->
                                <button type="button" class="btn btn-outline-danger" data-toggle="modal"
                                    data-target="#deleteLoan{{ $loan->id }}"><i
                                        class="fas fa-trash-alt"></i></button>

                                <div class="modal fade" id="deleteLoan{{ $loan->id }}" tabindex="-1"
                                    role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLongTitle">Delete Loan</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                Are you sure you want to delete this loan ?
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-outline-secondary"
                                                    data-dismiss="modal"><i class="fa-solid fa-xmark fa-lg"></i> Close</button>
                                                <form action="{{ route('delete.loan', $loan->id) }}" method="POST"
                                                    onsubmit="showSpinner()">
                                                    @csrf
                                                    <button type="submit" class="btn btn-outline-danger"><i
                                                            class="fas fa-paper-plane"></i> Confirm</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <!-- Edit Modal -->
                                <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                    data-target="#editLoan{{ $loan->id }}"> <i
                                        class="fa-solid fa-pen-to-square fa-lg"></i></button>

                                <div class="modal fade" id="editLoan{{ $loan->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLongTitle">Edit Loan</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('update.loan', $loan->id) }}" method="POST"
                                                onsubmit="showSpinner()" class="was-validated">
                                                @csrf

                                                <div class="modal-body">
                                                    <label for="date">Date</label>
                                                    <input type="text" name="date" value="{{ date('Y-m-d') }}"
                                                        readonly id="date" class="form-control" readonly>

                                                    <label for="creditor">Creditor name</label>
                                                    <select name="creditor" id="creditor" class="form-control" required>
                                                        <option disabled selected value="">-- Choose Creditor --
                                                        </option>
                                                        @foreach ($creditors as $creditor)
                                                            <option value="{{ $creditor->id }}">-- {{ $creditor->name }} --
                                                            </option>
                                                        @endforeach
                                                    </select>

                                                    <label for="principle">Principle</label>
                                                    <input type="number" name="principle" id="principle"
                                                        class="form-control" placeholder="Enter Principle" required>

                                                    <label for="account">Account</label>
                                                    <select name="account" id="account" class="form-control" required>
                                                        <option selected value="{{ $loan->account_id }}">
                                                           -- {{ $loan->account->type }} - {{ $loan->account->name }} --
                                                        </option>
                                                        @foreach ($accounts as $account)
                                                            <option value="{{ $account->id }}">-- {{ $account->type }}
                                                                - {{ $account->name }} --
                                                        @endforeach
                                                    </select>

                                                    <label for="rdate">Return Date</label>
                                                    <input type="date" name="rdate" id="rdate"
                                                        class="form-control" required>

                                                    <label for="loan-purpose">Loan purpose</label>
                                                    <input type="text" name="purpose" id="loan-purpose"
                                                        class="form-control" placeholder="Loan purpose" required>

                                                    <label for="intrest">Interest</label>
                                                    <input type="number" name="intrest" id="intrest" value=""
                                                        class="form-control" required>

                                                    <label for="tamount">Total return amount</label>
                                                    <input type="number" name="tamount" id="tamount"
                                                        class="form-control" readonly required>

                                                    <label for="installment">Installment</label>
                                                    <input type="number" name="installment" id="installment"
                                                        class="form-control" required>

                                                    <label for="iamount">Installment amount </label>
                                                    <input type="number" name="iamount" readonly id="iamount"
                                                        class="form-control" required>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-outline-secondary"
                                                        data-dismiss="modal"><i class="fa-solid fa-xmark"></i>
                                                        Close</button>
                                                    <button type="submit" class="btn btn-outline-primary"><i
                                                            class="fa-solid fa-paper-plane"></i> Save Update</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <!-- payment modal -->
                                <button type="button" class="btn btn-outline-success" data-toggle="modal"
                                    data-target="#paymentModal{{ $loan->id }}"><i
                                        class="fa-solid fa-money-bill-wave fa-lg"></i></button>

                                <div class="modal fade" id="paymentModal{{ $loan->id }}" tabindex="-1"
                                    role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Loan payment</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('loan.payment', $loan->id) }}" method="post"
                                                class="was-validated" onsubmit="showSpinner()">
                                                @csrf

                                                <div class="modal-body">
                                                    <label for="return-date">Return date</label>
                                                    <input type="date" class="form-control" name="return-date"
                                                        value="{{ $loan->rdate }}" id="return-date">

                                                    <label for="current">Current date</label>
                                                    <input type="date" class="form-control" name="current"
                                                        id="current" value="<?php echo date('Y-m-d'); ?>" readonly>

                                                    <label for="installement">Installment amount</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ number_format($loan->iamount) }}" name="installement"
                                                        id="installement" readonly>

                                                    <label for="paid">Paid amount</label>
                                                    <input type="number" class="form-control" name="paid"
                                                        value="0" id="paid">

                                                    <label for="account">Account</label>
                                                    <select name="account" id="account" class="form-control" required>
                                                        <option disabled selected value="">-- Select Account --
                                                        </option>
                                                        @foreach ($accounts as $account)
                                                            <option value="{{ $account->id }}">-- {{ $account->type }}
                                                                - {{ $account->name }} --
                                                            </option>
                                                        @endforeach
                                                    </select>

                                                    <label for="due">Due amount</label>
                                                    <input type="number" class="form-control" name="due"
                                                        value="0" id="due" readonly>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-outline-secondary"
                                                        data-dismiss="modal"><i class="fa-solid fa-xmark fa-lg"></i>
                                                        Close</button>
                                                    <button type="submit" class="btn btn-outline-success"><i
                                                            class="fa-solid fa-paper-plane fa-lg"></i> Submit
                                                        Payment</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $(document).ready(function() {

            // Create a new Intl.NumberFormat object
            var formatter = new Intl.NumberFormat();

            // Initiate variables
            var issueDate = new Date("{{ date('Y-m-d') }}");
            var principal = 0;
            var interestRate = 0;
            var numInstallments = 0;

            // Get Iissued date
            $("#issue-date").on('change', function() {
                issueDate = new Date($(this).val());
                computeLoanDetails();
            });

            // Get return date
            $("#return-date").on('change', function() {
                computeLoanDetails();
            });

            // Get the principle
            $("#principle").on('keyup', function() {
                principal = parseFloat($(this).val());
                computeLoanDetails();
            });

            // Get the intrest
            $("#intrest").on('keyup', function() {
                interestRate = parseFloat($(this).val()) / 100;
                computeLoanDetails();
            });

            // Get the installment
            $("#installment").on('keyup', function() {
                numInstallments = parseFloat($(this).val());
                computeLoanDetails();
            });

            function computeLoanDetails() {
                // Calculate total interest
                var totalInterest = principal * interestRate;

                // Calculate total amount of loan to be returned
                var totalAmount = principal + totalInterest;

                // If there are installments, calculate installment amount
                var installmentAmount;
                if (numInstallments > 1) {
                    installmentAmount = totalAmount / numInstallments;
                } else {
                    installmentAmount = totalAmount;
                }

                // Fix to decimal place
                installmentAmount = installmentAmount.toFixed(2);
                totalAmount = totalAmount.toFixed(2);

                $("#iamount").val(installmentAmount); // Display installment amount
                $("#tamount").val(totalAmount); // Display total amount
            }

            $("#paid").on("input", function() {
                let user_input = $(this).val(); // Get user input
                let installment = $('#installement').val().replace(/,/g,
                ''); // Remove commas and parse as base 10
                let due = installment - user_input; // Calculate due amount
                $('#due').val(due); // Display due amount
            });
        });
    </script>
@endsection

@endsection
