@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            <div class="btn-group mb-3" role="group" aria-label="Requisition actions">
                <button type="button" class="btn btn-danger" id="deleteall">
                    <i class="fas fa-trash-alt"></i> Delete all
                </button>

                <a href="{{ route('requisition.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> New requisition
                </a>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0" id="data-table">
                    <thead class="thead-dark text-center">
                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th><i class="fa fa-hashtag mr-1"></i>S/N</th>
                            <th><i class="fa fa-calendar mr-1"></i>Date</th>
                            <th><i class="fa fa-map-pin mr-1"></i>Location</th>
                            <th><i class="fa fa-file-alt mr-1"></i>Requisition #</th>
                            <th><i class="fa fa-info-circle mr-1"></i>Status</th>
                            <th><i class="fa fa-user mr-1"></i>User</th>
                            <th><i class="fa fa-cogs mr-1"></i>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($requisitions as $requisition)
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox" class="selected" id="{{ $requisition->id }}">
                                </td>
                                <td class="font-weight-bold text-center">{{ $loop->iteration }}</td>
                                <td class="text-center">
                                    {{ $requisition->created_at }}</td>
                                <td class="text-primary font-weight-bold text-center">
                                    {{ $requisition->selling->location->name }}
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-info px-3 py-2 view-items" data-id="{{ $requisition->id }}"
                                        style="cursor: pointer;">
                                        REQ-{{ str_pad($requisition->id, 4, '0', STR_PAD_LEFT) }}
                                    </span>

                                    {{-- Hidden div to hold the requisition items in HTML (for JS to pull later) --}}
                                    <div id="items-{{ $requisition->id }}" class="d-none">
                                        <p> <i class="fas fa-comment-alt text-info mr-1"></i><strong>Remarks:</strong>
                                            {{ $requisition->remarks ?? 'No remarks' }}</p>

                                        <table class="table table-bordered table-sm">
                                            <thead>
                                                <tr>
                                                    <th><i class="fa fa-hashtag"></i></th>
                                                    <th><i class="fa fa-box"></i> Product</th>
                                                    <th><i class="fa fa-sort-numeric-up"></i> Qty</th>
                                                    <th><i class="fa fa-sticky-note"></i> Note</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($requisition->items as $index => $item)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $item->product_name }}</td>
                                                        <td>{{ $item->qty }} {{ $item->unit->name }}</td>
                                                        <td>{{ $item->note }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                </td>
                                <td class="text-center">
                                    @if ($requisition->status == 'approved')
                                        <span class="badge badge-success px-3 py-2"><i
                                                class="fa fa-check-circle mr-1"></i>Approved</span>
                                    @elseif($requisition->status == 'pending')
                                        <span class="badge badge-warning text-dark px-3 py-2"><i
                                                class="fa fa-clock mr-1"></i>Pending</span>
                                    @else
                                        <span class="badge badge-danger px-3 py-2"><i
                                                class="fa fa-times-circle mr-1"></i>Rejected</span>
                                    @endif
                                </td>
                                <td class="text-center font-weight-semibold">{{ $requisition->requestedBy->name ?? '-' }}
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        @role('Admin')
                                            <!-- Approve Button -->
                                            <button type="button" class="btn btn-sm btn-success shadow-sm" data-toggle="modal"
                                                data-target="#confirmApproveModal"
                                                data-href="{{ route('approve.requisition', [
                                                    'requisitionId' => $requisition->id,
                                                    'status' => 'approved',
                                                    'remarks' => 'Approved by manager',
                                                ]) }}">
                                                <i class="fa fa-check"></i> Approve
                                            </button>

                                            <!-- Reject Button -->
                                            <button type="button" class="btn btn-sm btn-danger shadow-sm" data-toggle="modal"
                                                data-target="#confirmRejectModal"
                                                data-href="{{ route('approve.requisition', [
                                                    'requisitionId' => $requisition->id,
                                                    'status' => 'rejected',
                                                    'remarks' => 'Rejected by manager',
                                                ]) }}">
                                                <i class="fa fa-times"></i> Reject
                                            </button>
                                        @endrole

                                        {{-- Edit Button --}}
                                        <button type="button" class="btn btn-sm btn-primary shadow-sm edit-btn"
                                            data-toggle="modal" data-target="#edit-{{ $requisition->id }}"
                                            data-id="{{ $requisition->id }}">
                                            <i class="fa fa-pencil-alt"></i> Edit
                                        </button>

                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="edit-{{ $requisition->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl" role="document">
                                                <div class="modal-content">
                                                    <form action="{{ route('requisition.update', $requisition->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('PUT')

                                                        <div class="modal-header bg-primary text-white">
                                                            <h5 class="modal-title"><i class="fa fa-edit mr-2"></i> Edit
                                                                Requisition</h5>
                                                            <button type="button" class="close text-white"
                                                                data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>

                                                        <div class="modal-body">
                                                            {{-- Remarks & Location --}}
                                                            <div class="row mb-3">
                                                                <div class="col-md-6">
                                                                    <label for="remarks"><i
                                                                            class="fas fa-comment-alt text-info"></i>
                                                                        Remarks</label>
                                                                    <textarea name="remarks" class="form-control shadow-sm">{{ $requisition->remarks }}</textarea>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <label for="location"><i
                                                                            class="fas fa-map-pin text-info"></i>
                                                                        Location</label>
                                                                    <select name="location"
                                                                        class="form-control shadow-sm text-center location"
                                                                        id="location{{ $requisition->id }}" required>
                                                                        @foreach ($sellings as $selling)
                                                                            <option value="{{ $selling->location_id }}"
                                                                                {{ $selling->location_id == $requisition->selling->location->id ? 'selected' : '' }}>
                                                                                -- {{ $selling->location->name }} --
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </div>

                                                            {{-- Items Table --}}
                                                            <div class="table-responsive">
                                                                <table class="table table-bordered table-hover">
                                                                    <thead class="thead-light text-center">
                                                                        <tr>
                                                                            <th><i class="fas fa-box-open"></i> Product
                                                                            </th>
                                                                            <th><i class="fas fa-balance-scale"></i> Unit
                                                                            </th>
                                                                            <th><i class="fas fa-sort-numeric-up"></i> Qty
                                                                            </th>
                                                                            <th><i class="fas fa-sticky-note"></i> Note
                                                                            </th>
                                                                            <th><i class="fas fa-cogs"></i> Action</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @foreach ($requisition->items as $key => $item)
                                                                            <tr>
                                                                                <!-- Product Search -->
                                                                                <td>
                                                                                    <input type="text" name="searchs[]"
                                                                                        class="form-control search text-center"
                                                                                        id="search{{ $key }}"
                                                                                        value="{{ $item->product_name }} "
                                                                                        readonly>
                                                                                    <input type="hidden"
                                                                                        name="product_ids[]"
                                                                                        id="id{{ $key }}"
                                                                                        value="{{ $item->product_id ?? '' }}">
                                                                                    <div class="position-relative">
                                                                                        <div class="list-group position-absolute w-100"
                                                                                            id="list{{ $key }}"
                                                                                            style="z-index: 10; display: none;">
                                                                                            <ul id="results{{ $key }}"
                                                                                                class="list-group"></ul>
                                                                                        </div>
                                                                                    </div>
                                                                                </td>

                                                                                <!-- Unit Select -->
                                                                                <td>
                                                                                    <select name="unit_ids[]"
                                                                                        class="form-control unit text-center"
                                                                                        id="unit{{ $key }}">
                                                                                        @foreach ($units as $unit)
                                                                                            <option
                                                                                                value="{{ $unit->id }}"
                                                                                                {{ $unit->id == $item->unit_id ? 'selected' : '' }}>
                                                                                                -- {{ $unit->name }} --
                                                                                            </option>
                                                                                        @endforeach
                                                                                    </select>
                                                                                </td>

                                                                                <!-- Qty -->
                                                                                <td>
                                                                                    <input type="number" name="qtys[]"
                                                                                        id="qty{ $key }}"
                                                                                        class="form-control text-center"
                                                                                        value="{{ $item->qty }}">
                                                                                </td>

                                                                                <!-- Notes -->
                                                                                <td>
                                                                                    <input type="text" name="notes[]"
                                                                                        class="form-control text-center"
                                                                                        placeholder="Optional note..."
                                                                                        value="{{ $item->note }}">
                                                                                </td>
                                                                                <td class="text-center">
                                                                                    <button type="button"
                                                                                        class="btn btn-danger btn-sm remove-row"><i
                                                                                            class="fas fa-trash-alt"></i></button>
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                    </tbody>
                                                                </table>
                                                            </div>

                                                            {{-- Add Item --}}
                                                            <button type="button" class="btn btn-primary btn-sm mb-3"
                                                                id="add-edit-row-{{ $requisition->id }}">
                                                                <i class="fas fa-plus"></i> Add Item
                                                            </button>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <div class="btn-group mb-3" role="group"
                                                                aria-label="Requisition actions">
                                                                <button type="submit" class="btn btn-success shadow-sm">
                                                                    <i class="fas fa-paper-plane"></i> Update Requisition
                                                                </button>
                                                                <button type="button" class="btn btn-secondary shadow-sm"
                                                                    data-dismiss="modal">
                                                                    <i class="fas fa-times"></i> Cancel
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Delete Button --}}
                                        <button class="btn btn-sm bg-pink shadow-sm delete" id="{{ $requisition->id }}">
                                            <i class="fa fa-trash-alt"></i> Delete
                                            <form
                                                action="{{ route('requisition.destroy', ['requisitionId' => $requisition->id]) }}"
                                                method="POST" id="deleteform{{ $requisition->id }}">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Requisition Found</h5>
                                        <p class="text-muted mb-0">You haven't added any Requition yet.<br>
                                            <span class="small">Click <strong>New Requition</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse

                        <!-- Requisition Items Modal -->
                        <div class="modal fade" id="requisitionItemsModal" tabindex="-1" role="dialog"
                            aria-labelledby="itemsModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-xl" role="document">
                                <div class="modal-content">
                                    <div class="modal-header bg-info text-white">
                                        <h5 class="modal-title" id="itemsModalLabel">Requisition Items</h5>
                                        <button type="button" class="close text-white" data-dismiss="modal"
                                            aria-label="Close">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body" id="requisitionItemsBody">
                                        <!-- Items will be injected here -->
                                    </div>
                                    <div class="modal-footer">
                                        {{-- Print Button --}}
                                        <a href="#" target="_blank" target="_blank"
                                            class="btn btn-primary btn-sm">
                                            <i class="fas fa-print"></i> Print
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Approve Confirmation Modal -->
                        <div class="modal fade" id="confirmApproveModal" tabindex="-1" role="dialog"
                            aria-labelledby="confirmApproveLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header bg-success text-white">
                                        <h5 class="modal-title">Confirm Approval</h5>
                                        <button type="button" class="close text-white" data-dismiss="modal"
                                            aria-label="Close">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        Are you sure you want to <strong>approve</strong> this requisition?
                                    </div>
                                    <div class="modal-footer">
                                        <div class="btn-group mb-3" role="group">
                                            <button type="button" class="btn btn-secondary btn-sm"
                                                data-dismiss="modal">Cancel</button>
                                            <a id="confirmApproveBtn" class="btn btn-success btn-sm" href="#">Yes,
                                                Approve</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Reject Confirmation Modal -->
                        <div class="modal fade" id="confirmRejectModal" tabindex="-1" role="dialog"
                            aria-labelledby="confirmRejectLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header bg-danger text-white">
                                        <h5 class="modal-title">Confirm Rejection</h5>
                                        <button type="button" class="close text-white" data-dismiss="modal"
                                            aria-label="Close">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        Are you sure you want to <strong>reject</strong> this requisition?
                                    </div>
                                    <div class="modal-footer">
                                        <div class="btn-group mb-3" role="group">
                                            <button type="button" class="btn btn-secondary btn-sm"
                                                data-dismiss="modal">Cancel</button>
                                            <a id="confirmRejectBtn" class="btn btn-danger btn-sm" href="#">Yes,
                                                Reject</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $(document).ready(function() {
                // Display requisition items
                $(document).on('click', '.view-items', function() {
                    let requisitionId = $(this).data('id');
                    let htmlContent = $('#items-' + requisitionId).html();

                    $('#itemsModalLabel').text('Requisition Items - REQ-' + requisitionId.toString().padStart(4,
                        '0'));
                    $('#requisitionItemsBody').html(htmlContent);

                    // Update the Print button href
                    var printUrl = "{{ url('requisitions/print') }}/" + requisitionId;
                    $('#requisitionItemsModal a.btn-primary').attr('href', printUrl);


                    $('#requisitionItemsModal').modal('show');
                });

                // Approve modal link injection
                $('#confirmApproveModal').on('show.bs.modal', function(event) {
                    var button = $(event.relatedTarget);
                    var href = button.data('href');
                    $('#confirmApproveBtn').attr('href', href);
                });

                // Reject modal link injection
                $('#confirmRejectModal').on('show.bs.modal', function(event) {
                    var button = $(event.relatedTarget);
                    var href = button.data('href');
                    $('#confirmRejectBtn').attr('href', href);
                });

                // Initiate variable
                let rowCount = 1000;

                $(document).on('click', '[id^=add-edit-row-]', function() {
                    rowCount++; // Ensure unique IDs for each row

                    const modalBody = $(this).closest('.modal-body');
                    const table = modalBody.find('tbody');

                    // Get location for this requisition modal
                    const locationId = modalBody.find('.location').val();

                    const row = `
                            <tr>
                                <td class="position-relative">
                                    <input type="text" name="searchs[]" 
                                        class="form-control text-center search" 
                                        id="search${rowCount}" 
                                        placeholder="Search product..." 
                                        data-location="${locationId}" 
                                        required>
                                    <input type="hidden" name="product_ids[]" id="product_id${rowCount}">

                                    <div id="list${rowCount}" class="position-absolute bg-white border border-primary w-100 rounded-bottom shadow-sm"
                                        style="display:none; z-index:1000;">
                                        <ol id="results${rowCount}" class="list-group list-group-flush mb-0"></ol>
                                    </div>
                                </td>
                                <td>
                                    <select name="unit_ids[]" id="unit${rowCount}" class="form-control text-center" required>
                                        @foreach ($units as $unit)
                                            <option value="{{ $unit->id }}">-- {{ $unit->name }} --</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <input type="number" name="qtys[]" class="form-control text-center" min="1" required>
                                </td>
                                <td>
                                    <input type="text" name="notes[]" class="form-control text-center" placeholder="Optional note...">
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-danger btn-sm remove-row">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        `;

                    table.append(row);
                });

                // Remove row from edit modal
                $(document).on('click', '.remove-row', function() {
                    $(this).closest('tr').remove();
                });

                // ✅ Track selected location
                $(document).on("change", ".location", function() {
                    selectedLocation = $(this).val();
                });

                // ✅ Product Search
                $(document).on("keyup", ".search", function() {
                    let query = $(this).val();
                    let id = $(this).attr('id').replace("search", "");
                    let selectedLocation = $(this).data('location'); // ✅ location for this row

                    if (!query) {
                        $("#list" + id).hide();
                        return;
                    }

                    $.ajax({
                        url: "{{ route('get.location.product') }}",
                        method: "GET",
                        data: {
                            query: query,
                            locationId: selectedLocation
                        },
                        success: function(data) {
                            const resultsList = $("#results" + id);
                            const listContainer = $("#list" + id);
                            resultsList.empty();

                            if (data.length === 0) {
                                listContainer.show();
                                resultsList.append(`
                                <li class="list-group-item text-center text-muted">No suggestions...</li>
                            `);

                                setTimeout(() => {
                                    listContainer.fadeOut("slow", function() {
                                        resultsList.empty();
                                    });
                                }, 2000);

                            } else {
                                listContainer.show();
                                data.forEach((item, index) => {
                                    resultsList.append(`
                                    <li class="list-group-item p-1">
                                        <button type="button" id="${index}" class="btn btn-outline-primary btn-block items" data-row="${id}">
                                            ${item.product} | <i class="fa fa-box"></i> ${item.stock[0]?.qty ?? 0} ${item.unit[0].unit.name}
                                        </button>
                                    </li>
                                `);
                                });

                                // ✅ Handle item selection
                                $(".items").off("click").on("click", function() {
                                    let index1 = $(this).attr("id");
                                    let rowId = $(this).data("row");
                                    let product = data[index1];

                                    $("#search" + rowId).val(product.product);
                                    $("#id" + rowId).val(product.id);
                                    $("#cont" + rowId).val(product.unit[0].unit_cont);
                                    $("#price" + rowId).val(product.unit[0].selling);

                                    // Update unit dropdown
                                    let unitSelect = $("#unit" + rowId);
                                    unitSelect.empty();
                                    product.unit.forEach((val, i) => {
                                        let selected = i === 0 ? 'selected' : '';
                                        unitSelect.append(
                                            `<option value="${val.unit.id}" ${selected}>-- ${val.unit.name} --</option>`
                                        );
                                    });

                                    $("#list" + rowId).fadeOut("slow");
                                });
                            }
                        }
                    });
                });

                // ✅ Unit Change
                $(document).on("change", ".unit", function() {
                    let unitId = $(this).val();
                    let id = $(this).attr("id").replace("unit", "");
                    let productId = $("#id" + id).val();

                    if (!productId || !unitId || !selectedLocation) return;

                    $.ajax({
                        url: "{{ route('unit.details') }}",
                        method: "GET",
                        data: {
                            unitId: unitId,
                            productId: productId,
                            locationId: selectedLocation
                        },
                        success: function(data) {
                            $("#cont" + id).val(data.unit_cont);
                            $("#price" + id).val(data.selling);
                        }
                    });
                });

                // ✅ Delete button
                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });
            });
        </script>
    @endsection
@endsection
