@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#registerRole">
                <i class="fa-solid fa-plus"></i>
                Register roles
            </button>

            <div class="modal fade" id="registerRole" tabindex="-1" role="dialog" aria-labelledby="registerRoleLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="registerRoleLabel">Register roles</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="{{ route('new.role') }}" method="post" id="new-role" class="was-validated">
                                @csrf
                                <input type="text" name="role" id="role" placeholder="Enter role name"
                                    name="role" class="form-control" required>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-primary" form="new-role">Regiter</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">

            <table class="table table-bordered table-hover table-striped align-middle" id="data-table">
                <thead class="thead-dark">
                    <tr>
                        <th style="width: 10%" class="text-center">#</th>
                        <th style="width: 60%" class="text-center">Role</th>
                        <th style="width: 30%" class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($roles as $role)
                        <tr>
                            <td class="text-center">{{ $loop->iteration }}</td>
                            <td class="font-weight-bold text-capitalize text-center">{{ $role->name }}</td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <a href="{{ route('edit.role', $role->id) }}" class="btn btn-primary btn-sm" title="View/Edit">
                                        <i class="fa fa-eye"></i> View
                                    </a>
                                    <form action="{{ route('delete.role', $role->id) }}" method="POST" id="deleteform{{ $role->id }}" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="btn btn-danger btn-sm delete" id="{{ $role->id }}" title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="text-center text-muted">No roles found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

    </div>

@section('scripts')
    <script>
        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection
@endsection
