<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12.5px;
            text-transform: uppercase;
            border-top: 1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:first-child,
        .items tbody tr td:first-child {
            width: 47%;
            min-width: 47%;
            max-width: 47%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 12px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            {{-- content: "\20B9"; --}} font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }

        .total {
            font-size: 13px;
            border-top: 1px dashed black !important;
            border-bottom: 1px dashed black !important;
        }

        .total.text,
        .total.price {
            text-align: right;
        }

        {{-- .total.price::before {
            content: "\20B9";
        } --}} .line {
            border-top: 1px solid black !important;
        }

        .heading.rate {
            width: 20%;
        }

        .heading.amount {
            width: 25%;
        }

        .heading.qty {
            width: 5%
        }

        p {
            padding: 1px;
            margin: 0;
        }

        section,
        footer {
            font-size: 12px;
        }
    </style>
</head>

<body id="body">

    <header>
        <input type="image" id="logo" src="" alt="logo.png">
    </header>

    <center>
        <h3>{{ $data->name }} </h3>
        <h4>{{ $data->address }} ({{ $data->phone }}) </h4>
        <h4>{{ date('Y-m-d') }}</h4>
        <h4>Reciept #: 00{{ $booking->id }}</h4>
        <h4>Customer:{{ $booking->name }}</h4>
        <h4>Room:{{ $booking->room }}</h4>
    </center>

    @php
        foreach ($bills as $bill) {
            $items = App\Models\BillItems::where('bill_id', $bill->id)->get();
        }
    @endphp

    <table class="items">
        <thead>
            <tr>
                <th class="heading name">Item</th>
                <th class="heading qty">Qty</th>
                <th class="heading rate">@ (Tshs)</th>
                <th class="heading amount">Amount</th>
            </tr>
        </thead>

        <tbody id="tbody">

            @foreach ($items as $item)
                <tr>
                    <td>{{ $item->product }}</td>
                    <td>{{ $item->qty }} ({{ $item->unit }})</td>
                    <td>{{ $item->price }}</td>
                    <td>{{ $item->amount }}</td>
                </tr>
            @endforeach

            <tr>
                <td>{{ $booking->room }}</td>
                <td>{{ $booking->days }} Days</td>
                <td>{{ $booking->price }}</td>
                <td>{{ $booking->price * $booking->days }}</td>
            </tr>

            <tr>
                <td colspan="3" class="sum-up line">Total</td>
                <td class="line price">{{ $booking->total + $roomBill - $booking->vat }}</td>
            </tr>

            @if ($profile->vat == 'Inclusive')
                <tr>
                    <td colspan="3" class="sum-up line">VAT</td>
                    <td class="line price">+{{ $booking->vat }}</td>
                </tr>
            @endif

            <tr>
                <td colspan="3" class="sum-up">Disc</td>
                @if ($booking->discount)
                    <td class="price">-{{ $booking->discount }}</td>
                @else
                    <td class="price">-0</td>
                @endif

            </tr>

            <tr>
                <td colspan="3" class="sum-up">Net</td>
                <td class="price">{{ $booking->net }}</td>
            </tr>

            <tr>
                <td colspan="3" class="sum-up">Paid</td>
                <td class="price">-{{ $paidAmount }}</td>
            </tr>

            <tr>
                <td colspan="3" class="sum-up">Due</td>
                <td class="price">{{ $booking->due }}</td>
            </tr>

        </tbody>
    </table>
    <section>

        <p style="text-align:center">
            Thank you for your visit!
        </p>
    </section>
    <footer style="text-align:center">
        <p>Powered by HotelMax business software</p>
        <p>www.universalsoftware.online</p>
    </footer>
</body>

<script>
    window.print();
    document.getElementById("body").onclick = function() {
        window.location.href = "{{ route('inside.customers', 'end') }}";
    };
</script>

</html>
