@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <button type="button" class="btn btn-outline-danger" id="deleteall">
                <i class="fa-solid fa-trash-alt fa-lg"></i> Delete selected</button>

            <!-- Large modal -->
            <button type="button" class="btn btn-outline-info" data-toggle="modal" data-target=".customer">
                <i class="fa-solid fa-plus fa-lg"></i> Register
                rooms</button>

            <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Register Room</h5>

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <form action="{{ route('rooms.store') }}" method="POST" class="was-validated">
                            @csrf
                            @method('POST')

                            <div class="modal-body">

                                <label for="name">Room</label>
                                <input type="text" name="name" class="form-control" id="name" required>

                                <label for="price">Room price</label>
                                <input type="text" name="price" class="form-control" id="price" required>

                                {{-- <table class="table table-striped" style="text-align: center">
                                        <thead style="text-align: center">
                                            <th>Pax</th>
                                            <th>Price</th>
                                            <th><button type="button" id="addRow" class="btn btn-info">+</button>
                                            </th>
                                        </thead>

                                        <tbody id="tbody">

                                        </tbody>
                                    </table>
                                    <br> --}}

                                <label for="description">Description</label>
                                <textarea name="description" id="description" cols="10" rows="5" class="form-control" required></textarea>

                            </div>

                            <div class="modal-footer">
                                <center>
                                    <button type="submit" class="btn btn-outline-info"><i class="fa-solid fa-paper-plane"></i> Register</button>
                                </center>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-stripped table-hover"
                style="border: 1px solid #dee2e6; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1), 0 8px 16px rgba(0,0,0,0.1)">
                <thead style="background-color: #f8fafc; border-bottom: 2px solid #dee2e6">
                    <tr>
                        <th style="width: 5%;"><input type="checkbox" id="checkall"></th>
                        <th style="width: 10%">S/N</th>
                        <th style="width: 15%">Price</th>
                        <th style="width: 20%">Room</th>
                        <th>Description</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                @foreach ($rooms as $room)
                    <tr>
                        <td><input type="checkbox" class="selected" id="{{ $room->id }}"></td>
                        <td> {{ $loop->index + 1 }}</td>
                        <td>{{ $room->name }}</td>
                        <td>{{ number_format($room->price) }}</td>
                        <td>{{ $room->description }}</td>
                        <td>
                            {{-- Block room --}}
                            <button type="button" class="btn btn-outline-secondary" data-toggle="modal"
                                data-target="#block-{{ $room->id }}" onclick="blockRoom({{ $room->id }})">
                                @if ($room->block == 1)
                                    <i class="fa-solid fa-check"></i>
                                @else
                                    <i class="fa-solid fa-xmark fa-lg"></i>
                                @endif
                            </button>

                            <div class="modal fade" id="block-{{ $room->id }}" tabindex="-1" role="dialog"
                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">

                                        <form action="{{ route('room.block', $room->id) }}" method="POST"
                                            class="was-validated">
                                            @csrf
                                            @method('POST')

                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Block reason</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <label for="reason">Select reason</label>
                                                <select name="reason" id="reason" class="form-control"
                                                    style="text-align: center">
                                                    <option value="">--Select reason--</option>
                                                    <option value="construction">-- Construction --</option>
                                                    <option value="cleaning">-- Cleaning --</option>
                                                </select>
                                            </div>

                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">--
                                                    Close --</button>
                                                <button type="submit" class="btn btn-info" id="confirmblock">-- Block
                                                    --</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            {{-- edit trigger model --}}
                            <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                data-target="#edit-{{ $room->id }}">
                                <i class="fa-solid fa-pen-to-square fa-lg"></i>
                            </button>

                            <div class="modal fade" id="edit-{{ $room->id }}" tabindex="-1" role="dialog"
                                aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">

                                        <form action="{{ route('room.update', $room->id) }}" method="POST"
                                            class="was-validated">
                                            @csrf
                                            @method('PUT')

                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Update Room Details</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <div class="modal-body">
                                                <label for="name">Room</label>
                                                <input type="text" name="name" class="form-control"
                                                    value="{{ $room->name }}" id="name" required>

                                                <label for="price">Room price</label>
                                                <input type="text" name="price" class="form-control"
                                                    value="{{ $room->price }}" id="price" required>

                                                <label for="description">Description</label>
                                                <input type="text" name="description" id="description"
                                                    class="form-control" value="{{ $room->description }}" required>
                                            </div>

                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-outline-info"><i class="fa-solid fa-paper-plane"></i> Update</button>
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>

                            {{-- delete model --}}
                            <button class="btn btn-outline-danger delete" id="{{ $room->id }}">
                                <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i>

                                <form action="{{ route('room.destroy', $room->id) }}" method="POST"
                                    id="deleteform{{ $room->id }}">
                                    @csrf
                                    @method('DELETE')
                                </form>
                            </button>

                        </td>
                    </tr>
                @endforeach

            </table>

        </div>

    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });


        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {

                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one item!!',
                });

            } else {

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('rooms.bulk.delete') }}",
                            method: "GET",
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                window.location.reload(true);
                            }
                        });

                        $(document).ready(function() {
                            Swal.fire({
                                icon: 'success',
                                title: 'deleted successfully!!',
                                showConfirmButton: false,
                                timer: 2000
                            });
                        });
                    }
                });

            }

        });

        var index = 0;
        // add row
        $("#addRow").on("click", function() {
            var tr =

                '<tr id="tr' + index + '">' +

                '<td><input type="text" value="" name="pax[]" id="pax' + index +
                '" class="form-control pax" style="text-align: center" required></td>' +

                '<td><input type="text" value="" name="price[]" id="price' + index +
                '" class="form-control price" style="text-align: center" required></td>' +

                '</td>' +

                '<td><button type="button" id="' + index + '" class="btn btn-danger removeRow">-</button></td>' +

                '</tr>';

            $("#tbody").append(tr);
            index++;

            $(".removeRow").on("click", function() {
                var id = $(this).attr("id");
                $("#tr" + id).remove();
            });
        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
