@extends('layouts.master')

@section('content')

    <div class="container-fluid">
        <form action="{{ route('get.sales.report') }}" method="get" class="was-validated">
            <div class="row">
                <div class="col-12">
                    <div class="card table-responsive">
                        <div class="card-header">
                            <table>
                                <tbody>
                                    <tr>
                                        @if ($status === 'itemized' || $status === '')
                                            @role('Admin')
                                                <td> <button type="button" class="btn btn-danger" id="deleteall"><i
                                                            class="fa-solid fa-trash-alt"></i>
                                                        Delete selected</button></td>
                                            @endrole
                                        @endif

                                        <td>
                                            <select name="status" id="status" class="form-control"
                                                style="text-align:center" required>
                                                <option value="" disabled selected>-- Choose Status --</option>
                                                <option value="general">-- General report --</option>
                                                <option value="itemized">-- Itemized report --</option>
                                            </select>
                                        </td>

                                        @if ($checkWaiters > 0)
                                            <td>
                                                <select name="waiter" id="waiter" class="form-control"
                                                    style="text-align:center" required>
                                                    <option value="" disabled selected>--Choose Waiter--</option>
                                                    <option value="All">-- All --</option>
                                                    <option value="0">--QR Code--</option>
                                                    @foreach ($waiters as $waiter)
                                                        <option value="{{ $waiter->id }}">-- {{ $waiter->name }} --
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                        @endif

                                        <td>
                                            <select name="type" id="type" class="form-control"
                                                style="text-align:center" required>
                                                <option value="" disabled selected>-- Choose Type --</option>
                                                <option value="all">-- All --</option>
                                                <option value="cash">-- Cash --</option>
                                                <option value="credit">-- Credit --</option>
                                            </select>
                                        </td>

                                        <td>
                                            @if ($sellingCount == 1)
                                                <input type="text" name="sehemu" id="sehemu" class="form-control"
                                                    readonly value="{{ $sellings[0]->location->name }}"
                                                    style="text-align: center">

                                                <input type="hidden" name="area" id="area" class="form-control"
                                                    readonly value="{{ $sellings[0]->id }}">
                                            @else
                                                <select name="area" id="area" class="form-control"
                                                    style="text-align: center" required>
                                                    <option disabled selected value="">-- Choose Location --
                                                    </option>
                                                    <option value="all">-- All --</option>
                                                    @foreach ($sellings as $selling)
                                                        <option value="{{ $selling->id }}">
                                                            -- {{ $selling->location->name }} --</option>
                                                    @endforeach
                                                </select>
                                            @endif
                                        </td>

                                        <td>
                                            <select name="duration" id="duration" class="form-control"
                                                style="text-align: center" required>
                                                <option disabled selected value="">-- Choose Duration --</option>
                                                <option value="today">-- Today --</option>
                                                <option value="set date">-- Set Date --</option>
                                                <option value="set duration">-- Set Duration --</option>
                                            </select>
                                        </td>

                                        <td><input type="date" name="start" id="start" class="form-control"
                                                style="text-align: center; display:none" required></td>
                                        <td><input type="date" name="end" id="end" class="form-control"
                                                style="text-align: center; display:none" required></td>

                                        <td> <button type="submit" id="search" class="btn btn-primary"><i
                                                    class="fa-solid fa-search"></i> Search</button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="card-body">
                            <table id="customer" class="table table-striped table-hover" style="text-align: center;">
                                <thead class="thead-dark">
                                    <tr>
                                        @if ($status == 'general')
                                            <th>Date</th>
                                            <th>Product</th>
                                            <th>Category</th>
                                            <th>Price</th>
                                            <th>Qty</th>
                                            <th>Location</th>
                                            <th>Amount</th>
                                            <th>Disc</th>
                                            <th>Net</th>
                                        @elseif ($status == 'itemized' || $status === '')
                                            @role('Admin')
                                                <th><input type="checkbox" id="checkall"></th>
                                            @endrole
                                            <th>Date</th>
                                            <th>Product</th>
                                            <th>Category</th>
                                            <th>Price</th>
                                            <th>Qty</th>
                                            <th>Customer</th>
                                            <th>Status</th>
                                            <th>Location</th>
                                            <th>Amount</th>
                                            <th>Disc</th>
                                            <th>Net</th>
                                            <th>User</th>
                                        @endif
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($results as $result)
                                        @php
                                            $customerData = App\Models\Customer::find($result->customer_id);

                                            $soldItems = App\Models\SoldItem::where('sale_id', $result->id)
                                                ->with('unit', 'product.category')
                                                ->get();
                                        @endphp

                                        @foreach ($soldItems as $item)
                                            @php
                                                $unitData = App\Models\unitAssigned::where(
                                                    'product_id',
                                                    $item->product_id,
                                                )
                                                    ->orderBy('unit_cont', 'ASC')
                                                    ->with('unit')
                                                    ->first();

                                                if ($item->product != null) {
                                                    if ($status == 'general') {
                                                        $product = $item->product->product;
                                                        if (array_key_exists($product, $proccessedItems)) {
                                                            $proccessedItems[$product]['qty'] += $item->qty;
                                                            $proccessedItems[$product]['amount'] += $item->amount;
                                                            $proccessedItems[$product]['discount'] += $item->discount;
                                                        } else {
                                                            $proccessedItems[$product] = [
                                                                'date' => $result->date,
                                                                'product' => $item->product->product,
                                                                'category' => $item->product->category->name ?? '-',
                                                                'unit' => $unitData->unit->name,
                                                                'cont' => $unitData->cont,
                                                                'price' => $item->price,
                                                                'qty' => $item->cont * $item->qty,
                                                                'amount' => $item->amount,
                                                                'discount' => $item->discount,
                                                                'location' => $result->selling->location->name,
                                                            ];
                                                        }
                                                    } else {
                                                        $productData = $item->product;
                                                        $unitData = $item->unit;
                                                    }
                                                }
                                            @endphp

                                            @if ($status == 'itemized')
                                                <tr>
                                                    @role('Admin')
                                                        <td><input type="checkbox" class="selected"
                                                                data-id="{{ $item->id }}"></td>
                                                    @endrole
                                                    <td>{{ $result->date }}</td>
                                                    <td class="text-left">
                                                        {{ $item->product ? $item->product->product : ($item->product()->withTrashed()->first() ? $item->product()->withTrashed()->first()->product : 'N/A') }}
                                                        {{ $item->batch_no ? '| Batch ' . $item->batch_no : '' }}
                                                    </td>
                                                    <td>{{ $item->product()->withTrashed()->first() && $item->product()->withTrashed()->first()->category ? $item->product()->withTrashed()->first()->category->name : 'N/A' }}
                                                    </td>
                                                    <td>
                                                        {{ number_format($tra != null ? $item->price * $tra : $item->price) }}
                                                    </td>

                                                    </td>
                                                    <td>{{ $item->qty }} ({{ $item->unit->name }})</td>
                                                    <td>{{ $result->customer == null ? '-' : $result->customer->name }}
                                                    </td>
                                                    <td>{{ $result->status }}</td>
                                                    <td>{{ $result->selling->location->name }}</td>
                                                    <td>{{ number_format($tra != null ? $item->amount * $tra : $item->amount) }}
                                                    </td>
                                                    <td>{{ $item->discount == null ? '-' : number_format($tra > 0 ? $item->discount * $tra : $item->discount) }}
                                                    </td>
                                                    <td>{{ $item->amount - $item->discount == 0 ? '-' : number_format($tra != null ? ($item->amount - $item->discount) * $tra : $item->amount - $item->discount) }}
                                                    </td>
                                                    <td>{{ $result->user->name }} @if ($checkWaiters > 0)
                                                            ({{ $result->waiter ? $result->waiter->name : 'QR Code' }})
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    @endforeach

                                    @if ($status == 'general')
                                        @foreach ($proccessedItems as $processedItem)
                                            <tr>
                                                <td>{{ $processedItem['date'] }}</td>
                                                <td>{{ $processedItem['product'] }}</td>
                                                <td>{{ $processedItem['category'] }}</td>
                                                <td>{{ number_format($tra != null ? $processedItem['price'] * $tra : $processedItem['price']) }}
                                                </td>
                                                <td>{{ $processedItem['qty'] }} ({{ $processedItem['unit'] }})
                                                </td>
                                                <td>{{ $processedItem['location'] }}</td>
                                                <td>{{ number_format($tra != null ? $processedItem['amount'] * $tra : $processedItem['amount']) }}
                                                </td>
                                                <td>{{ $processedItem['discount'] == null ? '-' : number_format($tra != null ? $processedItem['discount'] * $tra : $processedItem['discount']) }}
                                                </td>
                                                <td>{{ number_format($tra != null ? ($processedItem['amount'] - $processedItem['discount']) * $tra : $processedItem['amount'] - $processedItem['discount']) }}
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>

                                <tfoot>
                                    @if ($status == 'general')
                                        <tr>
                                            <th>Date</th>
                                            <th>Product</th>
                                            <th>Category</th>
                                            <th>Price</th>
                                            <th>Qty</th>
                                            <th>Location</th>
                                            <th>Total
                                                ({{ number_format($tra != null ? $salesTotal * $tra : $salesTotal) }})
                                            </th>
                                            <th>Disc
                                                ({{ number_format($tra != null ? $salesDiscount * $tra : $salesDiscount) }})
                                            </th>
                                            <th>Net ({{ number_format($tra != null ? $salesNet * $tra : $salesNet) }})
                                            </th>
                                        </tr>
                                    @elseif ($status == 'itemized' || $status == '')
                                        <tr>
                                            @role('Admin')
                                                <th colspan="4">
                                                @else
                                                <th colspan="3">
                                                @endrole
                                                <div class="container">
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <input type="date" name="changedate" id="date"
                                                                class="form-control" style="text-align: center">
                                                        </div>
                                                        <div class="col">
                                                            <button type="button" id="changedate"
                                                                class="btn btn-block btn-success"><i
                                                                    class="fa fa-calendar fa-lg"></i> Change
                                                                date</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </th>
                                            <th>Price</th>
                                            <th>Qty</th>
                                            <th>Customer</th>
                                            <th>Status</th>
                                            <th>Location</th>
                                            <th>Total
                                                ({{ number_format($tra != null ? $salesTotal * $tra : $salesTotal) }})
                                            </th>
                                            <th>Disc
                                                ({{ number_format($tra != null ? $salesDiscount * $tra : $salesDiscount) }})
                                            </th>
                                            <th>Net ({{ number_format($tra != null ? $salesNet * $tra : $salesNet) }})
                                            </th>
                                            <th>User</th>
                                        </tr>
                                    @endif
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                {{--  sales per location  --}}
                <div class="col-12 table-responsive">
                    <div class="card table-responsive">
                        <div class="card-header">
                            <h5>Sales per location</h5>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover table-striped align-middle shadow-sm"
                                    style="background: #fff;">
                                    <thead class="thead-dark" style="background: #343a40; color: #fff;">
                                        <tr>
                                            <th style="width: 40%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fas fa-map-pin mr-1 text-primary"></i> Location
                                            </th>
                                            <th style="width: 20%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-money-bill-wave mr-1 text-success"></i> Total Sales
                                            </th>
                                            <th style="width: 20%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-check-circle mr-1 text-info"></i> Paid
                                            </th>
                                            <th style="width: 20%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-exclamation-circle mr-1 text-danger"></i> Pending
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $overall_location_total = 0;
                                            $overall_paid_total = 0;
                                            $overall_due_total = 0;
                                        @endphp
                                        @foreach ($sellings as $sehemu)
                                            @php
                                                $location_total = 0;
                                                $paid_amount = 0;
                                                $due_amount = 0;

                                                if ($duration == 'today' && $type == 'all') {
                                                    $location_total = App\Models\Sale::where('date', $currentDate)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('net');
                                                    $paid_amount = App\Models\Sale::where('date', $currentDate)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('paid');
                                                    $due_amount = App\Models\Sale::where('date', $currentDate)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('due');
                                                } elseif ($duration == 'today' && $type != 'all') {
                                                    $location_total = App\Models\Sale::where('date', $currentDate)
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('net');
                                                    $paid_amount = App\Models\Sale::where('date', $currentDate)
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('paid');
                                                    $due_amount = App\Models\Sale::where('date', $currentDate)
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('due');
                                                } elseif ($duration == 'set date' && $type == 'all') {
                                                    $location_total = App\Models\Sale::where('date', $start)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('net');
                                                    $paid_amount = App\Models\Sale::where('date', $start)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('paid');
                                                    $due_amount = App\Models\Sale::where('date', $start)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('due');
                                                } elseif ($duration == 'set date' && $type != 'all') {
                                                    $location_total = App\Models\Sale::where('date', $start)
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('net');
                                                    $paid_amount = App\Models\Sale::where('date', $start)
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('paid');
                                                    $due_amount = App\Models\Sale::where('date', $start)
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('due');
                                                } elseif ($duration == 'set duration' && $type == 'all') {
                                                    $location_total = App\Models\Sale::whereBetween('date', [
                                                        $start,
                                                        $end,
                                                    ])
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('net');
                                                    $paid_amount = App\Models\Sale::whereBetween('date', [$start, $end])
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('paid');
                                                    $due_amount = App\Models\Sale::whereBetween('date', [$start, $end])
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('due');
                                                } elseif ($duration == 'set duration' && $type != 'all') {
                                                    $location_total = App\Models\Sale::whereBetween('date', [
                                                        $start,
                                                        $end,
                                                    ])
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('net');
                                                    $paid_amount = App\Models\Sale::whereBetween('date', [$start, $end])
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('paid');
                                                    $due_amount = App\Models\Sale::whereBetween('date', [$start, $end])
                                                        ->where('status', $type)
                                                        ->where('selling_id', $sehemu->id)
                                                        ->sum('due');
                                                }

                                                $overall_location_total += $location_total;
                                                $overall_paid_total += $paid_amount;
                                                $overall_due_total += $due_amount;
                                            @endphp
                                            <tr>
                                                <td>
                                                    <span class="font-weight-bold" style="font-size: 1.05rem;">
                                                        <i class="fas fa-map-pin text-primary"></i>
                                                        {{ $sehemu->location->name }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="text-success font-weight-bold"
                                                        style="font-size: 1.1rem;">
                                                        {{ number_format($tra != null ? $location_total * $tra : $location_total) }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="text-info font-weight-bold" style="font-size: 1.1rem;">
                                                        {{ number_format($tra != null ? $paid_amount * $tra : $paid_amount) }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="{{ route('sales.report.pending.debts', [
                                                        isset($sehemu->id) ? $sehemu->id : '-',
                                                        isset($duration) ? $duration : '-',
                                                        isset($start) ? $start : '-',
                                                        isset($end) ? $end : '-',
                                                    ]) }}"
                                                        class="text-danger font-weight-bold"
                                                        style="font-size: 1.1rem; text-decoration: underline;">
                                                        {{ number_format($tra != null ? $due_amount * $tra : $due_amount) }}
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr style="background: #f8f9fa;">
                                            <th class="text-right" style="font-size: 1.1rem;">
                                                <i class="fa fa-calculator text-secondary"></i> Location Total Sales
                                            </th>
                                            <th class="text-success" style="font-size: 1.15rem;">
                                                {{ number_format($tra != null ? $overall_location_total * $tra : $overall_location_total) }}
                                            </th>
                                            <th class="text-info" style="font-size: 1.15rem;">
                                                {{ number_format($tra != null ? $overall_paid_total * $tra : $overall_paid_total) }}
                                            </th>
                                            <th class="text-danger" style="font-size: 1.15rem;">
                                                {{ number_format($tra != null ? $overall_due_total * $tra : $overall_due_total) }}
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                {{--  sales per user  --}}
                <div class="col-12">

                    <div class="card table-responsive">
                        <div class="card-header">
                            <h5>Sales per user</h5>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover table-striped align-middle shadow-sm"
                                    style="background: #fff;">
                                    <thead class="thead-dark" style="background: #343a40; color: #fff;">
                                        <tr>
                                            <th style="width: 60%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-user mr-1 text-primary"></i> User
                                            </th>
                                            <th style="width: 40%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-money-bill-wave mr-1 text-success"></i> Total Sales
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $overall_user_total = 0;
                                        @endphp
                                        @foreach (App\Models\User::all() as $user)
                                            @php
                                                $user_total = 0;
                                                if ($duration == 'today' && $type == 'all') {
                                                    $user_total += App\Models\Sale::where('date', $currentDate)
                                                        ->where('user_id', $user->id)
                                                        ->sum('net');
                                                    $overall_user_total += $user_total;
                                                } elseif ($duration == 'today' && $type != 'all') {
                                                    $user_total += App\Models\Sale::where('date', $currentDate)
                                                        ->where('status', $type)
                                                        ->where('user_id', $user->id)
                                                        ->sum('net');
                                                    $overall_user_total += $user_total;
                                                } elseif ($duration == 'set date' && $type == 'all') {
                                                    $user_total += App\Models\Sale::where('date', $start)
                                                        ->where('user_id', $user->id)
                                                        ->sum('net');
                                                    $overall_user_total += $user_total;
                                                } elseif ($duration == 'set date' && $type != 'all') {
                                                    $user_total += App\Models\Sale::where('date', $start)
                                                        ->where('status', $type)
                                                        ->where('user_id', $user->id)
                                                        ->sum('net');
                                                    $overall_user_total += $user_total;
                                                } elseif ($duration == 'set duration' && $type == 'all') {
                                                    $user_total += App\Models\Sale::whereBetween('date', [$start, $end])
                                                        ->where('user_id', $user->id)
                                                        ->sum('net');
                                                    $overall_user_total += $user_total;
                                                } elseif ($duration == 'set duration' && $type != 'all') {
                                                    $user_total += App\Models\Sale::whereBetween('date', [$start, $end])
                                                        ->where('user_id', $user->id)
                                                        ->where('status', $type)
                                                        ->sum('net');
                                                    $overall_user_total += $user_total;
                                                }
                                            @endphp
                                            <tr>
                                                <td>
                                                    <span class="font-weight-bold ml-2" style="font-size: 1.05rem;">
                                                        <i class="fa fa-user-circle text-info"></i> {{ $user->name }}
                                                    </span>
                                                    @if ($user->email)
                                                        <span class="text-muted ml-2" style="font-size: 0.95rem;">
                                                            <i class="fa fa-envelope"></i> {{ $user->email }}
                                                        </span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <span class="text-success font-weight-bold"
                                                        style="font-size: 1.15rem;">
                                                        {{ number_format($tra != null ? $user_total * $tra : $user_total) }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr style="background: #f8f9fa;">
                                            <th class="text-right" style="font-size: 1.1rem;">
                                                <i class="fa fa-calculator text-secondary"></i> Users Total Sale
                                            </th>
                                            <th class="text-success" style="font-size: 1.15rem;">
                                                {{ number_format($tra != null ? $overall_user_total * $tra : $overall_user_total) }}
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                {{--  sales per waiter  --}}
                @if ($checkWaiters > 0)
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5>Sales per waiter</h5>
                            </div>

                            <div class="card-body">
                                <div class="table-responsive mt-3 shadow-sm">
                                    <table class="table table-bordered table-hover align-middle text-center">
                                        <thead class="table-dark">
                                            <tr>
                                                <th><i class="fas fa-user-tie me-1"></i> Waiter</th>
                                                <th><i class="fas fa-coins me-1"></i> Total Sale</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @php
                                                $overall_waiter_total = 0;
                                            @endphp

                                            @foreach ($waiters as $waiter)
                                                @php
                                                    $waiter_total = 0;
                                                    $kitchenSales = 0;
                                                    $counterSales = 0;

                                                    $categoryData = App\Models\ProductCategory::where(
                                                        'name',
                                                        'Menu',
                                                    )->first();

                                                    $waiterSalesQuery = App\Models\Sale::query()->where(
                                                        'waiter_id',
                                                        $waiter->id,
                                                    );

                                                    if ($duration == 'today') {
                                                        $waiterSalesQuery->where('date', $currentDate);
                                                    } elseif ($duration == 'set date') {
                                                        $waiterSalesQuery->where('date', $start);
                                                    } elseif ($duration == 'set duration') {
                                                        $waiterSalesQuery->whereBetween('date', [$start, $end]);
                                                    }

                                                    if ($type != 'all') {
                                                        $waiterSalesQuery->where('status', $type);
                                                    }

                                                    $waiterSales = $waiterSalesQuery->with('soldItems.product')->get();

                                                    foreach ($waiterSales as $sale) {
                                                        $waiter_total += $sale->net;

                                                        foreach ($sale->soldItems as $item) {
                                                            if (
                                                                $item->product &&
                                                                $item->product->category_id == $categoryData->id
                                                            ) {
                                                                $kitchenSales += $item->amount;
                                                            } else {
                                                                $counterSales += $item->amount;
                                                            }
                                                        }
                                                    }

                                                    $overall_waiter_total += $waiter_total;
                                                @endphp

                                                <tr>
                                                    <td class="text-start">
                                                        <strong><i
                                                                class="fas fa-user me-1 text-primary"></i>{{ $waiter->name }}</strong><br>
                                                        <span class="badge bg-warning text-dark">
                                                            <i class="fas fa-utensils"></i> Kitchen:
                                                            {{ number_format($kitchenSales) }}
                                                        </span>
                                                        <span class="badge bg-info text-dark">
                                                            <i class="fas fa-concierge-bell"></i> Counter:
                                                            {{ number_format($counterSales) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-bold text-success">
                                                            {{ number_format($waiter_total) }}
                                                        </span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>

                                        <tfoot class="table-light">
                                            <tr>
                                                <th class="text-end"><i class="fas fa-chart-line me-1 text-primary"></i>
                                                    Total from All Waiters</th>
                                                <th class="text-success fw-bold">
                                                    <i
                                                        class="fas fa-coins me-1"></i>{{ number_format($overall_waiter_total) }}
                                                </th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>
                @endif


                {{--  Cash per account  --}}
                <div class="col-12">
                    <div class="card table-responsive">
                        <div class="card-header">
                            <h5>Amount recieved in each account</h5>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover table-striped align-middle shadow-sm"
                                    style="background: #fff;">
                                    <thead class="thead-dark" style="background: #343a40; color: #fff;">
                                        <tr>
                                            <th style="width: 50%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-university mr-1 text-primary"></i> Account
                                            </th>
                                            <th style="width: 30%; font-size: 1.1rem; letter-spacing: 1px;">
                                                <i class="fa fa-money-bill-wave mr-1 text-success"></i> Total Received
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $overall_account_total = 0;
                                        @endphp
                                        @foreach ($accounts as $account)
                                            @php
                                                $account_total = 0;
                                                $salesQuery = App\Models\Sale::query()->where(
                                                    'account_id',
                                                    $account->id,
                                                );

                                                if ($duration == 'today') {
                                                    $salesQuery->where('date', $currentDate);
                                                } elseif ($duration == 'set date') {
                                                    $salesQuery->where('date', $start);
                                                } elseif ($duration == 'set duration') {
                                                    $salesQuery->whereBetween('date', [$start, $end]);
                                                }

                                                if ($type != 'all') {
                                                    $salesQuery->where('status', $type);
                                                }

                                                $account_total = $salesQuery->sum('paid');
                                                $overall_account_total += $account_total;
                                            @endphp
                                            <tr>
                                                <td class="text-start">
                                                    <i class="fa fa-university text-primary"></i>
                                                    <strong>{{ $account->type }} - {{ $account->name }}</strong>
                                                    <span class="text-muted ml-2">
                                                        <i class="fas fa-map-pin mr-1 text-primary"></i>
                                                        {{ $account->selling->location->name }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="text-success font-weight-bold"
                                                        style="font-size: 1.15rem;">
                                                        {{ number_format($tra != null ? $account_total * $tra : $account_total) }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr style="background: #f8f9fa;">
                                            <th class="text-right" style="font-size: 1.1rem;">
                                                <i class="fa fa-calculator text-secondary"></i> Accounts Total
                                            </th>
                                            <th class="text-success" style="font-size: 1.15rem;">
                                                {{ number_format($tra != null ? $overall_account_total * $tra : $overall_account_total) }}
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            $("#customer").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            //global variable
            var type = "";
            var area = "";
            var start = "";
            var end = "";

            $("#area").on("change", function() {
                area = $(this).val();
            });

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#duration").on("change", function() {
                type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });

            $("#checkall").on("click", function() {
                $(".selected").prop('checked', this.checked);
            });

            $("#deleteall").on("click", function() {
                let selected = [];

                $(".selected:checked").each(function() {
                    selected.push($(this).data("id")); // using data-id instead of id
                });

                if (selected.length === 0) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select at least one item!',
                    });
                } else {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('sales.bulk.delete') }}",
                                method: "POST", // safer than GET
                                data: {
                                    ids: selected,
                                    _token: $('meta[name="csrf-token"]').attr('content')
                                },
                                success: function(response) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: "Deleted Successfully",
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    }).then(() => {
                                        window.location.reload(true);
                                    });
                                }
                            });
                        }
                    });
                }
            });

            let change;
            $("#date").on("change", function() {
                change = $(this).val();
            });

            $("#changedate").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).data("id")); // using data-id instead of id
                });

                if (selected.length == 0) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });
                } else {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "Your about to change selected sale(s) date!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, change date!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('change.sales.date') }}",
                                method: "GET",
                                data: {
                                    'ids': selected,
                                    'newdate': change
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Date updated successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });
                }

            });

        });
    </script>
@endsection

@endsection
