@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            Assign product to <strong>{{ $service->product }}</strong>
        </div>

        <form action="{{ route('assign.products', $service->id) }}" method="post" class="was-validated">
            @csrf

            <input type="hidden" id="location" name="location" class="form-control",
                value="{{ $service->location->id }}">

            <div class="card-body">
                <table class="table table-bordered table-hover table-striped align-middle text-center shadow-sm rounded">
                    <thead class="table-primary">
                        <tr>
                            <th style="width: 5%">#</th>
                            <th>Product</th>
                            <th style="width: 13%">Unit</th>
                            <th style="width: 13%">Price</th>
                            <th style="width: 10%">Qty</th>
                            <th>
                                <button type="button" class="btn btn-sm btn-success addRow" id="addRow" title="Add Row">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="tbody">
                        <!-- Dynamic rows will be appended here -->
                    </tbody>
                </table>
            </div>

            <div class="card-footer">
                <center><button type="submit" class="btn btn-primary"><i class="fas fa-paper-plane"></i> Assign
                        products</button>
                </center>
            </div>
        </form>
    </div>

@section('scripts')
    <script>
        var index = 1;
        // add row
        $(".addRow").on("click", function() {
            let tr = `
                    <tr id="tr${index}">
                        <td>
                            <input type="hidden" value="" name="id[]" id="id${index}" class="form-control id" style="text-align: center" readonly>
                            ${index}
                        </td>

                        <td style="position: relative">
                            <input type="search" name="product[]" class="form-control search" id="search${index}" placeholder="Search by product name or barcode.." required>
                            <div id="list${index}" style="display:none; position: absolute; z-index: 10; width: 95%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);" class="bg-white border border-primary">
                                <ol id="results${index}" class="list-group list-group-flush"></ol>
                            </div>
                        </td>

                        <td>
                            <select class="form-control unit" name="unit[]" id="unit${index}" required style="text-align:center">
                                <!-- Fill options via JS or embed via JSON -->
                            </select>
                        </td>

                        <td><input type="text" name="price[]" id="price${index}" class="form-control price" style="text-align: center" readonly></td>
                        <td><input type="text" name="qty[]" id="qty${index}" class="form-control qty" style="text-align: center" required></td>
                        <td>
                            <button type="button" id="${index}" class="btn btn-danger removeRow">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </td>
                    </tr>
                `;

            $("#tbody").append(tr);
            index++;

            $(".removeRow").off("click").on("click", function() {
                let id = $(this).attr("id");
                $("#tr" + id).remove();
            });
        });


        $(document).on("keyup", ".search", function() {
            let ujumbe = "No suggestions..";
            let query = $(this).val();
            let id = $(this).attr('id').replace("search", "");
            let locationId = $("#location").val();

            $.ajax({
                url: "{{ route('get.location.product') }}",
                method: "get",
                data: {
                    'query': query,
                    'locationId': locationId,
                },
                success: function(data) {
                    $("#results" + id).empty();
                    console.log(data);

                    if (query != "") {
                        if (data.length == 0) {
                            $("#list" + id).fadeIn("slow");
                            $("#results" + id).append(
                                '<li><button type="button" class="btn btn-outline-secondary form-control items"">' +
                                ujumbe + '</button></li>');
                        }

                        for (var i = 0; i < data.length; i++) {
                            $("#list" + id).fadeIn("slow");
                            $("#results" + id).append(
                                '<li><button type="button" id="' + i +
                                '" class="btn btn-outline-secondary form-control items"">' +
                                data[i].product + '</button></li>');
                        }
                    }

                    $(".items").on("click", function() {
                        let index1 = $(this).attr("id");
                        let productname = data[index1].product;
                        let productid = data[index1].id;
                        let units = data[index1].unit.unit;

                        $("#list" + id).fadeOut("slow");
                        $("#search" + id).val(productname);
                        $("#id" + id).val(productid);
                        // clear the unit select options
                        $("#unit" + id).empty().append(
                            '<option value="">-- Unit --</option>');
                        // Populate the unit select with new data
                        $.each(data[index1].unit, function(key, val) {
                            $("#unit" + id).append('<option value="' + val
                                .unit.id + '">-- ' + val.unit.name +
                                ' --</option>');
                        });

                        $("#unit" + id).val(units);
                    });
                }
            });
        });

        $(document).on("change", ".unit", function() {
            let unitId = $(this).val();
            let id = $(this).attr("id").replace("unit", "");
            let productId = $("#id" + id).val();
            let locationId = $("#service-area").val();

            $.ajax({
                url: "{{ route('unit.details') }}",
                method: "get",
                data: {
                    'unitId': unitId,
                    'productId': productId,
                    'locationId': locationId,
                },
                success: function(data) {
                    console.log(data);
                    $("#price" + id).val(data.selling);
                }
            });
        });
    </script>
@endsection

@endsection
